import{html}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";export function getTemplate(){return html`<!--_html_template_start_--><!--
Copyright 2020 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->
<!--
Element for list of tasks with tri-state icon (pending, active, completed)

Example:
  <progress-list-item text-key="thirdItemKey"
      active="[[equal_(step, 3)]]"
      completed="[[greater_(step, 3)]]">
  </progress-list-item>

Attributes and properties:
  'textKey' - localization key for the item text
  'activeKey' - if specified, overrides textKey for active state
  'completedKey' - if specified, overrides textKey for completed state
  'active' - if set, the item is considered to be in active state.
  'completed' - if active is not set, and completed is set, the item is
                considered to be in completed state.
-->
<style include="oobe-common-styles">#container{height:56px}#icon{min-width:48px}#icon-pending{background-color:var(--cros-icon-color-disabled);border-radius:50%;height:8px;margin-inline-start:8px;width:8px}:host-context(.jelly-enabled) #icon-pending{background-color:var(--cros-sys-on_surface)}#icon-active{height:24px;width:24px}:host-context(.jelly-enabled) #icon-active{--paper-spinner-color:var(--cros-sys-primary)}#icon-completed{color:var(--cros-icon-color-blue)}:host-context(.jelly-enabled) #icon-completed{color:var(--cros-sys-primary)}#text{color:var(--oobe-text-color);font-family:var(--oobe-default-font-family);font-size:15px;line-height:16px}:host-context(.jelly-enabled) #text{color:var(--cros-sys-on_surface_variant);font-family:var(--cros-button-1-font-family);font-size:var(--cros-button-1-font-size);font-weight:var(--cros-button-1-font-weight);line-height:var(--cros-button-1-line-height)}#text-active{color:var(--cros-text-color-primary)}:host-context(.jelly-enabled) #text-active{color:var(--cros-sys-on_surface)}</style>

<div class="flex layout horizontal center" id="container" role="listitem">
  <div id="icon">
    <div id="icon-pending" class="dot"
        hidden="[[hidePending(active, completed)]]"></div>
    <paper-spinner-lite id="icon-active" hidden="[[!active]]" active>
    </paper-spinner-lite>
    <iron-icon id="icon-completed" icon="cr:check"
          hidden="[[hideCompleted(active, completed)]]"></iron-icon>
  </div>
  <div id="text" class="content">
    <div id="text-pending" hidden="[[hidePending(active, completed)]]">
      [[i18nDynamic(locale, textKey)]]
    </div>
    <div id="text-active" hidden="[[!active]]">
      [[fallbackText(locale, activeKey, textKey)]]
    </div>
    <div id="text-completed"
          hidden="[[hideCompleted(active, completed)]]">
      [[fallbackText(locale, completedKey, textKey)]]
    </div>
  </div>
</div>
<!--_html_template_end_-->`}