// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assert}from"//resources/js/assert.js";const BLACK_FILL="#202124";const WHITE_FILL="#ffffff";const DEFAULT_SIZE=400;const RADIUS_PERCENTAGE=.75;export class QrCodeCanvas{constructor(canvas){this.canvas=canvas;const context=canvas.getContext("2d");assert(context instanceof CanvasRenderingContext2D);this.context=context;this.observer=new ResizeObserver(this.onResize.bind(this));this.observer.observe(this.canvas);this.qrCode=null;this.useCircles=true;this.canvasSize=0;this.cellCount=0;this.cellSizePx=0;this.dotRadiusPx=0;this.fiducialCellCount=0}setData(qrData){this.qrCode=qrData;this.updateInternal();this.drawQrCode()}updateInternal(){const canvasSizeOnScreen=Math.ceil(this.canvas.clientHeight);const canvasSize=canvasSizeOnScreen>0?canvasSizeOnScreen*window.devicePixelRatio*2:DEFAULT_SIZE;this.canvasSize=canvasSize;this.canvas.height=this.canvas.width=this.canvasSize;if(this.qrCode){this.cellCount=Math.round(Math.sqrt(this.qrCode.length));this.cellSizePx=this.canvasSize/this.cellCount}else{this.cellCount=0;this.cellSizePx=0}this.dotRadiusPx=this.cellSizePx/2*RADIUS_PERCENTAGE;this.fiducialCellCount=this.determineFiducialSize();if(this.fiducialCellCount===0){this.useCircles=false}this.canvas.qrCellCount=this.cellCount}toggleMode(){this.useCircles=!this.useCircles;this.updateInternal();this.drawQrCode()}drawQrCode(){this.drawDataPoints();if(this.useCircles){const fiducialSizePx=this.fiducialCellCount*this.cellSizePx;const fiducialRadiusPx=fiducialSizePx/2;this.drawFiducial(0+fiducialRadiusPx,0+fiducialRadiusPx,fiducialSizePx);this.drawFiducial(this.canvasSize-fiducialRadiusPx,0+fiducialRadiusPx,fiducialSizePx);this.drawFiducial(0+fiducialRadiusPx,this.canvasSize-fiducialRadiusPx,fiducialSizePx)}}drawDataPoints(){this.context.clearRect(0,0,this.canvasSize,this.canvasSize);this.context.fillStyle=BLACK_FILL;const OFFSET=this.cellSizePx/2;for(let y=0;y<this.cellCount;y++){for(let x=0;x<this.cellCount;x++){const index=y*this.cellCount+x;if(this.qrCode&&this.qrCode[index]){if(this.useCircles){this.context.beginPath();this.context.arc(x*this.cellSizePx+OFFSET,y*this.cellSizePx+OFFSET,this.dotRadiusPx,0,2*Math.PI);this.context.fill()}else{this.context.fillRect(x*this.cellSizePx,y*this.cellSizePx,this.cellSizePx,this.cellSizePx)}}}}}drawFiducial(xPos,yPos,sizeInPixels){this.context.fillStyle=WHITE_FILL;this.context.fillRect(xPos-sizeInPixels/2,yPos-sizeInPixels/2,sizeInPixels,sizeInPixels);const outermostCircleRadius=sizeInPixels/2;const intermediateCircleRadius=outermostCircleRadius-this.cellSizePx;const innermostCircleRadius=intermediateCircleRadius-this.cellSizePx;this.drawCircle(xPos,yPos,outermostCircleRadius,BLACK_FILL);this.drawCircle(xPos,yPos,intermediateCircleRadius,WHITE_FILL);this.drawCircle(xPos,yPos,innermostCircleRadius,BLACK_FILL)}drawCircle(x,y,radius,fillStyle){this.context.fillStyle=fillStyle;this.context.beginPath();this.context.arc(x,y,radius,0,2*Math.PI);this.context.fill()}determineFiducialSize(){let fiducialSize=0;for(let index=0;index<this.cellCount/2;index++){if(this.qrCode&&this.qrCode[index]){fiducialSize++}else{return fiducialSize}}return 0}onResize(){if(this.qrCode){this.updateInternal();this.drawQrCode()}}}