// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/polymer/v3_0/iron-icon/iron-icon.js";import"//resources/ash/common/quick_unlock/pin_keyboard.js";import"//resources/ash/common/cr_elements/icons.html.js";import"./oobe_icons.html.js";import"./buttons/oobe_back_button.js";import"./buttons/oobe_next_button.js";import"./common_styles/oobe_common_styles.css.js";import"./common_styles/oobe_dialog_host_styles.css.js";import"./dialogs/oobe_adaptive_dialog.js";import{PinKeyboardElement}from"//resources/ash/common/quick_unlock/pin_keyboard.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{assert}from"chrome://resources/js/assert.js";import{OobeDialogHostMixin}from"./mixins/oobe_dialog_host_mixin.js";import{OobeI18nMixin}from"./mixins/oobe_i18n_mixin.js";import{getTemplate}from"./security_token_pin.html.js";const SecurityTokenPinBase=OobeDialogHostMixin(OobeI18nMixin(PolymerElement));export class SecurityTokenPin extends SecurityTokenPinBase{static get is(){return"security-token-pin"}static get template(){return getTemplate()}static get properties(){return{parameters:{type:Object,observer:"onParametersChanged"},processingCompletion:{type:Boolean,value:false},hasValue:{type:Boolean,value:false},userEdited:{type:Boolean,value:false},canEdit:{type:Boolean,computed:"computeCanEdit(parameters.enableUserInput, processingCompletion)"},canSubmit:{type:Boolean,computed:"computeCanSubmit(parameters.enableUserInput, "+"hasValue, processingCompletion)"}}}focus(){this.getPinKeyboard().focusInputSynchronously()}computeCanEdit(enableUserInput,processingCompletion){return enableUserInput&&!processingCompletion}computeCanSubmit(enableUserInput,hasValue,processingCompletion){return enableUserInput&&hasValue&&!processingCompletion}onBackClicked(){this.dispatchEvent(new CustomEvent("cancel",{bubbles:true,composed:true}))}getPinKeyboard(){const pinKeyboard=this.shadowRoot?.querySelector("#pinKeyboard");assert(pinKeyboard instanceof PinKeyboardElement);return pinKeyboard}onSubmit(){if(!this.canSubmit){return}this.processingCompletion=true;this.dispatchEvent(new CustomEvent("completed",{bubbles:true,composed:true,detail:this.getPinKeyboard().value}))}onParametersChanged(){this.getPinKeyboard().value="";this.processingCompletion=false;this.hasValue=false;this.userEdited=false;this.focus()}onPinChange(e){this.hasValue=e.detail.pin.length>0;this.userEdited=true}isErrorLabelVisible(parameters,userEdited){return parameters&&parameters.hasError&&!userEdited}isAttemptsLeftVisible(parameters){return parameters&&parameters.formattedAttemptsLeft!==""}isLabelVisible(parameters,userEdited){return this.isErrorLabelVisible(parameters,userEdited)||this.isAttemptsLeftVisible(parameters)}getLabel(parameters,userEdited){if(!this.isLabelVisible(parameters,userEdited)){return""}if(!this.isErrorLabelVisible(parameters,userEdited)&&this.isAttemptsLeftVisible(parameters)){return parameters.formattedAttemptsLeft}return parameters.formattedError}}customElements.define(SecurityTokenPin.is,SecurityTokenPin);