// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assert}from"//resources/js/assert.js";import{loadTimeData}from"//resources/js/load_time_data.js";export const CLEAR_ANCHORS_CONTENT_SCRIPT={code:'A=Array.from(document.getElementsByTagName("a"));'+"for(let i = 0; i < A.length; ++i) {"+"  const el = A[i];"+'  let e = document.createElement("span");'+"  if (el.textContent.trim().length > 0) {"+'    e.textContent=el.textContent + "(" + el.href + ")";'+"  }"+"  el.parentNode.replaceChild(e,el);"+"}"};const GENERATE_FONTS_CSS=()=>{const isOobeJellyEnabled=loadTimeData.getBoolean("isOobeJellyEnabled");if(!isOobeJellyEnabled){return{code:`body * {\n            font-family: Roboto, sans-serif !important;\n            font-size: 13px !important;\n            line-height: 20px !important;}\n            body h2 {\n             font-size: 15px !important;\n             line-height: 22px !important;}`}}return{code:`body * {\n      font-family: 'Google Sans Text Regular', 'Google Sans', 'Roboto', sans-serif !important;\n      font-size: 13px !important;\n      font-weight: 400 !important;\n      line-height: 20px !important;}\n      body h2 {\n       font-family: 'Google Sans Text Medium', 'Google Sans', 'Roboto', sans-serif !important;\n       font-size: 13px !important;\n       font-weight: 500 !important;\n       line-height: 20px !important;}`}};const WEB_VIEW_FONTS_CSS=GENERATE_FONTS_CSS();const ONLINE_RETRY_BACKOFF_TIMEOUT_IN_MS=1e3;const FIRST_LOAD_RESULT_HISTOGRAM="OOBE.WebViewLoader.FirstLoadResult";var OobeWebViewLoadResult;(function(OobeWebViewLoadResult){OobeWebViewLoadResult[OobeWebViewLoadResult["SUCCESS"]=0]="SUCCESS";OobeWebViewLoadResult[OobeWebViewLoadResult["LOAD_TIMEOUT"]=1]="LOAD_TIMEOUT";OobeWebViewLoadResult[OobeWebViewLoadResult["LOAD_ERROR"]=2]="LOAD_ERROR";OobeWebViewLoadResult[OobeWebViewLoadResult["HTTP_ERROR"]=3]="HTTP_ERROR";OobeWebViewLoadResult[OobeWebViewLoadResult["MAX"]=4]="MAX"})(OobeWebViewLoadResult||(OobeWebViewLoadResult={}));export class WebViewLoader{static{this.instances={}}constructor(webview,timeout,loadFailureCallback,clearAnchors,injectCss){assert(webview.tagName==="WEBVIEW");if(WebViewLoader.instances[webview.id]){return WebViewLoader.instances[webview.id]}this.webview=webview;this.timeout=timeout;this.isPerformingRequests=false;this.reloadRequested=false;this.loadTimer=0;this.backOffTimer=0;this.loadFailureCallback=loadFailureCallback;this.url="";this.loadResultRecorded=false;if(clearAnchors){webview.addEventListener("contentload",(()=>{webview.executeScript(CLEAR_ANCHORS_CONTENT_SCRIPT,(()=>{if(chrome.runtime.lastError){console.warn("Clear anchors script failed: "+chrome.runtime.lastError.message)}}))}))}if(injectCss){webview.addEventListener("contentload",(()=>{webview.insertCSS(WEB_VIEW_FONTS_CSS,(()=>{if(chrome.runtime.lastError){console.warn("Failed to insertCSS: "+chrome.runtime.lastError.message)}}))}))}const request=this.webview.request;assert(this.isWebRequestObserver(request));request.onCompleted.addListener(this.onCompleted.bind(this),{urls:["<all_urls>"],types:["main_frame"]});request.onErrorOccurred.addListener(this.onErrorOccurred.bind(this),{urls:["<all_urls>"],types:["main_frame"]});WebViewLoader.instances[webview.id]=this}isWebRequestObserver(obj){return"onCompleted"in obj&&"onErrorOccurred"in obj}clearInternalState(){window.clearTimeout(this.loadTimer);window.clearTimeout(this.backOffTimer);this.isPerformingRequests=false;this.reloadRequested=false}setUrl(url){assert(/^https?:\/\//.test(url));if(url!==this.url){this.clearInternalState();this.url=url;this.loadWithFallbackTimer()}else{if(this.isPerformingRequests){this.reloadRequested=true}else{this.loadWithFallbackTimer()}}}onTimeoutError(){console.warn("Loading "+this.url+" timed out");if(!this.isPerformingRequests){return}if(!this.loadResultRecorded){this.loadResultRecorded=true;this.recordUmaHistogramForFirstLoadResult(OobeWebViewLoadResult.LOAD_TIMEOUT)}if(this.reloadRequested){this.loadWithFallbackTimer()}else{this.clearInternalState();this.loadFailureCallback()}}onErrorOccurred(details){console.warn("Failed to load "+details.url+" with error "+details.error);if(!this.isPerformingRequests){return}if(details&&details.error==="net::ERR_ABORTED"){return}if(!this.loadResultRecorded){this.loadResultRecorded=true;this.recordUmaHistogramForFirstLoadResult(OobeWebViewLoadResult.LOAD_ERROR)}if(this.reloadRequested){this.loadWithFallbackTimer()}else{this.loadAfterBackoff()}}onCompleted(details){if(!this.isPerformingRequests){return}if(details.statusCode!==200){console.info("Loading "+this.url+" has completed with HTTP error.");if(!this.loadResultRecorded){this.loadResultRecorded=true;this.recordUmaHistogramForFirstLoadResult(OobeWebViewLoadResult.HTTP_ERROR)}if(this.reloadRequested){this.loadWithFallbackTimer()}else{this.loadAfterBackoff()}}else{console.info("Loading "+this.url+" has completed successfully.");if(!this.loadResultRecorded){this.loadResultRecorded=true;this.recordUmaHistogramForFirstLoadResult(OobeWebViewLoadResult.SUCCESS)}this.clearInternalState()}}loadWithFallbackTimer(){console.info("Trying to load "+this.url);window.clearTimeout(this.loadTimer);this.loadTimer=window.setTimeout(this.onTimeoutError.bind(this),this.timeout);this.tryLoadOnline()}loadAfterBackoff(){console.info("Trying to reload "+this.url);window.clearTimeout(this.backOffTimer);this.backOffTimer=window.setTimeout(this.tryLoadOnline.bind(this),ONLINE_RETRY_BACKOFF_TIMEOUT_IN_MS)}tryLoadOnline(){this.reloadRequested=false;this.isPerformingRequests=true;if(this.webview.src===this.url){this.webview.reload()}else{this.webview.src=this.url}}recordUmaHistogramForFirstLoadResult(result){const id=this.webview.id[0].toUpperCase()+this.webview.id.slice(1);const histogramName=FIRST_LOAD_RESULT_HISTOGRAM+"."+id;chrome.send("metricsHandler:recordInHistogram",[histogramName,result,OobeWebViewLoadResult.MAX])}}