// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/js/cr.js";import{assert}from"//resources/js/assert.js";import{OobeTypes}from"./components/oobe_types.js";import{DisplayManager}from"./display_manager.js";import{loadTimeData}from"./i18n_setup.js";import{GaiaSigninElement}from"./screens/common/gaia_signin.js";import{EnterpriseEnrollmentElement}from"./screens/oobe/enterprise_enrollment.js";let instance=null;export class Oobe extends DisplayManager{static{this.readyForTesting=false}static getInstance(){return instance||(instance=new Oobe)}static handleCancel(){Oobe.getInstance().handleCancel()}static showScreen(screen){Oobe.getInstance().showScreen(screen)}static toggleSystemInfo(){Oobe.getInstance().toggleSystemInfo()}static triggerDown(){document.dispatchEvent(new CustomEvent("about-to-shrink"));setTimeout((()=>Oobe.getInstance().triggerDown()),0)}static enableKeyboardFlow(value){Oobe.getInstance().forceKeyboardFlow=value}static setVirtualKeyboardShown(shown){Oobe.getInstance().setVirtualKeyboardShown(shown)}static setShelfHeight(height){Oobe.getInstance().setShelfHeight(height)}static setOrientation(isHorizontal){Oobe.getInstance().setOrientation(isHorizontal)}static setDialogSize(width,height){Oobe.getInstance().setDialogSize(width,height)}static loginForTesting(username,password,gaiaId,enterpriseEnroll=false){assert(Oobe.readyForTesting,"OOBE must be ready for testing before calling!");function waitForOobeScreen(screenName,fn){const currentScreen=Oobe.getInstance().currentScreen;if(currentScreen&&currentScreen.id===screenName){fn()}else{const oobe=document.querySelector("#oobe");assert(oobe instanceof HTMLElement);oobe.addEventListener("screenchanged",(function handler(e){if(e.detail===screenName){oobe.removeEventListener("screenchanged",handler);fn()}}))}}chrome.send("OobeTestApi.skipToLoginForTesting");if(!enterpriseEnroll){chrome.send("OobeTestApi.completeLogin",[gaiaId,username,password])}else{waitForOobeScreen("gaia-signin",(function(){chrome.send("OobeTestApi.advanceToScreen",["enterprise-enrollment"])}));waitForOobeScreen("enterprise-enrollment",(function(){chrome.send("toggleFakeEnrollmentAndCompleteLogin",[username,gaiaId,password,false,OobeTypes.LicenseType.ENTERPRISE])}))}}static isEnrollmentSuccessfulForTest(){const step=document.querySelector("#enterprise-enrollment")?.uiStep;if(step===OobeTypes.EnrollmentStep.ATTRIBUTE_PROMPT){chrome.send("oauthEnrollAttributes",["",""]);return true}return step===OobeTypes.EnrollmentStep.SUCCESS}static clickGaiaPrimaryButtonForTesting(){const gaiaSignin=document.querySelector("#gaia-signin");if(gaiaSignin instanceof GaiaSigninElement&&!gaiaSignin.hidden){gaiaSignin.clickPrimaryButtonForTesting()}else{const enterpriseEnrollment=document.querySelector("#enterprise-enrollment");assert(enterpriseEnrollment instanceof EnterpriseEnrollmentElement&&!enterpriseEnrollment.hidden);enterpriseEnrollment.clickPrimaryButtonForTesting()}}static initialize(){Oobe.getInstance().initialize();chrome.send("screenStateInitialize")}static reloadContent(data){loadTimeData.overrideValues(data);Oobe.updateDocumentLocalizedStrings();Oobe.getInstance().updateLocalizedContent()}static updateDocumentLocalizedStrings(){const attrToStrMap={lang:"language",dir:"textdirection",highlight:"highlightStrength"};for(const[attribute,stringName]of Object.entries(attrToStrMap)){const localizedString=loadTimeData.getValue(stringName);document.documentElement.setAttribute(attribute,localizedString)}document.querySelector("#api-keys-notice")?.updateLocaleAndMaybeShowNotice()}static setTabletModeState(isInTabletMode){document.documentElement.toggleAttribute("tablet",isInTabletMode)}static updateOobeConfiguration(configuration){Oobe.getInstance().updateOobeConfiguration(configuration)}}Oobe.readyForTesting=false;