// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/ash/common/cr_elements/cr_checkbox/cr_checkbox.js";import"//resources/ash/common/cr_elements/cr_input/cr_input.js";import"../components/oobe_i18n_dropdown.js";import{assert}from"//resources/js/assert.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{getTemplate}from"./quick_start_debugger.html.js";let quickStartDebuggerAdded=false;export function addDebugger(){assert(!quickStartDebuggerAdded,"Only one instance of the QuickStart debugger should exit!");const quickStartDebugger=document.createElement("quick-start-debugger");document.body.appendChild(quickStartDebugger);quickStartDebuggerAdded=true}var FrontendActions;(function(FrontendActions){FrontendActions["ABOUT_TO_START_ADVERTISING"]="about_to_start_advertising";FrontendActions["ABOUT_TO_STOP_ADVERTISING"]="about_to_stop_advertising"})(FrontendActions||(FrontendActions={}));var BrowserActions;(function(BrowserActions){BrowserActions["START_ADVERTISING_CALLBACK"]="start_advertising_callback";BrowserActions["STOP_ADVERTISING_CALLBACK"]="stop_advertising_callback";BrowserActions["SET_USE_PIN"]="set_use_pin";BrowserActions["INITIATE_CONNECTION"]="initiate_connection";BrowserActions["AUTHENTICATE_CONNECTION"]="authenticate_connection";BrowserActions["VERIFY_USER"]="verify_user";BrowserActions["SEND_WIFI_CREDS"]="send_wifi_creds";BrowserActions["SEND_FIDO_ASSERTION"]="send_fido_assertion";BrowserActions["CLOSE_CONNECTION"]="close_connection";BrowserActions["REJECT_CONNECTION"]="reject_connection"})(BrowserActions||(BrowserActions={}));var ConnectionClosedReason;(function(ConnectionClosedReason){ConnectionClosedReason["KCOMPLETE"]="complete";ConnectionClosedReason["KUSERABORTED"]="user_aborted";ConnectionClosedReason["KAUTHENTICATIONFAILED"]="auth_fail";ConnectionClosedReason["KCONNECTIONLOST"]="conn_lost";ConnectionClosedReason["KREQUESTTIMEDOUT"]="timeout";ConnectionClosedReason["KUNKNOWNERROR"]="unknown"})(ConnectionClosedReason||(ConnectionClosedReason={}));const QuickStartDebuggerBase=PolymerElement;export class QuickStartDebugger extends QuickStartDebuggerBase{static get is(){return"quick-start-debugger"}static get template(){return getTemplate()}static get properties(){return{mainWindowHidden:{type:Boolean,value:true},startAdvertisingPending:{type:Boolean,value:false,reflectToAttribute:true},stopAdvertisingPending:{type:Boolean,value:false},usePinForAuth:{type:Boolean,value:false},username:{type:String,value:"testuser@gmail.com"},deviceId:{type:String,value:"a1a2a3"},wifiSsid:{type:String,value:"TestWiFi"},wifiPwd:{type:String,value:"TestPwd"},connCloseReasons:{type:Array,value:Object.values(ConnectionClosedReason),readOnly:true}}}constructor(){super();assert(!globalThis.oobeQuickStartDebugger);globalThis.oobeQuickStartDebugger=this.onFrontendActionReceived.bind(this)}toggleVisibility(){this.mainWindowHidden=!this.mainWindowHidden}onStartAdvertisingTrueClicked(){this.startAdvertisingPending=false;this.sendActionToBrowser({action_name:BrowserActions.START_ADVERTISING_CALLBACK,success:true})}onStartAdvertisingFalseClicked(){this.startAdvertisingPending=false;this.sendActionToBrowser({action_name:BrowserActions.START_ADVERTISING_CALLBACK,success:false})}onStopAdvertisingFalseClicked(){this.stopAdvertisingPending=false;this.sendActionToBrowser({action_name:BrowserActions.STOP_ADVERTISING_CALLBACK})}onInitiateConnectionClicked(){this.sendActionToBrowser({action_name:BrowserActions.INITIATE_CONNECTION,device_id:this.deviceId})}onAuthenticateConnectionClicked(){this.sendActionToBrowser({action_name:BrowserActions.AUTHENTICATE_CONNECTION,device_id:this.deviceId})}onVerifyUserClicked(){this.sendActionToBrowser({action_name:BrowserActions.VERIFY_USER})}onSendWifiCredentialsClicked(){this.sendActionToBrowser({action_name:BrowserActions.SEND_WIFI_CREDS,wifi_ssid:this.wifiSsid,wifi_password:this.wifiPwd})}onSendFidoAssertionClicked(){this.sendActionToBrowser({action_name:BrowserActions.SEND_FIDO_ASSERTION,email:this.username})}onRejectConnectionClicked(){this.sendActionToBrowser({action_name:BrowserActions.REJECT_CONNECTION})}onCloseConnectionClicked(){this.sendActionToBrowser({action_name:BrowserActions.CLOSE_CONNECTION,reason:"asd"})}onUsePinChanged(){this.sendActionToBrowser({action_name:BrowserActions.SET_USE_PIN,use_pin:this.usePinForAuth})}sendActionToBrowser(data){chrome.send("quickStartDebugger.PerformAction",[data])}onFrontendActionReceived(data){assert(data.action_name);if(data.action_name===FrontendActions.ABOUT_TO_START_ADVERTISING){this.startAdvertisingPending=true}else if(data.action_name===FrontendActions.ABOUT_TO_STOP_ADVERTISING){this.stopAdvertisingPending=true}}onCloseReasonSelected(){}}customElements.define(QuickStartDebugger.is,QuickStartDebugger);