// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{$,ensureTransitionEndEvent}from"//resources/ash/common/util.js";import{assert,assertInstanceof}from"//resources/js/assert.js";import{afterNextRender}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{DisplayType,OobeUiState,SCREEN_DEVICE_DISABLED,SCREEN_WELCOME}from"./components/display_manager_types.js";import{globalOobeKeyboard}from"./components/keyboard_utils_oobe.js";import{loadTimeData}from"./i18n_setup.js";import{MultiTapDetector}from"./multi_tap_detector.js";const MAX_SCREEN_TRANSITION_DURATION=1200;const TRIGGERDOWN_FALLBACK_DELAY=1e4;export class DisplayManager{constructor(){this.screens=[];this.currentStepId=null;this.keyboardFlowOn=false;this.virtualKeyboardShown=false;this.displayType=DisplayType.UNKNOWN;this.oobeConfiguration=undefined;this.demoModeStartListener=null}setVirtualKeyboardShown(shown){this.virtualKeyboardShown=shown;document.documentElement.toggleAttribute("virtual-keyboard",shown)}setDisplayType(displayType){this.displayType=displayType;document.documentElement.setAttribute("screen",displayType)}get currentScreen(){if(this.currentStepId===null){return null}return $(this.currentStepId)}setShelfHeight(height){document.documentElement.style.setProperty("--shelf-area-height-base",height+"px")}setOrientation(isHorizontal){if(isHorizontal){document.documentElement.setAttribute("orientation","horizontal")}else{document.documentElement.setAttribute("orientation","vertical")}}setDialogSize(width,height){document.documentElement.style.setProperty("--oobe-oobe-dialog-height-base",height+"px");document.documentElement.style.setProperty("--oobe-oobe-dialog-width-base",width+"px")}set forceKeyboardFlow(value){this.keyboardFlowOn=value;if(value){globalOobeKeyboard.initializeKeyboardFlow()}}get forceKeyboardFlow(){return this.keyboardFlowOn}getOobeConfiguration(){return this.oobeConfiguration}toggleSystemInfo(){$("version-labels").toggleAttribute("hidden")}handleCancel(){if(this.currentScreen&&"cancel"in this.currentScreen&&typeof this.currentScreen.cancel==="function"){this.currentScreen.cancel()}}toggleStep(nextStepId,screenData){const oldStep=this.currentScreen;const newStep=$(nextStepId);assertInstanceof(newStep,HTMLElement,"No screen with such id: "+nextStepId);const innerContainer=$("inner-container");const oobeContainer=$("oobe");const isBootAnimationEnabled=loadTimeData.getBoolean("isBootAnimationEnabled");if(oldStep){if("onBeforeHide"in oldStep&&typeof oldStep.onBeforeHide==="function"){oldStep.onBeforeHide()}if("defaultControl"in oldStep&&oldStep.defaultControl instanceof HTMLElement&&"onBeforeHide"in oldStep.defaultControl&&typeof oldStep.defaultControl.onBeforeHide==="function"){oldStep.defaultControl.onBeforeHide()}}$("oobe").className=nextStepId;newStep.hidden=false;if("getOobeUIInitialState"in newStep&&typeof newStep.getOobeUIInitialState==="function"){this.setOobeUiState(newStep.getOobeUIInitialState())}else{this.setOobeUiState(OobeUiState.HIDDEN)}if("onBeforeShow"in newStep&&typeof newStep.onBeforeShow==="function"){newStep.onBeforeShow(screenData)}if("defaultControl"in newStep&&newStep.defaultControl instanceof HTMLElement&&"onBeforeShow"in newStep.defaultControl&&typeof newStep.defaultControl.onBeforeShow==="function"){newStep.defaultControl.onBeforeShow(screenData)}newStep.classList.remove("hidden");oldStep?.classList.add("faded");newStep.classList.remove("faded");let defaultControl=null;if("defaultControl"in newStep&&newStep.defaultControl instanceof HTMLElement){defaultControl=newStep.defaultControl}if(this.currentStepId!==nextStepId&&oldStep&&!oldStep.classList.contains("hidden")){oldStep.classList.add("hidden");oldStep.hidden=true;if(defaultControl){defaultControl.focus()}}else{if(this.isOobeUi()&&innerContainer.classList.contains("down")){if(isBootAnimationEnabled&&oobeContainer.classList.contains("connect")){setTimeout(this.triggerDown.bind(this),TRIGGERDOWN_FALLBACK_DELAY)}else{this.triggerDown()}}else{if(defaultControl){defaultControl.focus()}}}this.currentStepId=nextStepId;const currentScreen=this.currentScreen;assert(currentScreen,"currentScreen must exist at this point");$("oobe").dispatchEvent(new CustomEvent("screenchanged",{detail:currentScreen.id}));chrome.send("updateCurrentScreen",[currentScreen.id]);if(isBootAnimationEnabled&&innerContainer.classList.contains("down")){afterNextRender(this,(()=>this.sendBackdropLoaded()))}}sendBackdropLoaded(){chrome.send("backdropLoaded")}showScreen(screen){const currentScreen=this.currentScreen;if(currentScreen&&currentScreen.id===SCREEN_DEVICE_DISABLED){return}this.toggleStep(screen.id,screen.data)}registerScreen(el){const screenId=el.id;assert(screenId);assert(!this.screens.includes(screenId),"Duplicate screen ID.");assert(this.screens.length>0||screenId!==SCREEN_DEVICE_DISABLED,"Can not register Device disabled screen as the first");this.screens.push(screenId);if("updateOobeConfiguration"in el&&typeof el.updateOobeConfiguration==="function"&&this.oobeConfiguration){el.updateOobeConfiguration(this.oobeConfiguration)}}updateLocalizedContent(){for(let i=0;i<this.screens.length;++i){const screenId=this.screens[i];const screen=$(screenId);if("updateLocalizedContent"in screen&&typeof screen.updateLocalizedContent==="function"){screen.updateLocalizedContent()}}const dynamicElements=document.getElementsByClassName("i18n-dynamic");for(const child of dynamicElements){if("i18nUpdateLocale"in child&&typeof child.i18nUpdateLocale==="function"){child.i18nUpdateLocale()}}}updateOobeConfiguration(configuration){this.oobeConfiguration=configuration;for(let i=0;i<this.screens.length;++i){const screenId=this.screens[i];const screen=$(screenId);if("updateOobeConfiguration"in screen&&typeof screen.updateOobeConfiguration==="function"){screen.updateOobeConfiguration(configuration)}}}triggerDown(){const innerContainer=$("inner-container");if(!this.isOobeUi()||!innerContainer.classList.contains("down")){return}innerContainer.classList.remove("down");innerContainer.addEventListener("transitionend",(()=>{const step=this.currentScreen;innerContainer.classList.add("down-finished");if(step&&"defaultControl"in step&&step.defaultControl instanceof HTMLElement){step.defaultControl.focus()}}),{once:true});ensureTransitionEndEvent(innerContainer,MAX_SCREEN_TRANSITION_DURATION)}initializeDemoModeMultiTapListener(){if(this.displayType===DisplayType.OOBE){this.demoModeStartListener=new MultiTapDetector($("outer-container"),10,(()=>{const currentScreen=this.currentScreen;if(currentScreen&&currentScreen.id===SCREEN_WELCOME){assert("onSetupDemoModeGesture"in currentScreen&&typeof currentScreen.onSetupDemoModeGesture==="function");currentScreen.onSetupDemoModeGesture()}}))}}isOobeUi(){return document.body.classList.contains("oobe-display")}setOobeUiState(state){chrome.send("updateOobeUIState",[state])}initialize(){let givenDisplayType=document.documentElement.getAttribute("screen");if(!givenDisplayType){givenDisplayType=window.location.pathname.substr(1)}assert(givenDisplayType);Object.getOwnPropertyNames(DisplayType).forEach((type=>{if(DisplayType[type]===givenDisplayType){this.setDisplayType(givenDisplayType)}}));if(this.displayType===DisplayType.UNKNOWN){console.error('Unknown display type "'+givenDisplayType+'". Setting default.');this.setDisplayType(DisplayType.LOGIN)}this.initializeDemoModeMultiTapListener()}static setLabelText(labelId,labelText){$(labelId).textContent=labelText}static setBluetoothDeviceInfo(bluetoothName){$("bluetooth-name").hidden=false;$("bluetooth-name").textContent=bluetoothName}}