// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assert}from"//resources/js/assert.js";import{loadTimeData}from"./i18n_setup.js";import{addScreensToMainContainer}from"./login_ui_tools.js";import{TraceEvent,traceExecution}from"./oobe_trace.js";import{commonScreensList,loginScreensList,oobeScreensList}from"./screens.js";assert(window.scheduler,"Prioritized Task Scheduling API unavailable");const isOobeFlow=loadTimeData.getBoolean("isOobeFlow");const flowSpecificScreensList=isOobeFlow?oobeScreensList:loginScreensList;const lazyLoadingEnabled=loadTimeData.getBoolean("isOobeLazyLoadingEnabled");const isBootAnimation=loadTimeData.getBoolean("isBootAnimationEnabled");const animationTransitionTime=900;let aboutToShrink=false;if(isBootAnimation){document.addEventListener("about-to-shrink",(()=>{aboutToShrink=true}),{once:true})}if(lazyLoadingEnabled){addScreensAsync()}else{addScreensSynchronously()}function addScreensSynchronously(){addScreensToMainContainer(commonScreensList);traceExecution(TraceEvent.COMMON_SCREENS_ADDED);addScreensToMainContainer(flowSpecificScreensList);traceExecution(TraceEvent.REMAINING_SCREENS_ADDED);document.dispatchEvent(new CustomEvent("oobe-screens-loaded"))}function addScreensAsync(){if(aboutToShrink){aboutToShrink=false;window.scheduler.postTask(addScreensAsync,{delay:animationTransitionTime});return}if(commonScreensList.length>0){const nextScreen=commonScreensList.pop();if(nextScreen){addScreensToMainContainer([nextScreen])}window.scheduler.postTask(addScreensAsync);if(commonScreensList.length===0){traceExecution(TraceEvent.COMMON_SCREENS_ADDED)}}else if(flowSpecificScreensList.length>0){const nextScreen=flowSpecificScreensList.pop();if(nextScreen){addScreensToMainContainer([nextScreen])}if(flowSpecificScreensList.length>0){window.scheduler.postTask(addScreensAsync)}else{traceExecution(TraceEvent.REMAINING_SCREENS_ADDED);document.dispatchEvent(new CustomEvent("oobe-screens-loaded"))}}else{assert(false,"NOTREACHED()")}}