// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"./components/common_styles/oobe_flex_layout_styles.css.js";import"./components/api_keys_notice.js";import{loginSyslog}from"//resources/ash/common/logging/webui_syslog_emitter.js";import{$}from"//resources/ash/common/util.js";import{ColorChangeUpdater}from"//resources/cr_components/color_change_listener/colors_css_updater.js";import{assert}from"//resources/js/assert.js";import{getTrustedScriptURL}from"//resources/js/static_types.js";import{Oobe}from"./cr_ui.js";import*as OobeDebugger from"./debug/debug.js";import*as QuickStartDebugger from"./debug/quick_start_debugger.js";import{loadTimeData}from"./i18n_setup.js";import{addScreensToMainContainer}from"./login_ui_tools.js";import{MultiTapDetector}from"./multi_tap_detector.js";import{TraceEvent,traceExecution}from"./oobe_trace.js";import{priorityCommonScreenList}from"./priority_screens_common_flow.js";import{priorityOobeScreenList}from"./priority_screens_oobe_flow.js";import*as OobeTestApi from"./test_api/test_api.js";traceExecution(TraceEvent.FIRST_LINE_AFTER_IMPORTS);function setOobeReadyForTestingOnceInitialAnimationIsFinished(){const downFinishedClass="down-finished";const callback=(mutationsList,observer)=>{for(const mutation of mutationsList){if(mutation.type==="attributes"&&mutation.attributeName==="class"){const element=mutation.target;if(element.classList.contains(downFinishedClass)){console.log("Mark OOBE ready for testing.");Oobe.readyForTesting=true;observer.disconnect()}}}};const observer=new MutationObserver(callback);const innerContainer=$("inner-container");if(innerContainer){if(innerContainer.classList.contains(downFinishedClass)){return}const config={attributes:true,attributeFilter:["class"]};observer.observe(innerContainer,config)}else{console.error('Element with ID "inner-container" not found.')}}function prepareGlobalValues(){window.$=$;window.MultiTapDetector=MultiTapDetector;window.Oobe=Oobe;if(window.cr===undefined){window.cr={}}if(window.cr.ui===undefined){window.cr.ui={}}window.cr.ui.Oobe=Oobe}function initializeOobe(){if(document.readyState==="loading"){return}document.removeEventListener("DOMContentLoaded",initializeOobe);traceExecution(TraceEvent.DOM_CONTENT_LOADED);if(OobeDebugger.DebuggerUi){OobeDebugger.DebuggerUi.getInstance().register(document.body)}if(QuickStartDebugger.addDebugger){QuickStartDebugger.addDebugger()}Oobe.initialize();if(OobeTestApi.OobeApiProvider){window.OobeAPI=new OobeTestApi.OobeApiProvider;const isOobeFlow=loadTimeData.getBoolean("isOobeFlow");if(!isOobeFlow){Oobe.readyForTesting=true}}traceExecution(TraceEvent.OOBE_INITIALIZED);loginSyslog("OOBE finished loading.")}function initAfterDomLoaded(){document.removeEventListener("oobe-screens-loaded",initAfterDomLoaded);if(document.readyState==="loading"){document.addEventListener("DOMContentLoaded",initializeOobe)}else{initializeOobe()}}function lazyLoadOobe(){chrome.send("priorityScreensLoaded");document.addEventListener("oobe-screens-loaded",initAfterDomLoaded);const script=document.createElement("script");script.type="module";script.src=getTrustedScriptURL`./lazy_load_screens.js`;document.body.appendChild(script)}function startOobe(){assert(window.OobeErrorStore,"OobeErrorStore not present on global object!");chrome.send("initializeCoreHandler");Oobe.updateDocumentLocalizedStrings();prepareGlobalValues();const isOobeJellyEnabled=loadTimeData.getBoolean("isOobeJellyEnabled");if(isOobeJellyEnabled){document.body.classList.add("jelly-enabled");const updater=ColorChangeUpdater.forDocument();updater.start();updater.refreshColorsCss();const fontLink=document.createElement("link");fontLink.rel="stylesheet";fontLink.href="chrome://theme/typography.css";document.head.appendChild(fontLink)}else{const lightDarkMQL=window.matchMedia("(prefers-color-scheme: light)");lightDarkMQL.addEventListener("change",(()=>{const updater=ColorChangeUpdater.forDocument();updater.refreshColorsCss()}))}const isOobeFlow=loadTimeData.getBoolean("isOobeFlow");if(!isOobeFlow){document.body.classList.remove("oobe-display");document.documentElement.style.setProperty("--shelf-area-height","0px")}else{assert(document.body.classList.contains("oobe-display"),"The body of the document must contain oobe-display as a class for the OOBE flow!")}if(OobeTestApi.OobeApiProvider&&isOobeFlow){setOobeReadyForTestingOnceInitialAnimationIsFinished()}if(isOobeFlow){addScreensToMainContainer(priorityOobeScreenList)}addScreensToMainContainer(priorityCommonScreenList);traceExecution(TraceEvent.PRIORITY_SCREENS_ADDED);if(document.readyState==="loading"){document.addEventListener("DOMContentLoaded",lazyLoadOobe)}else{lazyLoadOobe()}}startOobe();