// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{loadTimeData}from"./i18n_setup.js";export var TraceEvent;(function(TraceEvent){TraceEvent["FIRST_INSTRUCTION"]="FIRST_INSTRUCTION";TraceEvent["FIRST_LINE_AFTER_IMPORTS"]="FIRST_LINE_AFTER_IMPORTS";TraceEvent["PRIORITY_SCREENS_ADDED"]="PRIORITY_SCREENS_ADDED";TraceEvent["COMMON_SCREENS_ADDED"]="COMMON_SCREENS_ADDED";TraceEvent["REMAINING_SCREENS_ADDED"]="REMAINING_SCREENS_ADDED";TraceEvent["DOM_CONTENT_LOADED"]="DOM_CONTENT_LOADED";TraceEvent["OOBE_INITIALIZED"]="OOBE_INITIALIZED";TraceEvent["FIRST_SCREEN_SHOWN"]="FIRST_SCREEN_SHOWN";TraceEvent["FIRST_OOBE_LOTTIE_INITIALIZED"]="FIRST_OOBE_LOTTIE_INITIALIZED";TraceEvent["LAST_OOBE_LOTTIE_INITIALIZED"]="LAST_OOBE_LOTTIE_INITIALIZED";TraceEvent["WELCOME_ANIMATION_PLAYING"]="WELCOME_ANIMATION_PLAYING"})(TraceEvent||(TraceEvent={}));const eventLogs=[];window.oobeTraceLogs=eventLogs;class EventEntry{constructor(traceEventName){this.name=traceEventName;this.delta=performance.now()}}if(window.oobeInitializationBeginTimestamp){const oobeTimeOrigin=new EventEntry(TraceEvent.FIRST_INSTRUCTION);oobeTimeOrigin.delta=window.oobeInitializationBeginTimestamp;eventLogs.push(oobeTimeOrigin)}let firstScreenShownEventLogged=false;let welcomeAnimationPlayEventLogged=false;let firstOobeLottieEventLogged=false;export function traceExecution(traceEvent){eventLogs.push(new EventEntry(traceEvent))}export function traceFirstScreenShown(){if(firstScreenShownEventLogged){return}firstScreenShownEventLogged=true;traceExecution(TraceEvent.FIRST_SCREEN_SHOWN)}export function traceWelcomeAnimationPlay(){if(welcomeAnimationPlayEventLogged){return}welcomeAnimationPlayEventLogged=true;traceExecution(TraceEvent.WELCOME_ANIMATION_PLAYING)}export function traceOobeLottieExecution(){if(!firstOobeLottieEventLogged){traceExecution(TraceEvent.FIRST_OOBE_LOTTIE_INITIALIZED);firstOobeLottieEventLogged=true}maybeTraceLastOobeLottieInitialization()}let scheduledLastOobeLottieTrace=0;function maybeTraceLastOobeLottieInitialization(){const LAST_OOBE_LOTTIE_TIMEOUT_MSECS=3*1e3;clearTimeout(scheduledLastOobeLottieTrace);const entry=new EventEntry(TraceEvent.LAST_OOBE_LOTTIE_INITIALIZED);scheduledLastOobeLottieTrace=setTimeout((()=>{eventLogs.push(entry);maybePrintTraces()}),LAST_OOBE_LOTTIE_TIMEOUT_MSECS)}function maybePrintTraces(){if(!loadTimeData.valueExists("printFrontendTimings")||!loadTimeData.getBoolean("printFrontendTimings")){return}const EventPrintOrder=[TraceEvent.FIRST_INSTRUCTION,TraceEvent.FIRST_LINE_AFTER_IMPORTS,TraceEvent.PRIORITY_SCREENS_ADDED,TraceEvent.COMMON_SCREENS_ADDED,TraceEvent.REMAINING_SCREENS_ADDED,TraceEvent.DOM_CONTENT_LOADED,TraceEvent.OOBE_INITIALIZED,TraceEvent.FIRST_SCREEN_SHOWN,TraceEvent.FIRST_OOBE_LOTTIE_INITIALIZED,TraceEvent.LAST_OOBE_LOTTIE_INITIALIZED,TraceEvent.WELCOME_ANIMATION_PLAYING];let output="OOBE_TRACE_BEGIN_";for(const eventName of EventPrintOrder){const matchingEvent=eventLogs.find((e=>e.name===eventName));output+=matchingEvent?matchingEvent.delta+";":"NaN;"}output+="_OOBE_TRACE_END";console.error(output)}