import{html}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";export function getTemplate(){return html`<!--_html_template_start_--><!--
Copyright 2023 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->
<style include="oobe-dialog-host-styles cr-card-radio-group-styles
    cros-color-overrides">@media screen and (max-width:920px){:host{--radio-button-height:155px}}.help-text{color:var(--oobe-subheader-text-color);margin-top:16px}</style>
<oobe-adaptive-dialog id="childSignInDialog" role="dialog"
    for-step="overview"
    aria-label$="[[i18nDynamic(locale, 'childSignInTitle')]]">
  <iron-icon slot="icon" icon="oobe-32:family"></iron-icon>
  <h1 slot="title">
    [[i18nDynamic(locale, 'childSignInTitle')]]
  </h1>
  <div slot="subtitle" id="subtitle">
    [[i18nDynamic(locale, 'childSignInSubtitle')]]
    <a id="learnMoreLink" class="oobe-local-link"
        on-click="onLearnMoreClicked_" is="action-link"
        aria-describedby="subtitle">
      [[i18nDynamic(locale, 'childSignInLearnMore')]]
    </a>
  </div>
  <div slot="content" class="layout vertical landscape-vertical-centered">
    <cr-radio-group id="childSignInMethod"
        selected="{{selectedSignInMethod}}">
      <cr-card-radio-button id="childCreateButton" name="create" class="flex">
        <div class="card-container">
          <hd-iron-icon class="card-icon" icon1x="oobe-48:person-add"
              icon2x="oobe-96:person-add">
          </hd-iron-icon>
          <div class="card-content card-label">
            [[i18nDynamic(locale, 'createAccountForChildLabel')]]
          </div>
        </div>
      </cr-card-radio-button>
      <cr-card-radio-button id="childSignInButton" name="signin"
          class="flex">
        <div class="card-container">
          <hd-iron-icon class="card-icon" icon1x="oobe-48:supervised-user"
              icon2x="oobe-96:supervised-user">
          </hd-iron-icon>
          <div class="card-content card-label">
            [[i18nDynamic(locale, 'signInForChildLabel')]]
          </div>
        </div>
      </cr-card-radio-button>
    </cr-radio-group>
    <div class="help-text">
      [[i18nDynamic(locale, 'childSignInParentNotificationText')]]
    </div>
  </div>
  <div slot="back-navigation">
    <oobe-back-button id="childBackButton" on-click="onBackClicked_">
    </oobe-back-button>
  </div>
  <div slot="bottom-buttons">
    <oobe-next-button id="childNextButton" on-click="onNextClicked_"
        disabled="[[!selectedSignInMethod]]">
    </oobe-next-button>
  </div>
</oobe-adaptive-dialog>
<oobe-modal-dialog id="learnMoreDialog" on-close="focusLearnMoreLink_"
    title-key="childSignInLearnMoreDialogTitle">
  <div slot="content" class="card-text">
    [[i18nDynamic(locale, 'childSignInLearnMoreDialogText')]]
  </div>
</oobe-modal-dialog>
<!--_html_template_end_-->`}