import{html}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";export function getTemplate(){return html`<!--_html_template_start_--><!--
Copyright 2024 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->
<style include="oobe-dialog-host-styles"></style>

<oobe-loading-dialog id="progressDialog" for-step="loading"
        title-key="categoriesLoading" role="dialog"
        aria-label$="[[i18nDynamic(locale, 'categoriesLoading')]]">
    <iron-icon slot="icon" icon="oobe-32:sync-chrome"></iron-icon>
</oobe-loading-dialog>
<oobe-adaptive-dialog id="categoriesDialog" role="dialog"
      for-step="overview"
      aria-label$="[[i18nDynamic(locale, 'categoriesScreenTitle')]]"
      aria-description$="[[i18nDynamic(locale,
          'categoriesScreenDescription')]]">
    <iron-icon slot="icon" icon="oobe-32:sync-chrome"></iron-icon>
    <h1 slot="title" id="categories-title" aria-live="polite">
      [[i18nDynamic(locale, 'categoriesScreenTitle')]]
    </h1>
    <div slot="subtitle" id="categories-subtitle">
      [[i18nDynamic(locale, 'categoriesScreenDescription')]]
    </div>
    <div slot="content" class="layout vertical landscape-vertical-centered">
      <oobe-categories-list id="categoriesList" class="focus-on-show"
        selected-categories-count="{{numberOfSelectedCategories}}"
        on-icons-loaded="onFullyLoaded">
      </oobe-categories-list>
    </div>
    <div slot="bottom-buttons">
      <oobe-text-button id="skipButton"
        text-key="categoriesScreenSkip" on-click="onSkip" border>
      </oobe-text-button>
      <oobe-next-button id="nextButton" on-click="onNextClicked"
        disabled="[[!canProceed(numberOfSelectedCategories)]]">
      </oobe-next-button>
    </div>
</oobe-adaptive-dialog>
<!--_html_template_end_-->`}