// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/polymer/v3_0/iron-icon/iron-icon.js";import"../../components/dialogs/oobe_loading_dialog.js";import"../../components/oobe_categories_list.js";import"../../components/oobe_cr_lottie.js";import"../../components/oobe_icons.html.js";import"../../components/oobe_categories_list.js";import"../../components/common_styles/oobe_common_styles.css.js";import"../../components/common_styles/oobe_dialog_host_styles.css.js";import"../../components/dialogs/oobe_adaptive_dialog.js";import"../../components/dialogs/oobe_loading_dialog.js";import{assert}from"//resources/js/assert.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{OobeUiState}from"../../components/display_manager_types.js";import{LoginScreenMixin}from"../../components/mixins/login_screen_mixin.js";import{MultiStepMixin}from"../../components/mixins/multi_step_mixin.js";import{OobeDialogHostMixin}from"../../components/mixins/oobe_dialog_host_mixin.js";import{OobeI18nMixin}from"../../components/mixins/oobe_i18n_mixin.js";import{getTemplate}from"./categories_selection.html.js";export const CategoriesScreenElementBase=OobeDialogHostMixin(LoginScreenMixin(MultiStepMixin(OobeI18nMixin(PolymerElement))));var CategoriesStep;(function(CategoriesStep){CategoriesStep["LOADING"]="loading";CategoriesStep["OVERVIEW"]="overview"})(CategoriesStep||(CategoriesStep={}));var UserAction;(function(UserAction){UserAction["SKIP"]="skip";UserAction["NEXT"]="next";UserAction["LOADED"]="loaded"})(UserAction||(UserAction={}));export class CategoriesScreenElement extends CategoriesScreenElementBase{static get is(){return"categories-selection-element"}static get template(){return getTemplate()}static get properties(){return{numberOfSelectedCategories:{type:Number,value:0}}}get UI_STEPS(){return CategoriesStep}defaultUIStep(){return CategoriesStep.LOADING}ready(){super.ready();this.initializeLoginScreen("CategoriesSelectionScreen")}get EXTERNAL_API(){return["setCategoriesData","setOverviewStep"]}getOobeUIInitialState(){return OobeUiState.ONBOARDING}onBeforeShow(){super.onBeforeShow();this.setUIStep(CategoriesStep.LOADING)}onBeforeHide(){super.onBeforeHide();this.shadowRoot.querySelector("#categoriesList").reset()}setCategoriesData(categoriesData){assert("categories"in categoriesData);this.shadowRoot.querySelector("#categoriesList").init(categoriesData["categories"])}setOverviewStep(){this.setUIStep(CategoriesStep.OVERVIEW);const categoriesList=this.shadowRoot?.querySelector("#categoriesList");if(categoriesList instanceof HTMLElement){categoriesList.focus()}}get defaultControl(){const categoriesDialog=this.shadowRoot?.querySelector("#categoriesDialog");if(categoriesDialog instanceof HTMLElement){return categoriesDialog}return null}onFullyLoaded(){this.userActed(UserAction.LOADED)}onNextClicked(){const categoriesSelected=this.shadowRoot.querySelector("#categoriesList").getCategoriesSelected();this.userActed([UserAction.NEXT,categoriesSelected])}onSkip(){this.userActed(UserAction.SKIP)}canProceed(){return this.numberOfSelectedCategories>0}}customElements.define(CategoriesScreenElement.is,CategoriesScreenElement);