import{html}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";export function getTemplate(){return html`<!--_html_template_start_--><!--
Copyright 2021 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->

<style include="oobe-dialog-host-styles cros-color-overrides">#termsDescriptionTitle{color:var(--oobe-header-text-color);font-family:var(--oobe-consolidated-consent-terms-title-font-family);font-size:var(--oobe-consolidated-consent-terms-title-font-size);font-weight:var(--oobe-consolidated-consent-terms-title-font-weight);line-height:var(--oobe-consolidated-consent-terms-title-line-height);margin-bottom:4px}#termsDescription,#termsDescriptionArcDisabled{font-size:13px}.tos-dialog{--oobe-modal-dialog-content-height:500px}.tos-webview{display:flex;height:484px}.managed-icon{--iron-icon-fill-color:var(--cros-icon-color-secondary);height:20px;margin-inline-end:6px}:host-context(.jelly-enabled) .managed-icon{--iron-icon-fill-color:var(--cros-sys-on_surface)}#usageStats.first-optin-no-tos{border-top:hidden}</style>

<!-- LOADING DIALOG -->
<oobe-loading-dialog id="progressDialog" for-step="loading"
    role="dialog" title-key="consolidatedConsentLoading"
    aria-label$="[[i18nDynamic(locale, 'consolidatedConsentLoading')]]">
  <iron-icon slot="icon" icon="oobe-32:googleg"></iron-icon>
</oobe-loading-dialog>

<!-- ERROR DIALOG -->
<oobe-adaptive-dialog id="errorDialog" for-step="play-load-error" role="dialog"
    aria-label$="[[i18nDynamic(locale, 'consolidatedConsentHeader')]]">
  <iron-icon slot="icon" icon="oobe-32:warning"></iron-icon>
  <h1 slot="title">
    [[i18nDynamic(locale, 'consolidatedConsentPlayErrorTitle')]]
  </h1>
  <p slot="subtitle">
    [[i18nDynamic(locale, 'consolidatedConsentPlayErrorMessage')]]
  </p>
  <div slot="content" class="flex layout vertical center center-justified">
    <iron-icon icon="oobe-illos:error-illo" class="illustration-jelly">
    </iron-icon>
  </div>
  <div slot="bottom-buttons">
    <oobe-text-button id="retryButton" on-click="onRetryClick"
        text-key="consolidatedConsentRetry"></oobe-text-button>
    <oobe-text-button id="doneButton" class="focus-on-show"
        on-click="onErrorDoneClick" text-key="consolidatedConsentDone">
    </oobe-text-button>
  </div>
</oobe-adaptive-dialog>

<!-- Google EULA Dialog -->
<oobe-adaptive-dialog id="googleEulaDialog" for-step="google-eula"
    role="dialog"
    aria-label$="[[i18nDynamic(locale,
                  'consolidatedConsentGoogleEulaTitle')]]">
  <iron-icon slot="icon" icon="oobe-32:googleg"></iron-icon>
  <h1 slot="title">
    [[i18nDynamic(locale, 'consolidatedConsentGoogleEulaTitle')]]
  </h1>
  <div slot="content" class="flex layout vertical">
    <webview id="consolidatedConsentGoogleEulaWebview" role="document"
        class="oobe-tos-webview tos-webview"
        on-contentload="onGoogleEulaContentLoad">
    </webview>
  </div>
  <div slot="bottom-buttons">
    <oobe-text-button id="googleEulaOkButton"
        class="focus-on-show" inverse on-click="onTermsStepOkClick"
        text-key="consolidatedConsentOK"></oobe-text-button>
  </div>
</oobe-adaptive-dialog>

<!-- CrOS EULA Dialog -->
<oobe-adaptive-dialog id="crosEulaDialog" for-step="cros-eula"
    role="dialog"
    aria-label$="[[i18nDynamic(locale,
                  'consolidatedConsentCrosEulaTitle')]]">
  <iron-icon slot="icon" icon="oobe-32:googleg"></iron-icon>
  <h1 slot="title">
    [[i18nDynamic(locale, 'consolidatedConsentCrosEulaTitle')]]
  </h1>
  <div slot="content" class="flex layout vertical">
    <webview id="consolidatedConsentCrosEulaWebview" role="document"
        class="oobe-tos-webview tos-webview"
        on-contentload="onCrosEulaContentLoad">
    </webview>
  </div>
  <div slot="bottom-buttons">
    <oobe-text-button id="crosEulaOkButton"
        class="focus-on-show" inverse on-click="onTermsStepOkClick"
        text-key="consolidatedConsentOK"></oobe-text-button>
  </div>
</oobe-adaptive-dialog>

<!-- ARC Terms Dialog -->
<oobe-adaptive-dialog id="arcTosDialog" for-step="arc" role="dialog"
    aria-label$="[[i18nDynamic(locale,
                  'consolidatedConsentArcTermsTitle')]]">
  <iron-icon slot="icon" icon="oobe-32:googleg"></iron-icon>
  <h1 slot="title">
    [[i18nDynamic(locale, 'consolidatedConsentArcTermsTitle')]]
  </h1>
  <div slot="content" class="flex layout vertical">
    <webview id="consolidatedConsentArcTosWebview" role="document"
        class="oobe-tos-webview tos-webview"
        on-contentload="onArcTosContentLoad">
    </webview>
  </div>
  <div slot="bottom-buttons">
    <oobe-text-button id="arcTosOkButton"
        class="focus-on-show" inverse on-click="onTermsStepOkClick"
        text-key="consolidatedConsentOK"></oobe-text-button>
  </div>
</oobe-adaptive-dialog>

<!-- Privacy Policy Dialog -->
<oobe-adaptive-dialog id="privacyPolicyDialog" for-step="privacy"
    role="dialog" aria-label$="[[i18nDynamic(locale,
                                'consolidatedConsentPrivacyTitle')]]">
  <iron-icon slot="icon" icon="oobe-32:googleg"></iron-icon>
  <h1 slot="title">
    [[i18nDynamic(locale, 'consolidatedConsentPrivacyTitle')]]
  </h1>
  <div slot="content" class="flex layout vertical">
    <webview id="consolidatedConsentPrivacyPolicyWebview" role="document"
        class="oobe-tos-webview tos-webview"
        on-contentload="onPrivacyPolicyContentLoad">
    </webview>
  </div>
  <div slot="bottom-buttons">
    <oobe-text-button id="privacyOkButton"
        class="focus-on-show" inverse on-click="onTermsStepOkClick"
        text-key="consolidatedConsentOK"></oobe-text-button>
  </div>
</oobe-adaptive-dialog>

<!-- LOADED DIALOG -->
<oobe-adaptive-dialog id="loadedDialog" for-step="loaded" role="dialog"
    aria-label$="[[i18nDynamic(locale, 'consolidatedConsentHeader')]]"
    read-more>
  <iron-icon slot="icon" icon="oobe-32:googleg"></iron-icon>
  <h1 slot="title">
    [[getTitle(locale, isTosHidden, isChildAccount, isDemo)]]
  </h1>
  <div id="subtitle" slot="subtitle">
    <div inner-h-t-m-l="[[getSubtitleArcEnabled(locale, isDemo)]]"
        hidden="[[!shouldShowArcTos(isTosHidden, isArcEnabled)]]">
    </div>
    <div hidden="[[shouldShowArcTos(isTosHidden, isArcEnabled)]]">
      [[i18nDynamic(locale, 'consolidatedConsentSubheaderArcDisabled')]]
    </div>
  </div>
  <div id="loadedContent" slot="content">
    <div hidden="[[isTosHidden]]">
      <div id="termsDescriptionTitle">
        [[i18nDynamic(locale, 'consolidatedConsentTermsDescriptionTitle')]]
      </div>
      <div id="termsDescriptionArcEnabled"
          inner-h-t-m-l="[[getTermsDescriptionArcEnabled(locale)]]"
          hidden="[[!shouldShowArcTos(isTosHidden, isArcEnabled)]]">
      </div>
      <div id="termsDescriptionArcDisabled"
          inner-h-t-m-l="[[getTermsDescriptionArcDisabled(locale)]]"
          hidden="[[shouldShowArcTos(isTosHidden, isArcEnabled)]]">
      </div>
    </div>

    <!-- Usage stats toggle row -->
    <div id="usageStats" class="layout horizontal center oobe-optin-row"
        hidden="[[usageOptinHidden]]">
      <div class="oobe-optin-content flex">
        <span id="usageTitle" class="oobe-optin-title">
          [[i18nDynamic(locale, 'consolidatedConsentUsageOptInTitle')]]
        </span>
        [[getUsageOptIn(locale, isDemo)]]
        <a id="usageLearnMore" on-click="onUsageLearnMoreClick"
            class="oobe-local-link" is="action-link" hidden="[[isDemo]]">
          [[i18nDynamic(locale,
                        'consolidatedConsentUsageOptInLearnMoreLink')]]
        </a>
      </div>
      <iron-icon class="managed-icon" icon="oobe-32:enterprise"
          hidden="[[!usageManaged || isDemo]]"></iron-icon>
      <cr-toggle id="usageOptin" checked="{{usageChecked}}"
          disabled="[[usageManaged]]" aria-describedby="usageTitle"
          hidden="[[isDemo]]">
      </cr-toggle>
    </div>

    <!-- Backup toggle row -->
    <div id="backup" class="layout horizontal center oobe-optin-row"
        hidden="[[isArcBackupOptInHidden(isArcEnabled, isDemo)]]">
      <div class="oobe-optin-content flex">
        <span id="backupTitle" class="oobe-optin-title">
          [[i18nDynamic(locale, 'consolidatedConsentBackupOptInTitle')]]
        </span>
        <span hidden="[[isChildAccount]]">
          [[i18nDynamic(locale, 'consolidatedConsentBackupOptIn')]]
        </span>
        <span hidden="[[!isChildAccount]]">
          [[i18nDynamic(locale, 'consolidatedConsentBackupOptInChild')]]
        </span>
        <a id="backupLearnMore" on-click="onBackupLearnMoreClick"
            class="oobe-local-link" is="action-link">
          [[i18nDynamic(locale,
                        'consolidatedConsenttBackupOptInLearnMoreLink')]]
        </a>
      </div>
      <iron-icon class="managed-icon" icon="oobe-32:enterprise"
          hidden="[[!backupManaged]]">
      </iron-icon>
      <cr-toggle id="backupOptIn" checked="{{backupChecked}}"
          disabled="[[backupManaged]]" aria-describedby="backupTitle">
      </cr-toggle>
    </div>

    <!-- Recovery toggle row -->
    <div id="recovery" class="layout horizontal center oobe-optin-row"
        hidden="[[!recoveryVisible]]">
      <div class="oobe-optin-content flex">
        <span id="recoveryTitle" class="oobe-optin-title">
          [[i18nDynamic(locale, 'consolidatedConsentRecoveryOptInTitle')]]
        </span>
        <span>
          [[i18nDynamic(locale, 'consolidatedConsentRecoveryOptIn')]]
        </span>
      </div>
      <cr-toggle id="recoveryOptIn" checked="{{recoveryChecked}}"
          aria-describedby="recoveryTitle">
      </cr-toggle>
    </div>

    <!-- Location services toggle row -->
    <div id="location" class="layout horizontal center oobe-optin-row"
        hidden="[[isLocationOptInHidden(isArcEnabled, isDemo)]]">
      <div class="oobe-optin-content flex">
        <span id="locationTitle" class="oobe-optin-title">
          [[i18nDynamic(locale, 'consolidatedConsentLocationOptInTitle')]]
        </span>
        <span hidden="[[isChildAccount]]">
          [[i18nDynamic(locale, 'consolidatedConsentLocationOptIn')]]
        </span>
        <span hidden="[[!isChildAccount]]">
          [[i18nDynamic(locale, 'consolidatedConsentLocationOptInChild')]]
        </span>
        <a id="locationLearnMore" on-click="onLocationLearnMoreClick"
            class="oobe-local-link" is="action-link">
          [[i18nDynamic(locale,
                        'consolidatedConsenttLocationOptInLearnMoreLink')]]
        </a>
      </div>
      <iron-icon class="managed-icon" icon="oobe-32:enterprise"
          hidden="[[!locationManaged]]">
      </iron-icon>
      <cr-toggle id="locationOptIn" checked="{{locationChecked}}"
          disabled="[[locationManaged]]" aria-describedby="locationTitle">
      </cr-toggle>
    </div>
    <div id="footer" hidden="[[isLocationOptInHidden(isArcEnabled, isDemo)]]"
        class="oobe-optin-row">
      <span id="footerText">
        <span hidden="[[isChildAccount]]">
          [[i18nDynamic(locale, 'consolidatedConsentFooter')]]
        </span>
        <span hidden="[[!isChildAccount]]">
          [[i18nDynamic(locale, 'consolidatedConsentFooterChild')]]
        </span>
      </span>
      <a id="footerLearnMore"
          on-click="onFooterLearnMoreClick"
          class="oobe-local-link" is="action-link"
          aria-describedby="footerText">
        [[i18nDynamic(locale, 'consolidatedConsentLearnMore')]]
      </a>
    </div>
  </div>
  <div slot="back-navigation">
    <oobe-back-button id="backButton" hidden="[[!isDemo]]"
        on-click="onBack"></oobe-back-button>
  </div>
  <div slot="bottom-buttons">
    <oobe-next-button id="acceptButton" inverse on-click="onAcceptClick"
        class="focus-on-show"
        text-key="consolidatedConsentAcceptAndContinue">
    </oobe-next-button>
  </div>
</oobe-adaptive-dialog>

<oobe-modal-dialog id="usageLearnMorePopUp">
  <div slot="content">
    <span
        inner-h-t-m-l=
            "[[getUsageLearnMoreText(locale, isChildAccount,
                                     isArcEnabled, isDemo)]]">
    </span>
  </div>
</oobe-modal-dialog>

<oobe-modal-dialog id="backupLearnMorePopUp">
  <div slot="content">
    <span inner-h-t-m-l=
        "[[getBackupLearnMoreText(locale, isChildAccount)]]">
    </span>
  </div>
</oobe-modal-dialog>

<oobe-modal-dialog id="locationLearnMorePopUp">
  <div slot="content">
    <span
        inner-h-t-m-l="[[getLocationLearnMoreText(locale,
                                                  isChildAccount)]]">
    </span>
  </div>
</oobe-modal-dialog>

<oobe-modal-dialog id="footerLearnMorePopUp">
  <div slot="content">
    [[i18nDynamic(locale, 'consolidatedConsentFooterLearnMore')]]
  </div>
</oobe-modal-dialog>
<!--_html_template_end_-->`}