// Copyright 2012 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/polymer/v3_0/iron-icon/iron-icon.js";import"../../components/oobe_icons.html.js";import"../../components/common_styles/oobe_common_styles.css.js";import"../../components/common_styles/oobe_dialog_host_styles.css.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{OobeUiState}from"../../components/display_manager_types.js";import{LoginScreenMixin}from"../../components/mixins/login_screen_mixin.js";import{OobeDialogHostMixin}from"../../components/mixins/oobe_dialog_host_mixin.js";import{OobeI18nMixin}from"../../components/mixins/oobe_i18n_mixin.js";import{getTemplate}from"./device_disabled.html.js";const DeviceDisabledElementBase=OobeDialogHostMixin(LoginScreenMixin(OobeI18nMixin(PolymerElement)));export class DeviceDisabled extends DeviceDisabledElementBase{static get is(){return"device-disabled-element"}static get template(){return getTemplate()}static get properties(){return{serial:{type:String,value:""},enrollmentDomain:{type:String,value:""},message:{type:String,value:""},deviceRestrictionScheduleEnabled:{type:Boolean,value:false},deviceName:{type:String,value:""},restrictionScheduleEndDay:{type:String,value:""},restrictionScheduleEndTime:{type:String,value:""}}}ready(){super.ready();this.initializeLoginScreen("DeviceDisabledScreen")}get EXTERNAL_API(){return["updateData"]}getOobeUIInitialState(){return OobeUiState.BLOCKING}get defaultControl(){return this.shadowRoot.querySelector("#dialog")}onBeforeShow(data){super.onBeforeShow(data);this.updateData(data)}updateData(data){if("serial"in data){this.serial=data.serial}if("domain"in data){this.enrollmentDomain=data.domain}if("message"in data){this.message=data.message}if("deviceRestrictionScheduleEnabled"in data){this.deviceRestrictionScheduleEnabled=data.deviceRestrictionScheduleEnabled}if("deviceName"in data){this.deviceName=data.deviceName}if("restrictionScheduleEndDay"in data){this.restrictionScheduleEndDay=data.restrictionScheduleEndDay}if("restrictionScheduleEndTime"in data){this.restrictionScheduleEndTime=data.restrictionScheduleEndTime}}disabledHeading(locale,deviceRestrictionScheduleEnabled){if(deviceRestrictionScheduleEnabled){return this.i18nAdvancedDynamic(locale,"deviceDisabledHeadingRestrictionSchedule")}return this.i18nAdvancedDynamic(locale,"deviceDisabledHeading")}disabledText(locale,serial,domain,deviceRestrictionScheduleEnabled,deviceName){if(deviceRestrictionScheduleEnabled){return this.i18nAdvancedDynamic(locale,"deviceDisabledExplanationRestrictionSchedule",{substitutions:[domain,deviceName]})}if(domain){return this.i18nAdvancedDynamic(locale,"deviceDisabledExplanationWithDomain",{substitutions:[serial,domain]})}return this.i18nAdvancedDynamic(locale,"deviceDisabledExplanationWithoutDomain",{substitutions:[serial]})}disabledMessage(locale,restrictionScheduleEndDay,restrictionScheduleEndTime){return this.i18nAdvancedDynamic(locale,"deviceDisabledExplanationRestrictionScheduleTime",{substitutions:[restrictionScheduleEndDay,restrictionScheduleEndTime]})}}customElements.define(DeviceDisabled.is,DeviceDisabled);