// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/ash/common/cr_elements/cros_color_overrides.css.js";import"//resources/polymer/v3_0/iron-iconset-svg/iron-iconset-svg.js";import"../../components/buttons/oobe_next_button.js";import"../../components/oobe_icons.html.js";import"../../components/common_styles/oobe_common_styles.css.js";import"../../components/common_styles/oobe_dialog_host_styles.css.js";import"../../components/dialogs/oobe_adaptive_dialog.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{OobeUiState}from"../../components/display_manager_types.js";import{LoginScreenMixin}from"../../components/mixins/login_screen_mixin.js";import{MultiStepMixin}from"../../components/mixins/multi_step_mixin.js";import{OobeI18nMixin}from"../../components/mixins/oobe_i18n_mixin.js";import{DrivePinningPageCallbackRouter,DrivePinningPageHandlerRemote}from"../../mojom-webui/screens_common.mojom-webui.js";import{OobeScreensFactoryBrowserProxy}from"../../oobe_screens_factory_proxy.js";import{getTemplate}from"./drive_pinning.html.js";export const DrivePinningScreenElementBase=LoginScreenMixin(MultiStepMixin(OobeI18nMixin(PolymerElement)));var DrivePinningStep;(function(DrivePinningStep){DrivePinningStep["OVERVIEW"]="overview"})(DrivePinningStep||(DrivePinningStep={}));class DrivePinningScreen extends DrivePinningScreenElementBase{static get is(){return"drive-pinning-element"}static get template(){return getTemplate()}static get properties(){return{freeSpace_:{type:String},requiredSpace_:{type:String},enableDrivePinning_:{type:Boolean,value:true},shouldShowReturn_:{type:Boolean,value:false}}}constructor(){super();this.callbackRouter=new DrivePinningPageCallbackRouter;this.handler=new DrivePinningPageHandlerRemote;OobeScreensFactoryBrowserProxy.getInstance().screenFactory.establishDrivePinningScreenPipe(this.handler.$.bindNewPipeAndPassReceiver()).then((response=>{this.callbackRouter.$.bindHandle(response.pending.handle)}));this.callbackRouter.setRequiredSpaceInfo.addListener(this.setRequiredSpaceInfo.bind(this))}get UI_STEPS(){return DrivePinningStep}defaultUIStep(){return DrivePinningStep.OVERVIEW}ready(){super.ready();this.initializeLoginScreen("DrivePinningScreen")}getOobeUIInitialState(){return OobeUiState.ONBOARDING}onBeforeShow(data){super.onBeforeShow(data);this.shouldShowReturn_=data["shouldShowReturn"]}getSpaceDescription_(locale,requiredSpace,freeSpace){if(requiredSpace&&freeSpace){return this.i18nDynamic(locale,"DevicePinningScreenToggleSubtitle",requiredSpace,freeSpace)}return""}setRequiredSpaceInfo(requiredSpace,freeSpace){this.requiredSpace_=requiredSpace;this.freeSpace_=freeSpace}onNextButtonClicked_(){this.handler.onNextClicked(this.enableDrivePinning_)}onReturnClicked_(){this.handler.onReturnClicked(this.enableDrivePinning_)}}customElements.define(DrivePinningScreen.is,DrivePinningScreen);