// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/ash/common/cr_elements/cros_color_overrides.css.js";import"//resources/ash/common/cr_elements/cr_radio_button/cr_card_radio_button.js";import"//resources/ash/common/cr_elements/cr_radio_group/cr_radio_group.js";import"//resources/polymer/v3_0/iron-icon/iron-icon.js";import"../../components/oobe_icons.html.js";import"../../components/oobe_illo_icons.html.js";import"../../components/common_styles/oobe_common_styles.css.js";import"../../components/common_styles/cr_card_radio_group_styles.css.js";import"../../components/common_styles/oobe_dialog_host_styles.css.js";import"../../components/oobe_cr_lottie.js";import{afterNextRender,PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{OobeAdaptiveDialog}from"../../components/dialogs/oobe_adaptive_dialog.js";import{OobeUiState}from"../../components/display_manager_types.js";import{LoginScreenMixin}from"../../components/mixins/login_screen_mixin.js";import{MultiStepMixin}from"../../components/mixins/multi_step_mixin.js";import{OobeI18nMixin}from"../../components/mixins/oobe_i18n_mixin.js";import{GaiaInfoPageCallbackRouter,GaiaInfoPageHandler_UserCreationFlowType,GaiaInfoPageHandlerRemote}from"../../mojom-webui/screens_common.mojom-webui.js";import{OobeScreensFactoryBrowserProxy}from"../../oobe_screens_factory_proxy.js";import{getTemplate}from"./gaia_info.html.js";export const GaiaInfoScreenElementBase=LoginScreenMixin(MultiStepMixin(OobeI18nMixin(PolymerElement)));var GaiaInfoStep;(function(GaiaInfoStep){GaiaInfoStep["OVERVIEW"]="overview"})(GaiaInfoStep||(GaiaInfoStep={}));var UserCreationFlowType;(function(UserCreationFlowType){UserCreationFlowType["MANUAL"]="manual";UserCreationFlowType["QUICKSTART"]="quickstart"})(UserCreationFlowType||(UserCreationFlowType={}));export class GaiaInfoScreen extends GaiaInfoScreenElementBase{static get is(){return"gaia-info-element"}static get template(){return getTemplate()}static get properties(){return{selectedFlowType:{type:String,value:""},isQuickStartVisible:{type:Boolean,value:false}}}constructor(){super();this.callbackRouter=new GaiaInfoPageCallbackRouter;this.handler=new GaiaInfoPageHandlerRemote;OobeScreensFactoryBrowserProxy.getInstance().screenFactory.establishGaiaInfoScreenPipe(this.handler.$.bindNewPipeAndPassReceiver()).then((response=>{this.callbackRouter.$.bindHandle(response.pending.handle)}));this.callbackRouter.setQuickStartVisible.addListener((()=>{this.setQuickStartVisible()}))}get UI_STEPS(){return GaiaInfoStep}onBeforeShow(){super.onBeforeShow();this.selectedFlowType="";this.setAnimationPlaying(true)}onBeforeHide(){super.onBeforeHide();this.setAnimationPlaying(false)}defaultUIStep(){return GaiaInfoStep.OVERVIEW}ready(){super.ready();this.initializeLoginScreen("GaiaInfoScreen")}setQuickStartVisible(){this.isQuickStartVisible=true;afterNextRender(this,(()=>{const dialog=this.shadowRoot?.querySelector("#gaiaInfoDialog");if(!this.hidden&&dialog instanceof OobeAdaptiveDialog){dialog.focus()}}))}getOobeUIInitialState(){return OobeUiState.GAIA_INFO}onNextClicked(){if(this.isQuickStartVisible&&this.selectedFlowType===UserCreationFlowType.QUICKSTART){this.handler.onNextClicked(GaiaInfoPageHandler_UserCreationFlowType.kQuickstart)}else{this.handler.onNextClicked(GaiaInfoPageHandler_UserCreationFlowType.kManual)}}onBackClicked(){this.handler.onBackClicked()}isNextButtonEnabled(isQuickStartVisible,selectedFlowType){return!isQuickStartVisible||selectedFlowType!==""}setAnimationPlaying(play){const gaiaInfoAnimation=this.shadowRoot.querySelector("#gaiaInfoAnimation");if(gaiaInfoAnimation){gaiaInfoAnimation.playing=play}}}customElements.define(GaiaInfoScreen.is,GaiaInfoScreen);