import{html}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";export function getTemplate(){return html`<!--_html_template_start_--><!--
Copyright 2019 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->

<style include="oobe-dialog-host-styles">[transparent]{opacity:0}[animated-transparency][transparent]{transition:opacity 500ms ease-in}[animated-transparency]:not([transparent]){transition:opacity 500ms ease-out}</style>
<gaia-dialog id="signin-frame-dialog"
    for-step="online-gaia"
    is-saml-sso-visible="[[isSamlSsoVisible]]"
    is-default-sso-provider="[[isDefaultSsoProvider]]"
    is-closable="[[isClosable]]"
    video-enabled="{{videoEnabled}}"
    auth-domain="{{authDomain}}"
    auth-flow="{{authFlow}}"
    navigation-enabled="{{navigationEnabled}}"
    navigation-hidden="[[navigationButtonsHidden]]"
    webview-name="signin-frame"
    can-go-back="{{canGaiaGoBack}}"
    on-authcompleted="onAuthCompletedMessage"
    on-backcancel="onBackButtonCancel"
    on-closesaml="closeSaml"
    on-identifierentered="onIdentifierEnteredMessage"
    on-webviewerror="onLoadAbortMessage"
    on-ready="onAuthReady"
    on-showview="onShowView"
    on-startenrollment="onStartEnrollment"
    on-exit="onExitMessage"
    on-removeuserbyemail="onRemoveUserByEmailMessage"
    on-changesigninprovider="onSamlPageChangeAccount"
    on-quick-start-clicked="onQuickStartButtonClicked">
</gaia-dialog>
<!-- TODO(dkuzmin): This alert is added here, because ChromeVox keep
                    pronouncing it several times when role="alert" is added
                    inside gaia-dialog. This problem should be resolved in
                    https://crbug.com/1288829 -->
<div id="samlVideoAlert" role="alert" hidden="[[!videoEnabled]]"
    aria-label$="[[getSamlVideoAlertMessage(locale,
        videoEnabled,
        authDomain)]]">
</div>
<security-token-pin id="pinDialog" parameters="[[pinDialogParameters]]"
    for-step="pin" on-cancel="onPinDialogCanceled"
    on-completed="onPinDialogCompleted">
</security-token-pin>
<oobe-loading-dialog title-key="gaiaLoading"
    id="step-loading" for-step="loading">
  <iron-icon slot="icon" icon="oobe-32:googleg"></iron-icon>
</oobe-loading-dialog>
<oobe-modal-dialog id="enrollmentNudge">
  <div slot="title">
    [[i18nDynamic(locale, 'enrollmentNudgeTitle')]]
  </div>
  <div slot="content">
    [[getEnrollmentNudgeMessage(locale, emailDomain)]]
  </div>
  <div slot="buttons">
    <oobe-text-button id="useAnotherAccount"
      on-click="onEnrollmentNudgeUseAnotherAccount"
      text-key="enrollmentNudgeUseAnotherAccountButton">
    </oobe-text-button>
    <oobe-text-button id="enterpriseEnrollment"
      class="focus-on-show"
      inverse on-click="onEnrollmentNudgeEnroll"
      text-key="enrollmentNudgeEnterpriseEnrollmentButton">
    </oobe-text-button>
  </div>
</oobe-modal-dialog>
<!--_html_template_end_-->`}