// Copyright 2012 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/ash/common/cr_elements/icons.html.js";import"//resources/polymer/v3_0/iron-icon/iron-icon.js";import"../../components/security_token_pin.js";import"../../components/oobe_icons.html.js";import"../../components/buttons/oobe_text_button.js";import"../../components/common_styles/oobe_common_styles.css.js";import"../../components/common_styles/oobe_dialog_host_styles.css.js";import"../../components/dialogs/oobe_loading_dialog.js";import"../../components/dialogs/oobe_modal_dialog.js";import"../../components/gaia_dialog.js";import{AuthFlow,AuthMode,SUPPORTED_PARAMS}from"//oobe/gaia_auth_host/authenticator.js";import{assert}from"//resources/js/assert.js";import{sendWithPromise}from"//resources/js/cr.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{OobeUiState}from"../../components/display_manager_types.js";import{LoginScreenMixin}from"../../components/mixins/login_screen_mixin.js";import{MultiStepMixin}from"../../components/mixins/multi_step_mixin.js";import{OobeI18nMixin}from"../../components/mixins/oobe_i18n_mixin.js";import{LoginOrUnlock,recordUmaHistogramForSamlRedirectEvent,SamlRedirectEvent}from"../../components/online_auth_utils.js";import{OobeTypes}from"../../components/oobe_types.js";import{Oobe}from"../../cr_ui.js";import{getTemplate}from"./gaia_signin.html.js";const GAIA_ANIMATION_GUARD_MILLISEC=300;const MAX_GAIA_LOADING_TIME_SEC=60;const VIDEO_LOGIN_TIMEOUT=180*1e3;var ScreenAuthMode;(function(ScreenAuthMode){ScreenAuthMode[ScreenAuthMode["DEFAULT"]=0]="DEFAULT";ScreenAuthMode[ScreenAuthMode["SAML_REDIRECT"]=1]="SAML_REDIRECT"})(ScreenAuthMode||(ScreenAuthMode={}));var DialogMode;(function(DialogMode){DialogMode["GAIA"]="online-gaia";DialogMode["LOADING"]="loading";DialogMode["PIN_DIALOG"]="pin"})(DialogMode||(DialogMode={}));const POSSIBLE_FIRST_SIGNIN_STEPS=[DialogMode.GAIA,DialogMode.LOADING];var EnrollmentNudgeUserAction;(function(EnrollmentNudgeUserAction){EnrollmentNudgeUserAction[EnrollmentNudgeUserAction["ENTERPRISE_ENROLLMENT_BUTTON"]=0]="ENTERPRISE_ENROLLMENT_BUTTON";EnrollmentNudgeUserAction[EnrollmentNudgeUserAction["USE_ANOTHER_ACCOUNT_BUTTON"]=1]="USE_ANOTHER_ACCOUNT_BUTTON";EnrollmentNudgeUserAction[EnrollmentNudgeUserAction["MAX"]=2]="MAX"})(EnrollmentNudgeUserAction||(EnrollmentNudgeUserAction={}));const GaiaSigninElementBase=LoginScreenMixin(MultiStepMixin(OobeI18nMixin(PolymerElement)));export class GaiaSigninElement extends GaiaSigninElementBase{static get is(){return"gaia-signin-element"}static get template(){return getTemplate()}static get properties(){return{loadingFrameContents:{type:Boolean,value:false},isLoadingUiShown:{type:Boolean,computed:"computeIsLoadingUiShown(loadingFrameContents, "+"authCompleted)"},navigationEnabled:{type:Boolean,value:true},isSaml:{type:Boolean,value:false,observer:"onSamlChanged"},pinDialogParameters:{type:Object,value:null,observer:"onPinDialogParametersChanged"},isSamlSsoVisible:{type:Boolean,computed:"computeSamlSsoVisible(isSaml, pinDialogParameters)"},videoEnabled:{type:Boolean,observer:"onVideoEnabledChange"},authDomain:{type:String},authFlow:{type:Number,observer:"onAuthFlowChange"},navigationButtonsHidden:{type:Boolean,value:false},canGaiaGoBack:{type:Boolean},firstSigninStep:{type:Boolean,computed:"isFirstSigninStep(uiStep, canGaiaGoBack, isSaml)",observer:"onIsFirstSigninStepChanged"},isShown:{type:Boolean,value:false},isDefaultSsoProvider:{type:Boolean,value:false},isClosable:{type:Boolean,value:false},emailDomain:{type:String}}}constructor(){super();this.authenticatorParams=null;this.email="";this.loadingTimer=undefined;this.loadAnimationGuardTimer=undefined;this.videoTimer=undefined;this.showViewProcessed=false;this.authCompleted=false;this.pinDialogResultReported=false}get EXTERNAL_API(){return["loadAuthenticator","doReload","showEnrollmentNudge","showPinDialog","closePinDialog","clickPrimaryButtonForTesting","onBeforeLoad","reset","toggleLoadingUi","setQuickStartEntryPointVisibility"]}static get observers(){return["refreshDialogStep(isShown, pinDialogParameters,"+"isLoadingUiShown)"]}defaultUIStep(){return DialogMode.GAIA}get UI_STEPS(){return DialogMode}get authenticator(){const gaiaDialog=this.shadowRoot?.querySelector("#signin-frame-dialog");assert(!!gaiaDialog);return gaiaDialog.getAuthenticator()}ready(){super.ready();this.authenticator.insecureContentBlockedCallback=this.onInsecureContentBlocked.bind(this);this.authenticator.missingGaiaInfoCallback=this.missingGaiaInfo.bind(this);this.authenticator.samlApiUsedCallback=this.samlApiUsed.bind(this);this.authenticator.recordSamlProviderCallback=this.recordSamlProvider.bind(this);this.authenticator.addEventListener("getDeviceId",(()=>{sendWithPromise("getDeviceIdForLogin").then((deviceId=>this.authenticator.getDeviceIdResponse(deviceId)))}));this.initializeLoginScreen("GaiaSigninScreen")}isFirstSigninStep(uiStep,canGaiaGoBack,isSaml){return!this.isClosable&&POSSIBLE_FIRST_SIGNIN_STEPS.includes(uiStep)&&!canGaiaGoBack&&!(isSaml&&!this.isDefaultSsoProvider)}onIsFirstSigninStepChanged(firstSigninStep){if(this.isShown){chrome.send("setIsFirstSigninStep",[firstSigninStep])}}onBackButtonCancel(){if(!this.authCompleted){this.cancel(true)}}onInterstitialBackButtonClicked(){this.cancel(true)}closeSaml(){this.videoEnabled=false;this.cancel(false)}loadAuthenticator_(doSamlRedirect){this.loadingFrameContents=true;this.isDefaultSsoProvider=doSamlRedirect;this.startLoadingTimer();assert(this.authenticatorParams!==null);this.authenticatorParams.enableGaiaActionButtons=!doSamlRedirect;this.authenticatorParams.doSamlRedirect=doSamlRedirect;this.isSaml=doSamlRedirect;if(doSamlRedirect){recordUmaHistogramForSamlRedirectEvent(LoginOrUnlock.LOGIN,this.authenticatorParams.ssoProfile?SamlRedirectEvent.START_WITH_SSO_PROFILE:SamlRedirectEvent.START_WITH_DOMAIN)}this.authenticator.load(AuthMode.DEFAULT,this.authenticatorParams)}computeSamlSsoVisible(isSaml,pinDialogParameters){return isSaml&&!pinDialogParameters}onLoadingTimeOut(){const currentScreen=Oobe.getInstance().currentScreen;if(currentScreen&&currentScreen.id!=="gaia-signin"){return}this.clearLoadingTimer();chrome.send("showLoadingTimeoutError")}clearLoadingTimer(){if(this.loadingTimer){clearTimeout(this.loadingTimer);this.loadingTimer=undefined}}startLoadingTimer(){this.clearLoadingTimer();this.loadingTimer=setTimeout(this.onLoadingTimeOut.bind(this),MAX_GAIA_LOADING_TIME_SEC*1e3)}onLoadAnimationGuardTimer(){this.loadAnimationGuardTimer=undefined;this.onShowView()}clearLoadAnimationGuardTimer(){if(this.loadAnimationGuardTimer){clearTimeout(this.loadAnimationGuardTimer);this.loadAnimationGuardTimer=undefined}}startLoadAnimationGuardTimer(){this.clearLoadAnimationGuardTimer();this.loadAnimationGuardTimer=setTimeout(this.onLoadAnimationGuardTimer.bind(this),GAIA_ANIMATION_GUARD_MILLISEC)}getOobeUIInitialState(){return OobeUiState.GAIA_SIGNIN}onBeforeShow(data){this.navigationEnabled=true;this.isShown=true;if(data&&"hasUserPods"in data){this.isClosable=data.hasUserPods}const pinDialog=this.shadowRoot?.querySelector("#pinDialog");assert(!!pinDialog);pinDialog.onBeforeShow();super.onBeforeShow(data)}getSigninFrame(){const gaiaDialog=this.shadowRoot?.querySelector("#signin-frame-dialog");assert(!!gaiaDialog);return gaiaDialog.getFrame()}onBeforeHide(){super.onBeforeHide();this.isShown=false;this.authenticator.resetWebview()}loadAuthenticator(data){this.authenticator.setWebviewPartition(data.webviewPartitionName);this.authCompleted=false;this.navigationButtonsHidden=false;this.closePinDialog();const params={};SUPPORTED_PARAMS.forEach((name=>{if(data.hasOwnProperty(name)){params[name]=data[name]}}));params.doSamlRedirect=data.screenMode===ScreenAuthMode.SAML_REDIRECT;params.menuEnterpriseEnrollment=!(data.enterpriseManagedDevice||data.hasDeviceOwner);params.isFirstUser=!(data.enterpriseManagedDevice||data.hasDeviceOwner);this.authenticatorParams=params;this.loadAuthenticator_(params.doSamlRedirect);chrome.send("authenticatorLoaded")}isSamlAuthFlowForTesting(){return this.isSaml&&this.authFlow===AuthFlow.SAML}clearVideoTimer(){if(this.videoTimer!==undefined){clearTimeout(this.videoTimer);this.videoTimer=undefined}}onVideoEnabledChange(){if(this.videoEnabled&&this.videoTimer===undefined){this.videoTimer=setTimeout(this.cancel.bind(this),VIDEO_LOGIN_TIMEOUT)}else{this.clearVideoTimer()}}reset(){this.clearLoadingTimer();this.clearVideoTimer();this.authCompleted=false;this.authenticator.resetWebview();this.authenticator.resetStates();this.navigationButtonsHidden=true;this.videoEnabled=false}onAuthFlowChange(){this.isSaml=this.authFlow===AuthFlow.SAML}onSamlChanged(){chrome.send("samlStateChanged",[this.isSaml]);this.classList.toggle("saml",this.isSaml)}onAuthReady(){this.showViewProcessed=false;this.startLoadAnimationGuardTimer();this.clearLoadingTimer();setTimeout((()=>{this.loadingFrameContents=false}),100)}onStartEnrollment(){this.userActed("startEnrollment")}onShowView(){if(this.showViewProcessed){return}this.showViewProcessed=true;this.clearLoadAnimationGuardTimer();this.onLoginUiVisible()}onLoginUiVisible(){chrome.send("loginWebuiReady")}onInsecureContentBlocked(url){this.showFatalAuthError(OobeTypes.FatalErrorCode.INSECURE_CONTENT_BLOCKED,{url:url})}showFatalAuthError(errorCode,info){chrome.send("onFatalError",[errorCode,info||{}])}missingGaiaInfo(){this.showFatalAuthError(OobeTypes.FatalErrorCode.MISSING_GAIA_INFO)}samlApiUsed(isThirdPartyIdP){chrome.send("usingSAMLAPI",[isThirdPartyIdP])}recordSamlProvider(x509Certificate){chrome.send("recordSamlProvider",[x509Certificate])}onAuthCompletedMessage(e){const credentials=e.detail;if(credentials.publicSAML){this.email=credentials.email;chrome.send("launchSAMLPublicSession",[credentials.email])}else{chrome.send("completeAuthentication",[credentials.gaiaId,credentials.email,credentials.password,credentials.scrapedSAMLPasswords,credentials.usingSAML,credentials.services,credentials.servicesProvided,credentials.passwordAttributes,credentials.syncTrustedVaultKeys||{}])}this.navigationButtonsHidden=true;this.clearVideoTimer();this.authCompleted=true}onLoadAbortMessage(e){chrome.send("webviewLoadAborted",[e.detail.error_code])}onExitMessage(){this.cancel()}onIdentifierEnteredMessage(e){this.userActed(["identifierEntered",e.detail.accountIdentifier])}onRemoveUserByEmailMessage(e){chrome.send("removeUserByEmail",[e.detail]);this.cancel()}doReload(){this.authenticator.reload();this.loadingFrameContents=true;this.startLoadingTimer();this.authCompleted=false;this.navigationButtonsHidden=false}cancel(isBackClicked=false){this.clearVideoTimer();if(this.authCompleted){return}if(this.isSamlSsoVisible&&!this.isDefaultSsoProvider){this.userActed(["reloadGaia",false]);return}this.userActed(isBackClicked?"back":"cancel")}showEnrollmentNudge(domain){this.reset();this.emailDomain=domain;const enrollmentNudgeDialog=this.shadowRoot?.querySelector("#enrollmentNudge");assert(!!enrollmentNudgeDialog);enrollmentNudgeDialog.showDialog()}toggleLoadingUi(isShown){this.loadingFrameContents=isShown}getEnrollmentNudgeMessage(locale,domain){return this.i18nDynamic(locale,"enrollmentNudgeMessage",domain)}onEnrollmentNudgeUseAnotherAccount(){this.recordUmaHistogramForEnrollmentNudgeUserAction(EnrollmentNudgeUserAction.USE_ANOTHER_ACCOUNT_BUTTON);const enrollmentNudgeDialog=this.shadowRoot?.querySelector("#enrollmentNudge");assert(!!enrollmentNudgeDialog);enrollmentNudgeDialog.hideDialog();this.doReload()}onEnrollmentNudgeEnroll(){this.recordUmaHistogramForEnrollmentNudgeUserAction(EnrollmentNudgeUserAction.ENTERPRISE_ENROLLMENT_BUTTON);const enrollmentNudgeDialog=this.shadowRoot?.querySelector("#enrollmentNudge");assert(!!enrollmentNudgeDialog);enrollmentNudgeDialog.hideDialog();this.userActed("startEnrollment")}showPinDialog(parameters){assert(parameters);this.pinDialogParameters=parameters;this.pinDialogResultReported=false}closePinDialog(){this.pinDialogParameters=null}onPinDialogParametersChanged(newValue,oldValue){if(oldValue===undefined){return}if(oldValue===null&&newValue!==null){requestAnimationFrame((()=>{const pinDialog=this.shadowRoot?.querySelector("#pinDialog");if(pinDialog){pinDialog.focus()}chrome.send("securityTokenPinDialogShownForTest")}))}if(oldValue!==null&&newValue===null||oldValue!==null&&newValue!==null&&!this.pinDialogResultReported){chrome.send("securityTokenPinEntered",[""])}}onPinDialogCanceled(){this.closePinDialog();this.cancel()}onPinDialogCompleted(e){this.pinDialogResultReported=true;chrome.send("securityTokenPinEntered",[e.detail])}refreshDialogStep(isScreenShown,pinParams,isLoading){if(!isScreenShown){return}if(pinParams!==null){this.setUIStep(DialogMode.PIN_DIALOG);return}if(isLoading){this.setUIStep(DialogMode.LOADING);return}this.setUIStep(DialogMode.GAIA)}onSamlPageChangeAccount(){recordUmaHistogramForSamlRedirectEvent(LoginOrUnlock.LOGIN,SamlRedirectEvent.CHANGE_TO_DEFAULT_GOOGLE_SIGN_IN);this.userActed(["reloadGaia",true])}computeIsLoadingUiShown(loadingFrameContents,authCompleted){return loadingFrameContents||authCompleted}clickPrimaryButtonForTesting(){const gaiaDialog=this.shadowRoot?.querySelector("#signin-frame-dialog");assert(!!gaiaDialog);gaiaDialog.clickPrimaryButtonForTesting()}onBeforeLoad(){}getSamlVideoAlertMessage(locale,videoEnabled,authDomain){if(videoEnabled&&authDomain){return this.i18nDynamic(locale,"samlNoticeWithVideo",authDomain)}return""}onQuickStartButtonClicked(){this.userActed("activateQuickStart")}setQuickStartEntryPointVisibility(visible){const gaiaDialog=this.shadowRoot?.querySelector("#signin-frame-dialog");assert(!!gaiaDialog);gaiaDialog.isQuickStartEnabled=visible}recordUmaHistogramForEnrollmentNudgeUserAction(userAction){chrome.send("metricsHandler:recordInHistogram",["Enterprise.EnrollmentNudge.UserAction",userAction,EnrollmentNudgeUserAction.MAX])}}customElements.define(GaiaSigninElement.is,GaiaSigninElement);