// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/polymer/v3_0/iron-icon/iron-icon.js";import"../../components/oobe_icons.html.js";import"../../components/buttons/oobe_back_button.js";import"../../components/buttons/oobe_text_button.js";import"../../components/common_styles/oobe_common_styles.css.js";import"../../components/common_styles/oobe_dialog_host_styles.css.js";import"../../components/dialogs/oobe_loading_dialog.js";import{loadTimeData}from"//resources/js/load_time_data.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{LoginScreenMixin}from"../../components/mixins/login_screen_mixin.js";import{MultiStepMixin}from"../../components/mixins/multi_step_mixin.js";import{OobeDialogHostMixin}from"../../components/mixins/oobe_dialog_host_mixin.js";import{OobeI18nMixin}from"../../components/mixins/oobe_i18n_mixin.js";import{getTemplate}from"./managed_terms_of_service.html.js";var ManagedTermsState;(function(ManagedTermsState){ManagedTermsState["LOADING"]="loading";ManagedTermsState["LOADED"]="loaded";ManagedTermsState["ERROR"]="error"})(ManagedTermsState||(ManagedTermsState={}));const ManagedTermsOfServiceBase=OobeDialogHostMixin(LoginScreenMixin(MultiStepMixin(OobeI18nMixin(PolymerElement))));export class ManagedTermsOfService extends ManagedTermsOfServiceBase{static get is(){return"managed-terms-of-service-element"}static get template(){return getTemplate()}static get properties(){return{backButtonDisabled:{type:Boolean,value:false},retryButtonDisabled:{type:Boolean,value:true},acceptButtonDisabled:{type:Boolean,value:true},tosManager:{type:String,value:""}}}constructor(){super()}defaultUIStep(){return ManagedTermsState.LOADING}get UI_STEPS(){return ManagedTermsState}get EXTERNAL_API(){return["setTermsOfServiceLoadError","setTermsOfService"]}onBeforeShow(data){super.onBeforeShow(data);this.tosManager=data.manager}ready(){super.ready();this.initializeLoginScreen("TermsOfServiceScreen")}onTermsOfServiceAccepted(){this.backButtonDisabled=true;this.acceptButtonDisabled=true;this.userActed("accept")}onTosBackButtonPressed(){this.backButtonDisabled=true;this.retryButtonDisabled=true;this.acceptButtonDisabled=true;this.userActed("back")}onTosRetryButtonPressed(){this.retryButtonDisabled=true;this.userActed("retry");this.setUIStep(ManagedTermsState.LOADING)}setTermsOfServiceLoadError(){this.setUIStep(ManagedTermsState.ERROR);this.acceptButtonDisabled=true;this.backButtonDisabled=false;this.retryButtonDisabled=false}setTermsOfService(termsOfService){const webview=this.shadowRoot.getElementById("termsOfServiceFrame");webview.src="data:text/html;charset=utf-8,"+encodeURIComponent("<style>"+"body {"+this.getServiceLogsFontsStyling()+"  color: RGBA(0,0,0,.87);"+"  margin : 0;"+"  padding : 0;"+"  white-space: pre-wrap;"+"}"+"#tosContainer {"+"  overflow: auto;"+"  height: 99%;"+"  padding-left: 16px;"+"  padding-right: 16px;"+"}"+"#tosContainer::-webkit-scrollbar-thumb {"+"  border-radius: 10px;"+"}"+"</style>"+'<body><div id="tosContainer">'+termsOfService+"</div>"+"</body>");this.acceptButtonDisabled=false;this.setUIStep(ManagedTermsState.LOADED)}getServiceLogsFontsStyling(){const isOobeJellyEnabled=loadTimeData.getBoolean("isOobeJellyEnabled");if(!isOobeJellyEnabled){return"  font-family: Roboto, sans-serif;"+"  font-size: 14sp;"}return"  font-family: Google Sans Text Regular, Google Sans, Roboto, sans-serif;"+"  font-size: 13px;"+"  font-weight: 400;"+"  line-height: 20px;"}}customElements.define(ManagedTermsOfService.is,ManagedTermsOfService);