// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/ash/common/cr_elements/cros_color_overrides.css.js";import"//resources/ash/common/cr_elements/cr_toggle/cr_toggle.js";import"//resources/polymer/v3_0/iron-icon/iron-icon.js";import"//resources/polymer/v3_0/iron-iconset-svg/iron-iconset-svg.js";import"../../components/oobe_a11y_option.js";import"../../components/oobe_cr_lottie.js";import"../../components/oobe_icons.html.js";import"../../components/buttons/oobe_back_button.js";import"../../components/buttons/oobe_icon_button.js";import"../../components/buttons/oobe_text_button.js";import"../../components/dialogs/oobe_adaptive_dialog.js";import"../../components/common_styles/oobe_common_styles.css.js";import"../../components/common_styles/oobe_dialog_host_styles.css.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{OobeUiState}from"../../components/display_manager_types.js";import{LoginScreenMixin}from"../../components/mixins/login_screen_mixin.js";import{MultiStepMixin}from"../../components/mixins/multi_step_mixin.js";import{OobeI18nMixin}from"../../components/mixins/oobe_i18n_mixin.js";import{getTemplate}from"./marketing_opt_in.html.js";const MarketingScreenElementBase=LoginScreenMixin(MultiStepMixin(OobeI18nMixin(PolymerElement)));var MarketingOptInStep;(function(MarketingOptInStep){MarketingOptInStep["OVERVIEW"]="overview";MarketingOptInStep["ACCESSIBILITY"]="accessibility"})(MarketingOptInStep||(MarketingOptInStep={}));export class MarketingOptIn extends MarketingScreenElementBase{static get is(){return"marketing-opt-in-element"}static get template(){return getTemplate()}static get properties(){return{isA11ySettingsButtonVisible:{type:Boolean,value:false},marketingOptInVisible:{type:Boolean,value:false},hasLegalFooter:{type:Boolean,value:false},isCloudGamingDevice:{type:Boolean,value:false}}}get UI_STEPS(){return MarketingOptInStep}defaultUIStep(){return MarketingOptInStep.OVERVIEW}getOobeUIInitialState(){return OobeUiState.MARKETING_OPT_IN}get EXTERNAL_API(){return["updateA11ySettingsButtonVisibility","updateA11yNavigationButtonToggle"]}ready(){super.ready();this.initializeLoginScreen("MarketingOptInScreen")}setAnimationPlay(played){const animation=this.shadowRoot.querySelector("#animation");if(animation){animation.playing=played}}onBeforeShow(data){super.onBeforeShow(data);this.marketingOptInVisible="optInVisibility"in data&&data.optInVisibility;this.shadowRoot.querySelector("#chromebookUpdatesOption").checked="optInDefaultState"in data&&data.optInDefaultState;this.hasLegalFooter="legalFooterVisibility"in data&&data.legalFooterVisibility;this.isCloudGamingDevice="cloudGamingDevice"in data&&data.cloudGamingDevice;this.setAnimationPlay(true);this.shadowRoot.querySelector("#marketingOptInOverviewDialog").show()}get defaultControl(){return this.shadowRoot.querySelector("#marketingOptInOverviewDialog")}onGetStarted(){this.setAnimationPlay(false);this.userActed(["get-started",this.shadowRoot.querySelector("#chromebookUpdatesOption").checked])}updateA11ySettingsButtonVisibility(shown){this.isA11ySettingsButtonVisible=shown}updateA11yNavigationButtonToggle(enabled){this.shadowRoot.querySelector("#a11yNavButtonToggle").checked=enabled}onToggleAccessibilityPage(){if(this.uiStep===MarketingOptInStep.OVERVIEW){this.setUIStep(MarketingOptInStep.ACCESSIBILITY);this.setAnimationPlay(false)}else{this.setUIStep(MarketingOptInStep.OVERVIEW);this.setAnimationPlay(true)}}onA11yNavButtonsSettingChanged(){this.userActed(["set-a11y-button-enable",this.shadowRoot.querySelector("#a11yNavButtonToggle").checked])}getIcon(){return this.isCloudGamingDevice?"oobe-32:game-controller":"oobe-32:checkmark"}}customElements.define(MarketingOptIn.is,MarketingOptIn);