// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/ash/common/cr_elements/cros_color_overrides.css.js";import"//resources/ash/common/cr_elements/cr_checkbox/cr_checkbox.js";import"//resources/js/action_link.js";import"//resources/polymer/v3_0/iron-icon/iron-icon.js";import"../../components/oobe_icons.html.js";import"../../components/common_styles/oobe_common_styles.css.js";import"../../components/common_styles/oobe_dialog_host_styles.css.js";import"../../components/buttons/oobe_text_button.js";import{getInstance as getAnnouncerInstance}from"//resources/ash/common/cr_elements/cr_a11y_announcer/cr_a11y_announcer.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{LoginScreenMixin}from"../../components/mixins/login_screen_mixin.js";import{MultiStepMixin}from"../../components/mixins/multi_step_mixin.js";import{OobeI18nMixin}from"../../components/mixins/oobe_i18n_mixin.js";import{getTemplate}from"./oobe_reset.html.js";var ResetScreenUiState;(function(ResetScreenUiState){ResetScreenUiState["RESTART_REQUIRED"]="restart-required";ResetScreenUiState["REVERT_PROMISE"]="revert-promise";ResetScreenUiState["POWERWASH_PROPOSAL"]="powerwash-proposal";ResetScreenUiState["ERROR"]="error"})(ResetScreenUiState||(ResetScreenUiState={}));const ResetScreenUiStateMapping=[ResetScreenUiState.RESTART_REQUIRED,ResetScreenUiState.REVERT_PROMISE,ResetScreenUiState.POWERWASH_PROPOSAL,ResetScreenUiState.ERROR];var PowerwashMode;(function(PowerwashMode){PowerwashMode[PowerwashMode["POWERWASH_WITH_ROLLBACK"]=0]="POWERWASH_WITH_ROLLBACK";PowerwashMode[PowerwashMode["POWERWASH_ONLY"]=1]="POWERWASH_ONLY"})(PowerwashMode||(PowerwashMode={}));const POWERWASH_MODE_DETAILS=new Map([[PowerwashMode.POWERWASH_WITH_ROLLBACK,{subtitleText:"resetPowerwashRollbackWarningDetails",dialogTitle:"confirmRollbackTitle",dialogContent:"confirmRollbackMessage",buttonTextKey:"resetButtonPowerwashAndRollback"}],[PowerwashMode.POWERWASH_ONLY,{subtitleText:"resetPowerwashWarningDetails",dialogTitle:"confirmPowerwashTitle",dialogContent:"confirmPowerwashMessage",buttonTextKey:"resetButtonPowerwash"}]]);const ResetScreenElementBase=LoginScreenMixin(MultiStepMixin(OobeI18nMixin(PolymerElement)));export class OobeReset extends ResetScreenElementBase{static get is(){return"oobe-reset-element"}static get template(){return getTemplate()}static get properties(){return{isRollbackAvailable_:{type:Boolean,value:false,observer:"updatePowerwashModeBasedOnRollbackOptions"},isRollbackRequested_:{type:Boolean,value:false,observer:"updatePowerwashModeBasedOnRollbackOptions"},tpmUpdateAvailable_:{type:Boolean},tpmUpdateChecked_:{type:Boolean},tpmUpdateEditable_:{type:Boolean},tpmUpdateMode_:{type:String},confirmationDialogTitle_:{type:String,computed:"getConfirmationDialogTitle(locale, powerwashMode_)"},confirmationDialogText_:{type:String,computed:"getConfirmationDialogText(locale, powerwashMode_)"},powerwashStateSubtitle_:{type:String,computed:"getPowerwashStateSubtitle(locale, powerwashMode_)"},powerwashButtonTextKey_:{type:String,computed:"getPowerwashButtonTextKey(locale, powerwashMode_)"},powerwashButtonDisabled_:{type:Boolean,computed:"isPowerwashDisabled(powerwashMode_, tpmUpdateChecked_)"},powerwashMode_:{type:Number,value:PowerwashMode.POWERWASH_ONLY},inRevertState_:{type:Boolean,value:false}}}static get observers(){return["onScreenStateChanged(uiStep)"]}constructor(){super();this.isRollbackAvailable_=false;this.isRollbackRequested_=false;this.tpmUpdateAvailable_=false;this.tpmUpdateChecked_=false;this.tpmUpdateEditable_=true}get EXTERNAL_API(){return["setIsRollbackAvailable","setIsRollbackRequested","setIsTpmFirmwareUpdateAvailable","setIsTpmFirmwareUpdateChecked","setIsTpmFirmwareUpdateEditable","setTpmFirmwareUpdateMode","setShouldShowConfirmationDialog","setScreenState"]}defaultUIStep(){return ResetScreenUiState.RESTART_REQUIRED}get UI_STEPS(){return ResetScreenUiState}ready(){super.ready();this.reset();this.setShouldShowConfirmationDialog(false);this.initializeLoginScreen("ResetScreen")}reset(){this.setUIStep(ResetScreenUiState.RESTART_REQUIRED);this.powerwashMode_=PowerwashMode.POWERWASH_ONLY;this.isRollbackAvailable_=false;this.isRollbackRequested_=false;this.tpmUpdateAvailable_=false;this.tpmUpdateChecked_=false;this.tpmUpdateEditable_=true}setIsRollbackAvailable(rollbackAvailable){this.isRollbackAvailable_=rollbackAvailable}setIsRollbackRequested(rollbackRequested){this.isRollbackRequested_=rollbackRequested}setIsTpmFirmwareUpdateAvailable(value){this.tpmUpdateAvailable_=value}setIsTpmFirmwareUpdateChecked(value){this.tpmUpdateChecked_=value}setIsTpmFirmwareUpdateEditable(value){this.tpmUpdateEditable_=value}setTpmFirmwareUpdateMode(value){this.tpmUpdateMode_=value}setShouldShowConfirmationDialog(shouldShow){const confirmationDialog=this.shadowRoot.querySelector("#confirmationDialog");if(shouldShow){confirmationDialog.showDialog()}else{confirmationDialog.hideDialog()}}setScreenState(state){this.setUIStep(ResetScreenUiStateMapping[state])}updatePowerwashModeBasedOnRollbackOptions(){if(this.isRollbackAvailable_&&this.isRollbackRequested_){this.powerwashMode_=PowerwashMode.POWERWASH_WITH_ROLLBACK;this.classList.add("rollback-proposal-view")}else{this.powerwashMode_=PowerwashMode.POWERWASH_ONLY;this.classList.remove("rollback-proposal-view")}}onScreenStateChanged(){if(this.uiStep===ResetScreenUiState.REVERT_PROMISE){getAnnouncerInstance().announce(this.i18n("resetRevertSpinnerMessage"));this.classList.add("revert-promise-view")}else{this.classList.remove("revert-promise-view")}this.inRevertState_=this.uiStep===ResetScreenUiState.REVERT_PROMISE}getPowerwashStateSubtitle(_locale,_mode){if(this.powerwashMode_===undefined){return""}const modeDetails=POWERWASH_MODE_DETAILS.get(this.powerwashMode_);return this.i18n(modeDetails.subtitleText)}getPowerwashButtonTextKey(_locale,_mode){if(this.powerwashMode_===undefined){return""}return POWERWASH_MODE_DETAILS.get(this.powerwashMode_).buttonTextKey}isPowerwashDisabled(_mode,_tpmUpdateChecked){return this.tpmUpdateChecked_&&this.powerwashMode_===PowerwashMode.POWERWASH_WITH_ROLLBACK}getConfirmationDialogTitle(_locale,_mode){if(this.powerwashMode_===undefined){return""}const modeDetails=POWERWASH_MODE_DETAILS.get(this.powerwashMode_);return this.i18n(modeDetails.dialogTitle)}getConfirmationDialogText(_locale,_mode){if(this.powerwashMode_===undefined){return""}const modeDetails=POWERWASH_MODE_DETAILS.get(this.powerwashMode_);return this.i18n(modeDetails.dialogContent)}onDialogContinueClick(){this.userActed("powerwash-pressed")}onDialogCancelClick(){const confirmationDialog=this.shadowRoot.querySelector("#confirmationDialog");confirmationDialog.hideDialog();this.userActed("reset-confirm-dismissed")}onDialogClosed(){this.userActed("reset-confirm-dismissed")}onCancelClick(){this.userActed("cancel-reset")}onRestartClick(){this.userActed("restart-pressed")}onPowerwashClick(){this.userActed("show-confirmation")}onLearnMoreClick(){this.userActed("learn-more-link")}onTpmFirmwareUpdateChanged(){const tpmFirmwareUpdateCheckbox=this.shadowRoot.querySelector("#tpmFirmwareUpdateCheckbox");const checked=tpmFirmwareUpdateCheckbox.checked;this.userActed(["tpmfirmware-update-checked",checked])}onTpmFirmwareUpdateLearnMore(event){this.userActed("tpm-firmware-update-learn-more-link");event.stopPropagation()}}customElements.define(OobeReset.is,OobeReset);