// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/polymer/v3_0/iron-icon/iron-icon.js";import"../../components/dialogs/oobe_loading_dialog.js";import{assert}from"//resources/js/assert.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{LoginScreenMixin}from"../../components/mixins/login_screen_mixin.js";import{MultiStepMixin}from"../../components/mixins/multi_step_mixin.js";import{OobeDialogHostMixin}from"../../components/mixins/oobe_dialog_host_mixin.js";import{OobeI18nMixin}from"../../components/mixins/oobe_i18n_mixin.js";import{getTemplate}from"./perks_discovery.html.js";export const PerksDiscoveryElementBase=OobeDialogHostMixin(LoginScreenMixin(MultiStepMixin(OobeI18nMixin(PolymerElement))));const GENERATE_WEB_VIEW_CSS=()=>({code:`svg {\n          width: 100%;\n          height: 100%;\n          background-color: `+getComputedStyle(document.body).getPropertyValue("--cros-sys-app_base_shaded")+`;\n          --cros-sys-illo-color1 :`+getComputedStyle(document.body).getPropertyValue("--cros-sys-illo-color1")+`;\n          --cros-sys-illo-color1-1 :`+getComputedStyle(document.body).getPropertyValue("--cros-sys-illo-color1-1")+`;\n          --cros-sys-illo-color1-2 :`+getComputedStyle(document.body).getPropertyValue("--cros-sys-illo-color1-2")+`;\n          --cros-sys-illo-color2 :`+getComputedStyle(document.body).getPropertyValue("--cros-sys-illo-color2")+`;\n          --cros-sys-illo-color3 :`+getComputedStyle(document.body).getPropertyValue("--cros-sys-illo-color3")+`;\n          --cros-sys-illo-color4 :`+getComputedStyle(document.body).getPropertyValue("--cros-sys-illo-color4")+`;\n          --cros-sys-illo-color5 :`+getComputedStyle(document.body).getPropertyValue("--cros-sys-illo-color5")+`;\n          --cros-sys-illo-color6 :`+getComputedStyle(document.body).getPropertyValue("--cros-sys-illo-color6")+`;\n          --cros-sys-illo-base :`+getComputedStyle(document.body).getPropertyValue("--cros-sys-illo-base")+`;\n          --cros-sys-illo-secondary :`+getComputedStyle(document.body).getPropertyValue("--cros-sys-illo-secondary")+`;\n          --cros-sys-illo-on_primary_container :`+getComputedStyle(document.body).getPropertyValue("--cros-sys-illo-on_primary_container")+`;\n          --cros-sys-illo-card-color1:`+getComputedStyle(document.body).getPropertyValue("--cros-sys-illo-card-color1")+`;\n          --cros-sys-illo-card-color2 :`+getComputedStyle(document.body).getPropertyValue("--cros-sys-illo-card-color2")+`;\n          --cros-sys-illo-card-color3 :`+getComputedStyle(document.body).getPropertyValue("--cros-sys-illo-card-color3")+`;\n          --cros-sys-illo-card-color4 :`+getComputedStyle(document.body).getPropertyValue("--cros-sys-illo-card-color4")+`;\n          --cros-sys-illo-card-color5 :`+getComputedStyle(document.body).getPropertyValue("--cros-sys-illo-card-color5")+`;\n          --cros-sys-illo-card-on_color1 :`+getComputedStyle(document.body).getPropertyValue("--cros-sys-illo-card-on_color1")+`;\n          --cros-sys-illo-card-on_color2 :`+getComputedStyle(document.body).getPropertyValue("--cros-sys-illo-card-on_color2")+`;\n          --cros-sys-illo-card-on_color3 :`+getComputedStyle(document.body).getPropertyValue("--cros-sys-illo-card-on_color3")+`;\n          --cros-sys-illo-card-on_color4 :`+getComputedStyle(document.body).getPropertyValue("--cros-sys-illo-card-on_color4")+`;\n          --cros-sys-illo-card-on_color5 :`+getComputedStyle(document.body).getPropertyValue("--cros-sys-illo-card-on_color5")+`;\n          --cros-sys-app_base_shaded :`+getComputedStyle(document.body).getPropertyValue("--cros-sys-app_base_shaded")+`;\n          --cros-sys-app_base :`+getComputedStyle(document.body).getPropertyValue("--cros-sys-app_base")+`;\n          --cros-sys-base_elevated :`+getComputedStyle(document.body).getPropertyValue("--cros-sys-base_elevated")+`;\n          --cros-sys-illo-analog :`+getComputedStyle(document.body).getPropertyValue("--cros-sys-illo-analog")+`;\n          --cros-sys-illo-muted :`+getComputedStyle(document.body).getPropertyValue("--cros-sys-illo-muted")+`;\n          --cros-sys-illo-complement :`+getComputedStyle(document.body).getPropertyValue("--cros-sys-illo-complement")+`;\n          --cros-sys-illo-on_gradient :`+getComputedStyle(document.body).getPropertyValue("--cros-sys-illo-on_gradient")+`;\n          --cros-sys-illo-analog_variant :`+getComputedStyle(document.body).getPropertyValue("--cros-sys-illo-analog_variant")+`;\n          --cros-sys-illo-muted_variant :`+getComputedStyle(document.body).getPropertyValue("--cros-sys-illo-muted_variant")+`;\n          --cros-sys-illo-complement_variant :`+getComputedStyle(document.body).getPropertyValue("--cros-sys-illo-complement_variant")+`;\n          --cros-sys-illo-on_gradient_variant :`+getComputedStyle(document.body).getPropertyValue("--cros-sys-illo-on_gradient_variant")+`;\n          --cros-sys-primary: `+getComputedStyle(document.body).getPropertyValue("--cros-sys-primary")+`;\n    }`});var UserAction;(function(UserAction){UserAction["FINISHED"]="finished";UserAction["LOADED"]="loaded"})(UserAction||(UserAction={}));var PerksDiscoveryStep;(function(PerksDiscoveryStep){PerksDiscoveryStep["LOADING"]="loading";PerksDiscoveryStep["OVERVIEW"]="overview"})(PerksDiscoveryStep||(PerksDiscoveryStep={}));export class PerksDiscoveryElement extends PerksDiscoveryElementBase{static get is(){return"perks-discovery-element"}static get template(){return getTemplate()}static get properties(){return{perksList:{type:Array,value:[],notify:true},selectedPerks:{type:Object},currentPerk:{type:Number,value:-1},itemIconsRendered:{type:Number,value:0},itemIllustrationsRendered:{type:Number,value:0}}}get UI_STEPS(){return PerksDiscoveryStep}static get observers(){return["itemContentRendered(itemIconsRendered, itemIllustrationsRendered)"]}defaultUIStep(){return PerksDiscoveryStep.LOADING}ready(){super.ready();this.initializeLoginScreen("PerksDiscoveryScreenScreen")}get EXTERNAL_API(){return["setPerksData","setOverviewStep"]}onBeforeHide(){super.onBeforeHide();this.perksList=[];this.currentPerk=-1;this.itemIconsRendered=0;this.itemIllustrationsRendered=0;if(this.selectedPerks){this.selectedPerks.clear()}}isElementHidden(currentPerk,index){return!(currentPerk===index)}setPerksData(perksData){assert(perksData!==null);this.perksList=perksData;this.selectedPerks=new Set}setOverviewStep(){this.currentPerk=0;this.setUIStep(PerksDiscoveryStep.OVERVIEW)}itemContentRendered(itemIconsRendered,itemIllustrationsRendered){if(this.perksList.length===0){return}if(itemIconsRendered===this.perksList.length){this.setIconsWebviewStyle()}if(itemIllustrationsRendered===this.perksList.length){this.setIllustrationWebviewStyle()}if(itemIconsRendered===this.perksList.length&&itemIllustrationsRendered===this.perksList.length){this.userActed(UserAction.LOADED)}}setIllustrationWebviewStyle(){const iconWebviews=this.shadowRoot?.querySelectorAll(".illustration");if(iconWebviews){iconWebviews.forEach(((iconWebview,index)=>{iconWebview.style["width"]=this.perksList[index].illustrationWidth;iconWebview.style["height"]=this.perksList[index].illustrationHeight;this.injectCss(iconWebview)}))}}setIconsWebviewStyle(){const iconWebviews=this.shadowRoot?.querySelectorAll(".perk-icon");if(iconWebviews){for(const iconWebview of iconWebviews){this.injectCss(iconWebview)}}}injectCss(webview){webview.addEventListener("contentload",(()=>{webview.insertCSS(GENERATE_WEB_VIEW_CSS(),(()=>{if(chrome.runtime.lastError){console.warn("Failed to insertCSS: "+chrome.runtime.lastError.message)}}))}))}onBackClicked(){assert(this.currentPerk>0);this.currentPerk--}canGoBack(currentStep){return currentStep>0}advanceToNextPerk(){if(this.currentPerk===this.perksList.length-1){this.userActed([UserAction.FINISHED,Array.from(this.selectedPerks)]);return}this.currentPerk++}onNotInterestedClicked(){this.selectedPerks.delete(this.perksList[this.currentPerk].perkId);this.advanceToNextPerk()}onInterestedClicked(){this.selectedPerks.add(this.perksList[this.currentPerk].perkId);this.advanceToNextPerk()}getCurrentPerkTitle(currentPerk){if(currentPerk===-1){return""}assert(currentPerk>=0&&currentPerk<this.perksList.length);return this.perksList[currentPerk].title}getCurrentPerkSubtitle(currentPerk){if(currentPerk===-1){return""}assert(currentPerk>=0&&currentPerk<this.perksList.length);return this.perksList[currentPerk].subtitle}getCurrentPerkAdditionalText(currentPerk){if(currentPerk===-1){return""}assert(currentPerk>=0&&currentPerk<this.perksList.length);if(!this.perksList[currentPerk].additionalText){return""}return this.perksList[currentPerk].additionalText}getCurrentPerkPrimaryButtonLabel(currentPerk){if(currentPerk===-1){return""}assert(currentPerk>=0&&currentPerk<this.perksList.length);return this.perksList[currentPerk].primaryButtonLabel}getCurrentPerkSecondaryButtonLabel(currentPerk){if(currentPerk===-1){return""}assert(currentPerk>=0&&currentPerk<this.perksList.length);return this.perksList[currentPerk].secondaryButtonLabel}}customElements.define(PerksDiscoveryElement.is,PerksDiscoveryElement);