// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"../../components/common_styles/oobe_common_styles.css.js";import"../../components/dialogs/oobe_loading_dialog.js";import"../../components/quick_start_pin.js";import{assert}from"//resources/js/assert.js";import{flush,PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{OobeModalDialog}from"../../components/dialogs/oobe_modal_dialog.js";import{LoginScreenMixin}from"../../components/mixins/login_screen_mixin.js";import{MultiStepMixin}from"../../components/mixins/multi_step_mixin.js";import{OobeI18nMixin}from"../../components/mixins/oobe_i18n_mixin.js";import{OobeCrLottie}from"../../components/oobe_cr_lottie.js";import{QrCodeCanvas}from"../../components/qr_code_canvas.js";import{loadTimeData}from"../../i18n_setup.js";import{getTemplate}from"./quick_start.html.js";var QuickStartUiState;(function(QuickStartUiState){QuickStartUiState["DEFAULT"]="default";QuickStartUiState["CONNECTING_TO_PHONE"]="connecting_to_phone";QuickStartUiState["VERIFICATION"]="verification";QuickStartUiState["CONNECTING_TO_WIFI"]="connecting_to_wifi";QuickStartUiState["CONNECTED_TO_WIFI"]="connected_to_wifi";QuickStartUiState["CONFIRM_GOOGLE_ACCOUNT"]="confirm_google_account";QuickStartUiState["SIGNING_IN"]="signing_in";QuickStartUiState["SETUP_COMPLETE"]="setup_complete"})(QuickStartUiState||(QuickStartUiState={}));var UserActions;(function(UserActions){UserActions["CANCEL"]="cancel";UserActions["NEXT"]="next";UserActions["TURN_ON_BLUETOOTH"]="turn_on_bluetooth"})(UserActions||(UserActions={}));const QuickStartScreenBase=LoginScreenMixin(MultiStepMixin(OobeI18nMixin(PolymerElement)));export class QuickStartScreen extends QuickStartScreenBase{static get is(){return"quick-start-element"}static get template(){return getTemplate()}static get properties(){return{pin:{type:String,value:"0000"},usePinInsteadOfQrForVerification:{type:Boolean,value:false},userEmail:{type:String,value:""},userFullName:{type:String,value:""},userAvatarUrl:{type:String,value:""},canCancelSignin:{type:Boolean,value:true},willRequestWiFi:{type:Boolean,value:true},didTransferWiFi:{type:Boolean,value:false},qrCodeAvailable:{type:Boolean,value:false},isOobeOverlayDebuggerEnabled:{type:Boolean,value:loadTimeData.getBoolean("isOobeDevOverlayEnabled")}}}constructor(){super();this.qrCodeCanvas=null}get EXTERNAL_API(){return["setQRCode","setPin","showInitialUiStep","showBluetoothDialog","showConnectingToPhoneStep","showConnectingToWifi","showConfirmGoogleAccount","showSigningInStep","showCreatingAccountStep","showSetupCompleteStep","setUserEmail","setUserFullName","setUserAvatarUrl","setWillRequestWiFi"]}getVerificationSubtitle(_title){if(this.willRequestWiFi){return this.i18nAdvanced("quickStartSetupSubtitle",{substitutions:[loadTimeData.getString("deviceType")]})}else{return this.i18nAdvanced("quickStartSetupSubtitleAccountOnly",{substitutions:[loadTimeData.getString("deviceType")]})}}getSetupCompleteTitle(locale){return this.i18nAdvancedDynamic(locale,"quickStartSetupCompleteTitle",{substitutions:[loadTimeData.getString("deviceType")]})}getSetupCompleteSubtitle(locale,_email,_didTransferWiFi){if(this.didTransferWiFi){return this.i18nAdvancedDynamic(locale,"quickStartSetupCompleteSubtitleBoth",{substitutions:[this.userEmail]})}else{return this.i18nAdvancedDynamic(locale,"quickStartSetupCompleteSubtitleSignedIn",{substitutions:[this.userEmail]})}}getCanvas(){const canvas=this.shadowRoot?.querySelector("#qrCodeCanvas");assert(canvas instanceof HTMLCanvasElement);return canvas}getQuickStartBluetoothDialog(){const dialog=this.shadowRoot?.querySelector("#quickStartBluetoothDialog");assert(dialog instanceof OobeModalDialog);return dialog}getSpinnerAnimation(){const animation=this.shadowRoot?.querySelector("#spinner");assert(animation instanceof OobeCrLottie);return animation}ready(){super.ready();this.initializeLoginScreen("QuickStartScreen");this.qrCodeCanvas=new QrCodeCanvas(this.getCanvas())}onBeforeHide(){super.onBeforeHide();this.getSpinnerAnimation().playing=false}get UI_STEPS(){return QuickStartUiState}defaultUIStep(){return QuickStartUiState.DEFAULT}showInitialUiStep(){this.setUIStep(this.defaultUIStep())}showConnectingToPhoneStep(){this.getQuickStartBluetoothDialog().hideDialog();this.setUIStep(QuickStartUiState.CONNECTING_TO_PHONE)}showConnectingToWifi(){this.setUIStep(QuickStartUiState.CONNECTING_TO_WIFI)}setQRCode(qrCodeData,qrCodeURL){this.getQuickStartBluetoothDialog().hideDialog();this.usePinInsteadOfQrForVerification=false;this.setUIStep(QuickStartUiState.VERIFICATION);flush();this.qrCodeCanvas?.setData(qrCodeData);this.shadowRoot?.querySelector("#qrCodeCanvas")?.setAttribute("qr-code-url",qrCodeURL);this.qrCodeAvailable=true}setPin(pin){this.usePinInsteadOfQrForVerification=true;this.setUIStep(QuickStartUiState.VERIFICATION);assert(pin.length===4);this.pin=pin}showConfirmGoogleAccount(){this.setUIStep(QuickStartUiState.CONFIRM_GOOGLE_ACCOUNT)}showSigningInStep(){this.setUIStep(QuickStartUiState.SIGNING_IN);this.getSpinnerAnimation().playing=true}showCreatingAccountStep(){this.setUIStep(QuickStartUiState.SIGNING_IN);this.canCancelSignin=false}showSetupCompleteStep(didTransferWiFi){this.didTransferWiFi=didTransferWiFi;this.setUIStep(QuickStartUiState.SETUP_COMPLETE)}setUserEmail(email){this.userEmail=email}setUserFullName(userFullName){this.userFullName=userFullName}setUserAvatarUrl(userAvatarUrl){this.userAvatarUrl=userAvatarUrl}setWillRequestWiFi(willRequestWiFi){this.willRequestWiFi=willRequestWiFi}showBluetoothDialog(){this.setUIStep(QuickStartUiState.VERIFICATION);this.getQuickStartBluetoothDialog().showDialog()}cancelBluetoothDialog(){this.getQuickStartBluetoothDialog().hideDialog();this.userActed(UserActions.CANCEL)}turnOnBluetooth(){this.getQuickStartBluetoothDialog().hideDialog();this.userActed(UserActions.TURN_ON_BLUETOOTH)}getWrappedAvatar(avatarUri){return"data:text/html;charset=utf-8,"+encodeURIComponent(String.raw`
    <html>
      <style>
        body {
          margin: 0;
        }
        #avatar {
          width: 32px;
          height: 32px;
          user-select: none;
          border-radius: 50%;
        }
      </style>
    <body><img id="avatar" src="`+avatarUri+'"></body></html>')}onCancelClicked(){this.userActed(UserActions.CANCEL)}onNextClicked(){this.userActed(UserActions.NEXT)}}customElements.define(QuickStartScreen.is,QuickStartScreen);