// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/ash/common/cr_elements/cr_checkbox/cr_checkbox.js";import"//resources/polymer/v3_0/iron-icon/iron-icon.js";import"../../components/common_styles/oobe_dialog_host_styles.css.js";import"../../components/buttons/oobe_text_button.js";import"../../components/oobe_apps_list.js";import"../../components/dialogs/oobe_adaptive_dialog.js";import{assert}from"//resources/js/assert.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{OobeUiState}from"../../components/display_manager_types.js";import{LoginScreenMixin}from"../../components/mixins/login_screen_mixin.js";import{MultiStepMixin}from"../../components/mixins/multi_step_mixin.js";import{OobeDialogHostMixin}from"../../components/mixins/oobe_dialog_host_mixin.js";import{OobeI18nMixin}from"../../components/mixins/oobe_i18n_mixin.js";import{OobeAppsList}from"../../components/oobe_apps_list.js";import{getTemplate}from"./recommend_apps.html.js";var RecommendAppsUiState;(function(RecommendAppsUiState){RecommendAppsUiState["LOADING"]="loading";RecommendAppsUiState["LIST"]="list"})(RecommendAppsUiState||(RecommendAppsUiState={}));const RecommendAppsElementBase=OobeDialogHostMixin(LoginScreenMixin(MultiStepMixin(OobeI18nMixin(PolymerElement))));class RecommendAppsElement extends RecommendAppsElementBase{static get is(){return"recommend-apps-element"}static get template(){return getTemplate()}static get properties(){return{appsSelected:{type:Number,value:0},appList:{type:Array,value:[]}}}constructor(){super();this.initialized=false}get EXTERNAL_API(){return["loadAppList"]}get UI_STEPS(){return RecommendAppsUiState}ready(){super.ready();this.initializeLoginScreen("RecommendAppsScreen")}reset(){this.setUIStep(RecommendAppsUiState.LOADING);this.appsSelected=0;this.appList=[]}get defaultControl(){const appsDialog=this.shadowRoot?.querySelector("#appsDialog");if(appsDialog instanceof HTMLElement){return appsDialog}return null}defaultUIStep(){return RecommendAppsUiState.LOADING}getOobeUIInitialState(){return OobeUiState.ONBOARDING}onBeforeHide(){super.onBeforeHide();this.appList=[]}loadAppList(appList){const recommendAppsContainsAdsStr=this.i18n("recommendAppsContainsAds");const recommendAppsInAppPurchasesStr=this.i18n("recommendAppsInAppPurchases");const recommendAppsWasInstalledStr=this.i18n("recommendAppsWasInstalled");this.appList=appList.map((app=>{const tagList=[app.category];if(app.contains_ads){tagList.push(recommendAppsContainsAdsStr)}if(app.in_app_purchases){tagList.push(recommendAppsInAppPurchasesStr)}if(app.was_installed){tagList.push(recommendAppsWasInstalledStr)}if(app.content_rating){tagList.push(app.content_rating)}return{title:app.title,icon_url:app.icon_url,tags:tagList,description:app.description,package_name:app.package_name,checked:false}}))}onFullyLoaded(){this.setUIStep(RecommendAppsUiState.LIST);const appsList=this.shadowRoot?.querySelector("#appsList");if(appsList instanceof HTMLElement){appsList.focus()}}onSkip(){this.userActed("recommendAppsSkip")}onInstall(){assert(this.appsSelected>0);const appsList=this.shadowRoot?.querySelector("#appsList");if(appsList instanceof OobeAppsList){const packageNames=appsList.getSelectedApps();this.userActed(["recommendAppsInstall",packageNames])}}canProceed(appsSelected){return appsSelected>0}}customElements.define(RecommendAppsElement.is,RecommendAppsElement);