import{html}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";export function getTemplate(){return html`<!--_html_template_start_--><!--
Copyright 2015 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->

<!--
  SAML password confirmation UI for the Gaia flow.
  Contains two cards:
    1. Password input form.
    2. Spinner with notice "Please wait";
-->
<style include="oobe-dialog-host-styles cros-color-overrides"></style>
<style include="cr-shared-style">
  #cancelConfirmDlg {
    --oobe-modal-dialog-content-slot-padding-bottom: 0;
    --oobe-modal-dialog-title-slot-padding-bottom: 0;
    --oobe-modal-dialog-width: 384px;
  }
  #title {
    overflow-wrap: break-word;
  }
  .cancel-button {
    margin-inline-end: 0;
    margin-inline-start: 8px;
  }

  :host-context(.jelly-enabled)
    cr-input#passwordInput,
    cr-input#confirmPasswordInput {
      --cr-input-background-color: var(--cros-sys-input_field_on_shaded);
  }
</style>
<oobe-adaptive-dialog role="dialog" for-step="password">
  <iron-icon slot="icon" icon="oobe-32:lock"></iron-icon>
  <h1 id="title" slot="title">[[email]]</h1>
  <p id="subtitle" slot="subtitle">
    [[subtitleText(locale, isManualInput)]]
  </p>
  <div slot="content" class="landscape-vertical-centered">
    <cr-input type="password" id="passwordInput" required
        class="focus-on-show"
        placeholder="[[passwordPlaceholder(locale, isManualInput)]]"
        error-message="[[passwordErrorText(locale, isManualInput)]]">
    </cr-input>
    <cr-input type="password" id="confirmPasswordInput" required
        hidden="[[!isManualInput]]"
        placeholder="[[i18nDynamic(locale, 'confirmPasswordLabel')]]"
        error-message="[[i18nDynamic(locale, 'manualPasswordMismatch')]]">
    </cr-input>
  </div>
  <div slot="bottom-buttons">
    <oobe-text-button id="cancel" on-click="onCancel" text-key="cancel"
        border>
    </oobe-text-button>
    <oobe-next-button id="next" on-click="submit" inverse>
    </oobe-next-button>
  </div>
</oobe-adaptive-dialog>
<oobe-loading-dialog id="progress" role="dialog" for-step="progress"
    title-key="gaiaLoading">
  <iron-icon slot="icon" icon="oobe-32:googleg"></iron-icon>
</oobe-loading-dialog>
<oobe-modal-dialog id="cancelConfirmDlg">
  <div slot="title">
    [[i18nDynamic(locale, 'accountSetupCancelDialogTitle')]]
  </div>
  <div slot="buttons">
    <cr-button class="action-button" on-click="onCancelNo">
      [[i18nDynamic(locale, 'accountSetupCancelDialogNo')]]
    </cr-button>
    <cr-button class="cancel-button focus-on-show" on-click="onCancelYes">
      [[i18nDynamic(locale, 'accountSetupCancelDialogYes')]]
    </cr-button>
  </div>
</oobe-modal-dialog>
<!--_html_template_end_-->`}