import{html}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";export function getTemplate(){return html`<!--_html_template_start_--><!--
Copyright 2022 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->

<style include="oobe-dialog-host-styles">.overview-list-item{border-bottom:1px solid var(--cros-sys-separator);padding:16px}.overview-list-item-title{color:var(--oobe-header-text-color);font-size:var(--oobe-hid-item-title-font-size);font-weight:var(--oobe-hid-item-title-font-weight);line-height:var(--oobe-hid-item-title-line-height);margin-bottom:4px}.overview-list-item-icon{--iron-icon-fill-color:var(--google-blue-600);padding-inline-end:16px}:host-context(.jelly-enabled) .overview-list-item-icon{--iron-icon-fill-color:var(--cros-sys-primary)}.overview-list-item-description{padding-inline-end:16px}.content-footer{padding-top:16px}</style>
  <oobe-adaptive-dialog role="dialog"
      aria-label$="[[i18nDynamic(locale,
          'smartPrivacyProtectionScreenTitle')]]">
    <iron-icon slot="icon" icon="cr:security"></iron-icon>
    <h1 slot="title">
      [[i18nDynamic(locale, 'smartPrivacyProtectionScreenTitle')]]
    </h1>
    <iron-icon slot="subtitle-illustration" class="illustration-jelly"
        icon="oobe-illos:kids-turn-illo" >
    </iron-icon>
    <div slot="content" class="landscape-header-aligned">
      <div id="quickDimSection" class="overview-list-item layout horizontal"
          hidden="[[!isQuickDimEnabled]]">
        <iron-icon class="overview-list-item-icon" icon="oobe-24:lock">
        </iron-icon>
        <div class="flex layout vertical center-justified">
          <div role="heading" aria-level="2"
              class="overview-list-item-title">
            [[i18nDynamic(locale, 'smartPrivacyProtectionScreenLock')]]
          </div>
          <div class="overview-list-item-description">
            [[i18nDynamic(locale, 'smartPrivacyProtectionScreenLockDesc')]]
          </div>
        </div>
      </div>
      <div class="content-footer">
        [[i18nDynamic(locale, 'smartPrivacyProtectionContent')]]
      </div>
    </div>
    <div slot="bottom-buttons">
      <oobe-text-button id="noThanksButton"
          on-click="onNoThanksButtonClicked"
          label-for-aria="[[i18nDynamic(locale,
              'smartPrivacyProtectionTurnOffButton')]]">
        <div slot="text">
          [[i18nDynamic(locale, 'smartPrivacyProtectionTurnOffButton')]]
        </div>
      </oobe-text-button>
      <oobe-text-button id="turnOnButton" inverse="[[!isMinorMode]]"
          class="focus-on-show" on-click="onTurnOnButtonClicked"
          label-for-aria="[[i18nDynamic(locale,
              'smartPrivacyProtectionTurnOnButton')]]">
        <div slot="text">
          [[i18nDynamic(locale, 'smartPrivacyProtectionTurnOnButton')]]
        </div>
      </oobe-text-button>
    </div>
  </oobe-adaptive-dialog>
<!--_html_template_end_-->`}