// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/ash/common/cr_elements/cros_color_overrides.css.js";import"//resources/polymer/v3_0/iron-icon/iron-icon.js";import"//resources/polymer/v3_0/paper-tooltip/paper-tooltip.js";import"../../components/buttons/oobe_text_button.js";import"../../components/dialogs/oobe_adaptive_dialog.js";import"../../components/hd_iron_icon.js";import"../../components/common_styles/oobe_common_styles.css.js";import"../../components/common_styles/oobe_dialog_host_styles.css.js";import"../../components/dialogs/oobe_loading_dialog.js";import{CrCheckboxElement}from"//resources/ash/common/cr_elements/cr_checkbox/cr_checkbox.js";import{assert,assertNotReached}from"//resources/js/assert.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{OobeUiState}from"../../components/display_manager_types.js";import{LoginScreenMixin}from"../../components/mixins/login_screen_mixin.js";import{MultiStepMixin}from"../../components/mixins/multi_step_mixin.js";import{OobeI18nMixin}from"../../components/mixins/oobe_i18n_mixin.js";import{getTemplate}from"./sync_consent.html.js";var SyncUiSteps;(function(SyncUiSteps){SyncUiSteps["ASH_SYNC"]="ash-sync";SyncUiSteps["LOADING"]="loading"})(SyncUiSteps||(SyncUiSteps={}));var UserAction;(function(UserAction){UserAction["CONTINUE"]="continue";UserAction["SYNC_EVERYTHING"]="sync-everything";UserAction["SYNC_CUSTOM"]="sync-custom"})(UserAction||(UserAction={}));const SyncConsentScreenElementBase=LoginScreenMixin(MultiStepMixin(OobeI18nMixin(PolymerElement)));export class SyncConsentScreen extends SyncConsentScreenElementBase{static get is(){return"sync-consent-element"}static get template(){return getTemplate()}static get properties(){return{osSyncItemsStatus:{type:Object,notify:true},isMinorMode:Boolean,optInButtonTextKey:{type:String,computed:"getOptInButtonTextKey(isMinorMode)"},consentDescription:{type:Array},consentConfirmation:{type:String}}}constructor(){super();this.isMinorMode=false;this.osSyncItemsStatus={osApps:true,osPreferences:true,osWifiConfigurations:true,osWallpaper:true}}get EXTERNAL_API(){return["showLoadedStep","setIsMinorMode"]}get UI_STEPS(){return SyncUiSteps}getOobeUIInitialState(){return OobeUiState.ONBOARDING}defaultUIStep(){return SyncUiSteps.LOADING}ready(){super.ready();this.initializeLoginScreen("SyncConsentScreen");this.i18nUpdateLocale()}onSettingsSyncedChanged(){this.set("osSyncItemsStatus.osWallpaper",this.osSyncItemsStatus.osPreferences)}updateLocalizedContent(){this.i18nUpdateLocale()}showLoadedStep(){this.setUIStep(SyncUiSteps.ASH_SYNC)}setIsMinorMode(isMinorMode){this.isMinorMode=isMinorMode}onSettingsSaveAndContinue(e,optedIn){assert(e.composedPath());let checkedBox=false;const reviewSettingsBox=this.shadowRoot?.querySelector("#reviewSettingsBox");if(reviewSettingsBox instanceof CrCheckboxElement){checkedBox=reviewSettingsBox.checked}this.userActed([UserAction.CONTINUE,optedIn,checkedBox,this.getConsentDescription(),this.getConsentConfirmation(e.composedPath())])}onAccepted(e){this.onSettingsSaveAndContinue(e,true)}onDeclined(e){this.onSettingsSaveAndContinue(e,false)}getConsentConfirmation(path){for(const element of path){if(!element.hasAttribute){continue}if(element.hasAttribute("consent-confirmation")){return element.innerHTML.trim()}const labels=element.querySelectorAll("[consent-confirmation]");if(labels&&labels.length>0){assert(labels.length===1);let result="";for(const label of labels){result+=label.innerHTML.trim()}return result}}assertNotReached("No consent confirmation element found.")}getConsentDescription(){const consentDescriptionElements=this.shadowRoot?.querySelectorAll("[consent-description]");assert(consentDescriptionElements);const consentDescription=Array.from(consentDescriptionElements).filter((element=>element.clientWidth*element.clientHeight>0)).map((element=>element.innerHTML.trim()));assert(consentDescription);return consentDescription}getReviewSettingText(locale){return this.i18nDynamic(locale,"syncConsentReviewSyncOptionsText")}getOptInButtonTextKey(isMinorMode){return isMinorMode?"syncConsentTurnOnSync":"syncConsentAcceptAndContinue"}}customElements.define(SyncConsentScreen.is,SyncConsentScreen);