// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"../../components/notification_card.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{GaiaButton}from"../../components/gaia_button.js";import{LoginScreenMixin}from"../../components/mixins/login_screen_mixin.js";import{MultiStepMixin}from"../../components/mixins/multi_step_mixin.js";import{OobeI18nMixin}from"../../components/mixins/oobe_i18n_mixin.js";import{getTemplate}from"./user_allowlist_check_screen.html.js";const HELP_CANT_ACCESS_ACCOUNT=188036;var DialogMode;(function(DialogMode){DialogMode["DEFAULT"]="default"})(DialogMode||(DialogMode={}));const UserAllowlistCheckScreenElementBase=LoginScreenMixin(MultiStepMixin(OobeI18nMixin(PolymerElement)));export class UserAllowlistCheckScreenElement extends UserAllowlistCheckScreenElementBase{static get is(){return"user-allowlist-check-screen-element"}static get template(){return getTemplate()}static get properties(){return{allowlistError:{type:String,value:"allowlistErrorConsumer"}}}defaultUIStep(){return DialogMode.DEFAULT}get UI_STEPS(){return DialogMode}ready(){super.ready();this.initializeLoginScreen("UserAllowlistCheckScreen")}onBeforeShow(optData){super.onBeforeShow(optData);const isManaged=optData&&optData.enterpriseManaged;const isFamilyLinkAllowed=optData&&optData.familyLinkAllowed;if(isManaged&&isFamilyLinkAllowed){this.allowlistError="allowlistErrorEnterpriseAndFamilyLink"}else if(isManaged){this.allowlistError="allowlistErrorEnterprise"}else{this.allowlistError="allowlistErrorConsumer"}const submitButton=this.shadowRoot?.querySelector("#submitButton");if(submitButton instanceof GaiaButton){submitButton.focus()}}onAllowlistErrorTryAgainClick(){this.userActed("retry")}onAllowlistErrorLinkClick_(){chrome.send("launchHelpApp",[HELP_CANT_ACCESS_ACCOUNT])}}customElements.define(UserAllowlistCheckScreenElement.is,UserAllowlistCheckScreenElement);