import{html}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";export function getTemplate(){return html`<!--_html_template_start_--><!--
Copyright 2023 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->

<style include="oobe-dialog-host-styles">#description-body{margin:8px 0 8px 0}div.warning{padding-bottom:19px;padding-top:21px}.warning-message{margin-inline-start:20px}paper-progress{--paper-progress-active-color:var(--cros-color-prominent);--paper-progress-secondary-color:var(--cros-color-prominent-dark);margin-bottom:20px;margin-top:20px}:host-context(.jelly-enabled) paper-progress{--paper-progress-active-color:var(--cros-sys-primary);--paper-progress-container-color:var(--cros-sys-primary_container);--paper-progress-secondary-color:var(--cros-color-prominent-dark)}</style>

<oobe-loading-dialog id="loading-dialog" for-step="loading" role="dialog"
    title-key="loadingDialogTitle">
  <iron-icon slot="icon"
             icon="oobe-32:arc-vm-data-migration-icon"
             aria-hidden="true">
  </iron-icon>
</oobe-loading-dialog>

<oobe-adaptive-dialog id="welcome-dialog" for-step="welcome" role="dialog">
  <iron-icon slot="icon"
             icon="oobe-32:arc-vm-data-migration-icon"
             aria-hidden="true">
  </iron-icon>
  <h1 slot="title">[[i18nDynamic(locale, 'welcomeScreenTitle')]]</h1>
  <div slot="content" class="landscape-header-aligned">
    <div id="description-header">
      <b>[[i18nDynamic(locale, 'welcomeScreenDescriptionHeader')]]</b>
    </div>
    <div id="description-body">
      <p>[[i18nDynamic(locale, 'welcomeScreenUpdateDescription')]]</p>
      <p>
        [[i18nDynamic(locale, 'welcomeScreenBlockingBehaviorDescription')]]
        [[i18nDynamic(locale, 'connectToChargerMessage')]]
      </p>
    </div>
    <div class="message-container">
      <div class="warning" hidden="[[hasEnoughFreeDiskSpace]]">
        <iron-icon slot="icon" icon="oobe-32:warning"></iron-icon>
        <span class="warning-message">
          [[i18nDynamic(locale, 'notEnoughFreeDiskSpaceMessage',
                        requiredFreeDiskSpaceInString)]]
        </span>
      </div>
      <div class="warning" hidden="[[hasEnoughBattery]]">
        <iron-icon icon="oobe-32:warning"></iron-icon>
        <span class="warning-message">
          [[i18nDynamic(locale, 'notEnoughBatteryMessage',
                        minimumBatteryPercent)]]
        </span>
      </div>
    </div>
  </div>
  <div slot="bottom-buttons">
    <oobe-text-button id="skip-button"
        on-click="onSkipButtonClicked"
        text-key="skipButtonLabel">
    </oobe-text-button>
    <oobe-next-button inverse id="update-button"
        disabled="[[shouldDisableUpdateButton(hasEnoughFreeDiskSpace,
                                               hasEnoughBattery)]]"
        on-click="onUpdateButtonClicked"
        text-key="updateButtonLabel">
    </oobe-next-button>
  </div>
</oobe-adaptive-dialog>

<oobe-adaptive-dialog id="resume-dialog" for-step="resume" role="dialog">
  <iron-icon slot="icon"
             icon="oobe-32:arc-vm-data-migration-icon"
             aria-hidden="true">
  </iron-icon>
  <h1 slot="title">[[i18nDynamic(locale, 'resumeScreenTitle')]]</h1>
  <div slot="content" class="landscape-header-aligned">
    <div id="description-header">
      <b>[[i18nDynamic(locale, 'resumeScreenDescriptionHeader')]]</b>
    </div>
    <div id="description-body">
      [[i18nDynamic(locale, 'resumeScreenDescriptionBody')]]
      [[i18nDynamic(locale, 'connectToChargerMessage')]]
    </div>
    <div class="message-container">
      <div class="warning" hidden="[[hasEnoughBattery]]">
        <iron-icon icon="oobe-32:warning"></iron-icon>
        <span class="warning-message">
          [[i18nDynamic(locale, 'notEnoughBatteryMessage',
                        minimumBatteryPercent)]]
        </span>
      </div>
    </div>
  </div>
  <div slot="bottom-buttons">
    <oobe-next-button inverse id="resume-button"
        disabled="[[!hasEnoughBattery]]"
        on-click="onResumeButtonClicked"
        text-key="resumeButtonLabel">
    </oobe-next-button>
  </div>
</oobe-adaptive-dialog>

<oobe-adaptive-dialog id="progress-dialog" for-step="progress" role="dialog">
  <iron-icon slot="icon"
             icon="oobe-32:arc-vm-data-migration-icon"
             aria-hidden="true">
  </iron-icon>
  <h1 slot="title">[[i18nDynamic(locale, 'progressScreenTitle')]]</h1>
  <div slot="subtitle" class="progress">
    <div id="progress-message"
         hidden="[[isProgressIndeterminate(migrationProgress)]]">
      [[i18nDynamic(locale, 'progressScreenSubtitle',
          migrationProgress, estimatedRemainingTimeInString)]]
    </div>
    <paper-progress slot="progress" id="migration-progress"
        value="[[migrationProgress]]"
        max="100"
        step="0.1"
        indeterminate="[[isProgressIndeterminate(migrationProgress)]]">
    </paper-progress>
    <div id="progress-screen-connect-to-charger-message">
      [[i18nDynamic(locale, 'connectToChargerMessage')]]
    </div>
  </div>
  <div slot="content" class="flex layout vertical center center-justified">
    <iron-icon icon="oobe-illos:update-no-waiting-illo"
        class="illustration-jelly">
    </iron-icon>
  </div>
</oobe-adaptive-dialog>

<oobe-adaptive-dialog id="success-dialog" for-step="success" role="dialog">
  <iron-icon slot="icon" icon="oobe-32:checkmark"></iron-icon>
  <h1 slot="title">[[i18nDynamic(locale, 'successScreenTitle')]]</h1>
  <div slot="content" class="flex layout vertical center center-justified">
    <iron-icon icon="oobe-illos:arc-vm-data-migration-success-illo"
        class="illustration-jelly">
    </iron-icon>
  </div>
  <div slot="bottom-buttons">
    <oobe-text-button inverse id="finish-button"
        on-click="onFinishButtonClicked"
        text-key="finishButtonLabel">
    </oobe-text-button>
  </div>
</oobe-adaptive-dialog>

<oobe-adaptive-dialog id="failure-dialog" for-step="failure" role="dialog">
  <iron-icon slot="icon" icon="oobe-32:warning"></iron-icon>
  <h1 slot="title">[[i18nDynamic(locale, 'failureScreenTitle')]]</h1>
  <div slot="subtitle" class="failure">
    <p>[[i18nDynamic(locale, 'failureScreenDescription')]]</p>
    <p>[[i18nDynamic(locale, 'failureScreenAskFeedbackReport')]]</p>
  </div>
  <div slot="content" class="flex layout vertical center center-justified">
    <iron-icon icon="oobe-illos:error-illo" class="illustration-jelly">
    </iron-icon>
  </div>
  <div slot="bottom-buttons">
    <oobe-text-button id="report-button"
        on-click="onReportButtonClicked"
        text-key="reportButtonLabel">
    </oobe-text-button>
    <oobe-text-button inverse id="finish-button"
        on-click="onFinishButtonClicked"
        text-key="finishButtonLabel">
    </oobe-text-button>
  </div>
</oobe-adaptive-dialog>
<!--_html_template_end_-->`}