// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/polymer/v3_0/iron-icon/iron-icon.js";import"//resources/polymer/v3_0/paper-progress/paper-progress.js";import"../../components/oobe_icons.html.js";import"../../components/common_styles/oobe_common_styles.css.js";import"../../components/common_styles/oobe_dialog_host_styles.css.js";import"../../components/dialogs/oobe_adaptive_dialog.js";import{loadTimeData}from"//resources/js/load_time_data.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{OobeDialogHostMixin}from"../../components/mixins/oobe_dialog_host_mixin.js";import{OobeI18nMixin}from"../../components/mixins/oobe_i18n_mixin.js";import{OobeCrLottie}from"../../components/oobe_cr_lottie.js";import{getTemplate}from"./checking_downloading_update.html.js";const CheckingDownloadingUpdateBase=OobeDialogHostMixin(OobeI18nMixin(PolymerElement));export class CheckingDownloadingUpdate extends CheckingDownloadingUpdateBase{static get is(){return"checking-downloading-update"}static get template(){return getTemplate()}static get properties(){return{checkingForUpdate:{type:Boolean,value:true},progressValue:{type:Number,value:0},estimatedTimeLeft:{type:Number,value:0},hasEstimate:{type:Boolean,value:false},defaultProgressMessage:{type:String},updateCompleted:{type:Boolean,value:false},cancelAllowed:{type:Boolean,value:false},checkingForUpdatesKey:{type:String},downloadingUpdatesKey:{type:String},estimatedTimeLeftMsg:{type:String,computed:"computeEstimatedTimeLeftMsg(estimatedTimeLeft)"},progressMessage:{type:String,computed:"computeProgressMessage(hasEstimate, defaultProgressMessage, "+"estimatedTimeLeftMsg)"}}}static get observers(){return["playAnimation(checkingForUpdate)"]}computeProgressMessage(hasEstimate,defaultProgressMessage,estimatedTimeLeftMsg){if(hasEstimate){return estimatedTimeLeftMsg}return defaultProgressMessage}computeEstimatedTimeLeftMsg(estimatedTimeLeft){const seconds=estimatedTimeLeft;const minutes=Math.ceil(seconds/60);let message="";if(minutes>60){message=loadTimeData.getString("downloadingTimeLeftLong")}else if(minutes>55){message=loadTimeData.getString("downloadingTimeLeftStatusOneHour")}else if(minutes>20){message=loadTimeData.getStringF("downloadingTimeLeftStatusMinutes",Math.ceil(minutes/5)*5)}else if(minutes>1){message=loadTimeData.getStringF("downloadingTimeLeftStatusMinutes",minutes)}else{message=loadTimeData.getString("downloadingTimeLeftSmall")}return loadTimeData.getStringF("downloading",message)}isCheckingOrUpdateCompleted(checkingForUpdate,updateCompleted){return checkingForUpdate||updateCompleted}playAnimation(checkingForUpdate){const animation=this.shadowRoot?.querySelector("#checkingAnimation");if(animation instanceof OobeCrLottie){animation.playing=checkingForUpdate}}}customElements.define(CheckingDownloadingUpdate.is,CheckingDownloadingUpdate);