// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/polymer/v3_0/iron-icon/iron-icon.js";import"//resources/polymer/v3_0/paper-progress/paper-progress.js";import"../../components/oobe_icons.html.js";import"../../components/buttons/oobe_text_button.js";import"../../components/common_styles/oobe_dialog_host_styles.css.js";import"../../components/dialogs/oobe_adaptive_dialog.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{OobeUiState}from"../../components/display_manager_types.js";import{LoginScreenMixin}from"../../components/mixins/login_screen_mixin.js";import{MultiStepMixin}from"../../components/mixins/multi_step_mixin.js";import{OobeI18nMixin}from"../../components/mixins/oobe_i18n_mixin.js";import{EncryptionMigrationPage_UIState,EncryptionMigrationPageCallbackRouter,EncryptionMigrationPageHandlerRemote}from"../../mojom-webui/screens_login.mojom-webui.js";import{OobeScreensFactoryBrowserProxy}from"../../oobe_screens_factory_proxy.js";import{getTemplate}from"./encryption_migration.html.js";var EncryptionMigrationUiState;(function(EncryptionMigrationUiState){EncryptionMigrationUiState["INITIAL"]="initial";EncryptionMigrationUiState["READY"]="ready";EncryptionMigrationUiState["MIGRATING"]="migrating";EncryptionMigrationUiState["MIGRATION_FAILED"]="migration-failed";EncryptionMigrationUiState["NOT_ENOUGH_SPACE"]="not-enough-space"})(EncryptionMigrationUiState||(EncryptionMigrationUiState={}));const EncryptionMigrationBase=LoginScreenMixin(MultiStepMixin(OobeI18nMixin(PolymerElement)));export class EncryptionMigration extends EncryptionMigrationBase{static get is(){return"encryption-migration-element"}static get template(){return getTemplate()}static get properties(){return{progress:{type:Number,value:-1},isResuming:{type:Boolean,value:false},batteryPercent:{type:Number,value:0},necessaryBatteryPercent:{type:Number,value:0},isEnoughBattery:{type:Boolean,value:true},isCharging:{type:Boolean,value:false},isSkipped:{type:Boolean,value:false},availableSpaceInString:{type:String,value:""},necessarySpaceInString:{type:String,value:""}}}constructor(){super();this.callbackRouter=new EncryptionMigrationPageCallbackRouter;this.handler=new EncryptionMigrationPageHandlerRemote;OobeScreensFactoryBrowserProxy.getInstance().screenFactory.establishEncryptionMigrationScreenPipe(this.handler.$.bindNewPipeAndPassReceiver()).then((response=>{this.callbackRouter.$.bindHandle(response.pending.handle)}));this.callbackRouter.setUIState.addListener(this.setUIState.bind(this));this.callbackRouter.setMigrationProgress.addListener(this.setMigrationProgress.bind(this));this.callbackRouter.setIsResuming.addListener(this.setIsResuming.bind(this));this.callbackRouter.setBatteryState.addListener(this.setBatteryState.bind(this));this.callbackRouter.setNecessaryBatteryPercent.addListener(this.setNecessaryBatteryPercent.bind(this));this.callbackRouter.setSpaceInfoInString.addListener(this.setSpaceInfoInString.bind(this))}get UI_STEPS(){return EncryptionMigrationUiState}defaultUIStep(){return EncryptionMigrationUiState.INITIAL}getOobeUIInitialState(){return OobeUiState.MIGRATION}ready(){super.ready();this.initializeLoginScreen("EncryptionMigrationScreen")}setUIState(value){switch(value){case EncryptionMigrationPage_UIState.kInitial:this.setUIStep(EncryptionMigrationUiState.INITIAL);break;case EncryptionMigrationPage_UIState.kReady:this.setUIStep(EncryptionMigrationUiState.READY);break;case EncryptionMigrationPage_UIState.kMigrating:this.setUIStep(EncryptionMigrationUiState.MIGRATING);break;case EncryptionMigrationPage_UIState.kMigratingFailed:this.setUIStep(EncryptionMigrationUiState.MIGRATION_FAILED);break;case EncryptionMigrationPage_UIState.kNotEnoughStorage:this.setUIStep(EncryptionMigrationUiState.NOT_ENOUGH_SPACE);break}}setMigrationProgress(progress){this.progress=progress}setIsResuming(isResuming){this.isResuming=isResuming}setBatteryState(batteryPercent,isEnoughBattery,isCharging){this.batteryPercent=Math.floor(batteryPercent);this.isEnoughBattery=isEnoughBattery;this.isCharging=isCharging}setNecessaryBatteryPercent(necessaryBatteryPercent){this.necessaryBatteryPercent=necessaryBatteryPercent}setSpaceInfoInString(availableSpaceSize,necessarySpaceSize){this.availableSpaceInString=availableSpaceSize;this.necessarySpaceInString=necessarySpaceSize}isProgressIndeterminate(progress){return progress<0}isUpdateDisabled(isEnoughBattery,isSkipped){return!isEnoughBattery||isSkipped}isSkipHidden(){return this.i18n("migrationBoardName").startsWith("kevin")}computeProgressLabel(locale,progress){return this.i18nDynamic(locale,"migrationProgressLabel",Math.floor(progress*100).toString())}computeBatteryWarningLabel(locale,batteryPercent){return this.i18nDynamic(locale,"migrationBatteryWarningLabel",batteryPercent.toString())}computeNecessaryBatteryLevelLabel(locale,necessaryBatteryPercent){return this.i18nDynamic(locale,"migrationNecessaryBatteryLevelLabel",necessaryBatteryPercent.toString())}computeAvailableSpaceLabel(locale,availableSpaceInString){return this.i18nDynamic(locale,"migrationAvailableSpaceLabel",availableSpaceInString)}computeNecessarySpaceLabel(locale,necessarySpaceInString){return this.i18nDynamic(locale,"migrationNecessarySpaceLabel",necessarySpaceInString)}onUpgradeClicked(){this.handler.onStartMigration()}onSkipClicked(){this.isSkipped=true;this.handler.onSkipMigration()}onRestartOnLowStorageClicked(){this.handler.onRequestRestartOnLowStorage()}onRestartOnFailureClicked(){this.handler.onRequestRestartOnFailure()}onReportAnIssueClicked(){this.handler.onOpenFeedbackDialog()}}customElements.define(EncryptionMigration.is,EncryptionMigration);