// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/ash/common/cr_elements/cr_shared_vars.css.js";import"//resources/polymer/v3_0/iron-icon/iron-icon.js";import"//resources/polymer/v3_0/paper-progress/paper-progress.js";import"../../components/buttons/oobe_text_button.js";import"../../components/common_styles/oobe_common_styles.css.js";import"../../components/common_styles/oobe_dialog_host_styles.css.js";import"../../components/dialogs/oobe_adaptive_dialog.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{LoginScreenMixin}from"../../components/mixins/login_screen_mixin.js";import{MultiStepMixin}from"../../components/mixins/multi_step_mixin.js";import{OobeI18nMixin}from"../../components/mixins/oobe_i18n_mixin.js";import{getTemplate}from"./management_transition.html.js";var ManagementTransitionUiState;(function(ManagementTransitionUiState){ManagementTransitionUiState["PROGRESS"]="progress";ManagementTransitionUiState["ERROR"]="error"})(ManagementTransitionUiState||(ManagementTransitionUiState={}));var ArcSupervisionTransition;(function(ArcSupervisionTransition){ArcSupervisionTransition[ArcSupervisionTransition["NO_TRANSITION"]=0]="NO_TRANSITION";ArcSupervisionTransition[ArcSupervisionTransition["CHILD_TO_REGULAR"]=1]="CHILD_TO_REGULAR";ArcSupervisionTransition[ArcSupervisionTransition["REGULAR_TO_CHILD"]=2]="REGULAR_TO_CHILD";ArcSupervisionTransition[ArcSupervisionTransition["UNMANAGED_TO_MANAGED"]=3]="UNMANAGED_TO_MANAGED"})(ArcSupervisionTransition||(ArcSupervisionTransition={}));const ManagementTransitionScreenBase=LoginScreenMixin(MultiStepMixin(OobeI18nMixin(PolymerElement)));class ManagementTransitionScreen extends ManagementTransitionScreenBase{static get is(){return"management-transition-element"}static get template(){return getTemplate()}static get properties(){return{arcTransition:{type:Number,value:ArcSupervisionTransition.NO_TRANSITION},managementEntity:{type:String,value:""}}}constructor(){super()}defaultUIStep(){return ManagementTransitionUiState.PROGRESS}get UI_STEPS(){return ManagementTransitionUiState}get EXTERNAL_API(){return["showStep"]}ready(){super.ready();this.initializeLoginScreen("ManagementTransitionScreen")}onBeforeShow(data){super.onBeforeShow(data);this.setArcTransition(data["arcTransition"]);this.setManagementEntity(data["managementEntity"])}showStep(step){this.setUIStep(step)}setArcTransition(arcTransition){switch(arcTransition){case ArcSupervisionTransition.CHILD_TO_REGULAR:case ArcSupervisionTransition.REGULAR_TO_CHILD:case ArcSupervisionTransition.UNMANAGED_TO_MANAGED:this.arcTransition=arcTransition;break;case ArcSupervisionTransition.NO_TRANSITION:console.error("Screen should not appear for "+"ARC_SUPERIVISION_TRANSITION.NO_TRANSITION");break;default:console.error("Not handled transition type: "+arcTransition)}}setManagementEntity(managementEntity){this.managementEntity=managementEntity}getDialogTitle(locale,arcTransition,managementEntity){switch(arcTransition){case ArcSupervisionTransition.CHILD_TO_REGULAR:return this.i18nDynamic(locale,"removingSupervisionTitle");case ArcSupervisionTransition.REGULAR_TO_CHILD:return this.i18nDynamic(locale,"addingSupervisionTitle");case ArcSupervisionTransition.UNMANAGED_TO_MANAGED:if(managementEntity){return this.i18nDynamic(locale,"addingManagementTitle",managementEntity)}else{return this.i18nDynamic(locale,"addingManagementTitleUnknownAdmin")}}return""}isChildTransition(arcTransition){return arcTransition!==ArcSupervisionTransition.UNMANAGED_TO_MANAGED}onAcceptAndContinue(){this.userActed(["finish-management-transition"])}}customElements.define(ManagementTransitionScreen.is,ManagementTransitionScreen);