// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/polymer/v3_0/iron-icon/iron-icon.js";import"../../components/oobe_icons.html.js";import"../../components/common_styles/oobe_common_styles.css.js";import"../../components/common_styles/oobe_dialog_host_styles.css.js";import"../../components/dialogs/oobe_adaptive_dialog.js";import{loadTimeData}from"//resources/js/load_time_data.js";import{sanitizeInnerHtml}from"//resources/js/parse_html_subset.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{OobeModalDialog}from"../../components/dialogs/oobe_modal_dialog.js";import{OobeUiState}from"../../components/display_manager_types.js";import{LoginScreenMixin}from"../../components/mixins/login_screen_mixin.js";import{MultiStepMixin}from"../../components/mixins/multi_step_mixin.js";import{OobeI18nMixin}from"../../components/mixins/oobe_i18n_mixin.js";import{CheckingDownloadingUpdate}from"./checking_downloading_update.js";import{getTemplate}from"./update_required_card.html.js";var UpdateRequiredUiState;(function(UpdateRequiredUiState){UpdateRequiredUiState["UPDATE_REQUIRED_MESSAGE"]="update-required-message";UpdateRequiredUiState["UPDATE_PROCESS"]="update-process";UpdateRequiredUiState["UPDATE_NEED_PERMISSION"]="update-need-permission";UpdateRequiredUiState["UPDATE_COMPLETED_NEED_REBOOT"]="update-completed-need-reboot";UpdateRequiredUiState["UPDATE_ERROR"]="update-error";UpdateRequiredUiState["EOL_REACHED"]="eol";UpdateRequiredUiState["UPDATE_NO_NETWORK"]="update-no-network"})(UpdateRequiredUiState||(UpdateRequiredUiState={}));const UpdateRequiredBase=LoginScreenMixin(MultiStepMixin(OobeI18nMixin(PolymerElement)));export class UpdateRequired extends UpdateRequiredBase{static get is(){return"update-required-card-element"}static get template(){return getTemplate()}static get properties(){return{isNetworkConnected:{type:Boolean,value:false},updateProgressUnavailable:{type:Boolean,value:true},updateProgressValue:{type:Number,value:0},updateProgressMessage:{type:String,value:""},estimatedTimeLeftVisible:{type:Boolean,value:false},enterpriseManager:{type:String,value:""},deviceName:{type:String,value:""},eolAdminMessage:{type:String,value:""},usersDataPresent:{type:Boolean,value:false},estimatedTimeLeft:{type:Number,value:0}}}get EXTERNAL_API(){return["setIsConnected","setUpdateProgressUnavailable","setUpdateProgressValue","setUpdateProgressMessage","setEstimatedTimeLeftVisible","setEstimatedTimeLeft","setUIState","setEnterpriseAndDeviceName","setEolMessage","setIsUserDataPresent"]}ready(){super.ready();this.initializeLoginScreen("UpdateRequiredScreen");this.updateEolDeleteUsersDataMessage()}getOobeUIInitialState(){return OobeUiState.BLOCKING}defaultUIStep(){return UpdateRequiredUiState.UPDATE_REQUIRED_MESSAGE}get UI_STEPS(){return UpdateRequiredUiState}onBeforeShow(){super.onBeforeShow();const elem=this.shadowRoot?.querySelector("#downloadingUpdate");if(elem instanceof CheckingDownloadingUpdate){elem.onBeforeShow()}}updateLocalizedContent(){this.i18nUpdateLocale();this.updateEolDeleteUsersDataMessage()}setEnterpriseAndDeviceName(enterpriseManager,device){this.enterpriseManager=enterpriseManager;this.deviceName=device}setEolMessage(eolMessage){this.eolAdminMessage=sanitizeInnerHtml(eolMessage).toString()}setIsConnected(connected){this.isNetworkConnected=connected}setUpdateProgressUnavailable(unavailable){this.updateProgressUnavailable=unavailable}setUpdateProgressValue(progress){this.updateProgressValue=progress}setUpdateProgressMessage(message){this.updateProgressMessage=message}setEstimatedTimeLeftVisible(visible){this.estimatedTimeLeftVisible=visible}setEstimatedTimeLeft(seconds){this.estimatedTimeLeft=seconds}setUIState(uiState){this.setUIStep(Object.values(UpdateRequiredUiState)[uiState])}setIsUserDataPresent(dataPresent){this.usersDataPresent=dataPresent}onSelectNetworkClicked(){this.userActed("select-network")}onUpdateClicked(){this.userActed("update")}onFinishClicked(){this.userActed("finish")}onCellularPermissionRejected(){this.userActed("update-reject-cellular")}onCellularPermissionAccepted(){this.userActed("update-accept-cellular")}eq(one,another){return one===another}isEmpty(eolAdminMessage){return!eolAdminMessage||eolAdminMessage.trim().length===0}updateEolDeleteUsersDataMessage(){const message=this.shadowRoot?.querySelector("#deleteUsersDataMessage");if(message instanceof HTMLElement){message.innerHTML=this.i18nAdvanced("eolDeleteUsersDataMessage",{substitutions:[loadTimeData.getString("deviceType")],attrs:["id"]})}const linkElement=this.shadowRoot?.querySelector("#deleteDataLink");if(linkElement instanceof HTMLAnchorElement){linkElement.setAttribute("is","action-link");linkElement.setAttribute("aria-describedby","deleteUsersDataMessage");linkElement.classList.add("oobe-local-link");linkElement.addEventListener("click",(()=>this.showConfirmationDialog()))}}showConfirmationDialog(){const dialog=this.shadowRoot?.querySelector("#confirmationDialog");if(dialog instanceof OobeModalDialog){dialog.showDialog()}}hideConfirmationDialog(){const dialog=this.shadowRoot?.querySelector("#confirmationDialog");if(dialog instanceof OobeModalDialog){dialog.hideDialog()}}onDeleteUsersConfirmed(){this.userActed("confirm-delete-users");this.hideConfirmationDialog()}}customElements.define(UpdateRequired.is,UpdateRequired);