import{html}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";export function getTemplate(){return html`<!--_html_template_start_--><!--
Copyright 2023 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->

<style include="oobe-dialog-host-styles">.progress-message{color:var(--oobe-subheader-text-color);margin-top:32px}.update-illustration{height:264px;width:264px}.slide-view{border:1px solid var(--google-grey-200);border-radius:16px;height:380px;margin:auto;overflow:hidden;width:380px}:host-context(.jelly-enabled) .slide-view{border:none;border-radius:20px;height:360px}#checkingAnimation{height:300px;width:334px}:host-context(.jelly-enabled) paper-progress{--paper-progress-active-color:var(--cros-sys-primary);--paper-progress-container-color:var(--cros-sys-primary_container)}div[slot="subtitle"] p{margin-top:0}</style>
<oobe-adaptive-dialog id="consumerUpdateCellularDialog"
    for-step="cellular" tabindex="0"
    aria-live="polite" footer-shrinkable>
  <iron-icon slot="icon" icon="oobe-32:googleg"></iron-icon>
  <h1 slot="title">
    [[i18nDynamic(locale, 'consumerUpdateScreenCellularTitle')]]
  </h1>
  <p slot="subtitle">
    [[i18nDynamic(locale, 'updateOverCellularPromptMessage')]]
  </p>
  <div slot="content" class="flex layout vertical center-justified center">
    <iron-icon icon="oobe-illos:updating-illo"
        class="update-illustration  illustration-jelly">
    </iron-icon>
  </div>
  <div slot="back-navigation">
    <oobe-back-button id="updateCellularBackButton" on-click="onBackClicked">
    </oobe-back-button>
  </div>
  <div slot="bottom-buttons">
    <oobe-text-button id="declineButton"
        text-key="consumerUpdateScreenSkipButton"
        on-click="onDeclineCellularClicked"
        border>
    </oobe-text-button>
    <oobe-text-button id="acceptButton" inverse
        text-key="consumerUpdateScreenAcceptButton"
        on-click="onAcceptCellularClicked"
        border>
    </oobe-text-button>
  </div>
</oobe-adaptive-dialog>
<oobe-adaptive-dialog footer-shrinkable id="consumerUpdateCheckingDialog"
    for-step="checking" aria-live="polite">
  <iron-icon slot="icon" icon="oobe-32:googleg"></iron-icon>
  <h1 slot="title">
    [[i18nDynamic(locale, 'checkingForUpdates')]]
  </h1>
  <paper-progress slot="progress" id="checking-progress" aria-hidden="true"
    indeterminate>
  </paper-progress>
  <div slot="content" class="flex layout vertical center-justified center">
    <oobe-cr-lottie id="checkingAnimation"
        animation-url="animations/checking_for_update.json">
    </oobe-cr-lottie>
  </div>
</oobe-adaptive-dialog>
<oobe-adaptive-dialog footer-shrinkable id="consumerUpdateInProgressDialog"
    for-step="update" aria-live="polite">
  <iron-icon slot="icon" icon="oobe-32:update-progress"></iron-icon>
  <h1 slot="title">
    [[i18nDynamic(locale, 'consumerUpdateScreenInProgressTitle')]]
  </h1>
  <div slot="subtitle">
    <p>[[i18nDynamic(locale, 'consumerUpdateScreenInProgressSubtitle')]]</p>
    <p>[[i18nDynamic(locale,
                    'consumerUpdateScreenInProgressAdditionalSubtitle')]]</p>
    <span id="betterUpdatePercent">[[updateStatusMessagePercent]]</span>
    <span> | </span>
    <span id="betterUpdateTimeleft">
      [[updateStatusMessageTimeLeft]]
    </span>
    <paper-progress id="update-progress" value="[[betterUpdateProgressValue]]">
    </paper-progress>
  </div>
  <div hidden="[[!showLowBatteryWarning]]" id="battery-warning"
      class="slide-view" slot="content">
    <oobe-slide is-warning>
      <iron-icon slot="slide-img"  icon="oobe-illos:update-charge-illo"
          class="illustration-jelly">
      </iron-icon>
      <div slot="title">
        [[i18nDynamic(locale, 'batteryWarningTitle')]]
      </div>
      <div slot="text">
        [[i18nDynamic(locale, 'batteryWarningText')]]
      </div>
    </oobe-slide>
  </div>
  <div hidden="[[showLowBatteryWarning]]" id="carousel" class="slide-view"
      slot="content">
    <oobe-carousel
        auto-transition="[[getAutoTransition(uiStep, autoTransition)]]"
        slide-label="slideLabel"
        selected-button-label="slideSelectedButtonLabel"
        unselected-button-label="slideUnselectedButtonLabel">
      <oobe-slide slot="slides">
        <iron-icon slot="slide-img" icon="oobe-illos:update-no-waiting-illo"
            class="illustration-jelly">
        </iron-icon>
        <div slot="title">
          [[i18nDynamic(locale, 'slideUpdateAdditionalSettingsTitle')]]
        </div>
        <div slot="text">
          [[i18nDynamic(locale, 'slideUpdateAdditionalSettingsText')]]
        </div>
      </oobe-slide>
      <oobe-slide slot="slides">
        <iron-icon slot="slide-img" icon="oobe-illos:update-antivirus-illo"
            class="illustration-jelly">
        </iron-icon>
        <div slot="title">
          [[i18nDynamic(locale, 'slideAntivirusTitle')]]
        </div>
        <div slot="text">
          [[i18nDynamic(locale, 'slideAntivirusText')]]
        </div>
      </oobe-slide>
      <oobe-slide slot="slides">
        <iron-icon slot="slide-img" icon="oobe-illos:update-apps-illo"
            class="illustration-jelly">
        </iron-icon>
        <div slot="title">[[i18nDynamic(locale, 'slideAppsTitle')]]</div>
        <div slot="text">[[i18nDynamic(locale, 'slideAppsText')]]</div>
      </oobe-slide>
      <oobe-slide slot="slides">
        <iron-icon slot="slide-img" icon="oobe-illos:google-account-illo"
            class="illustration-jelly">
        </iron-icon>
        <div slot="title">
          [[i18nDynamic(locale, 'slideAccountTitle')]]
        </div>
        <div slot="text">
          [[i18nDynamic(locale, 'slideAccountText')]]
        </div>
      </oobe-slide>
    </oobe-carousel>
  </div>
  <div slot="bottom-buttons">
    <oobe-text-button id="skipButton" hidden="[[isSkipButtonHidden]]"
        text-key="consumerUpdateScreenSkipButton" on-click="onSkip" border>
    </oobe-text-button>
</div>
</oobe-adaptive-dialog>
<oobe-loading-dialog id="consumerUpdateRestartingDialog"
    title-key="updateCompeletedRebootingMsg" for-step="restart">
  <iron-icon slot="icon" icon="oobe-32:googleg"></iron-icon>
</oobe-loading-dialog>
<oobe-adaptive-dialog footer-shrinkable id="consumerUpdateCompleteDialog"
    for-step="reboot" aria-live="polite">
  <iron-icon slot="icon" icon="oobe-32:googleg"></iron-icon>
  <h1 slot="title">
    [[i18nDynamic(locale, 'updateCompeletedMsg')]]
  </h1>
</oobe-adaptive-dialog>
<!--_html_template_end_-->`}