// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/polymer/v3_0/iron-icon/iron-icon.js";import"//resources/polymer/v3_0/paper-progress/paper-progress.js";import"../../components/oobe_icons.html.js";import"../../components/buttons/oobe_back_button.js";import"../../components/buttons/oobe_next_button.js";import"../../components/common_styles/oobe_dialog_host_styles.css.js";import"../../components/dialogs/oobe_adaptive_dialog.js";import"../../components/dialogs/oobe_loading_dialog.js";import"../../components/oobe_carousel.js";import"../../components/oobe_slide.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{OobeUiState}from"../../components/display_manager_types.js";import{LoginScreenMixin}from"../../components/mixins/login_screen_mixin.js";import{MultiStepMixin}from"../../components/mixins/multi_step_mixin.js";import{OobeI18nMixin}from"../../components/mixins/oobe_i18n_mixin.js";import{OobeCrLottie}from"../../components/oobe_cr_lottie.js";import{ConsumerUpdatePage_ConsumerUpdateStep,ConsumerUpdatePageCallbackRouter,ConsumerUpdatePageHandlerRemote}from"../../mojom-webui/screens_oobe.mojom-webui.js";import{OobeScreensFactoryBrowserProxy}from"../../oobe_screens_factory_proxy.js";import{getTemplate}from"./consumer_update.html.js";const ConsumerUpdateScreenElementBase=LoginScreenMixin(MultiStepMixin(OobeI18nMixin(PolymerElement)));const UNREACHABLE_PERCENT=1e3;const PERCENT_THRESHOLDS=[0,10,20,30,40,50,60,70,80,90,95,98,99,100,UNREACHABLE_PERCENT];var ConsumerUpdateStep;(function(ConsumerUpdateStep){ConsumerUpdateStep["CHECKING"]="checking";ConsumerUpdateStep["UPDATE"]="update";ConsumerUpdateStep["RESTART"]="restart";ConsumerUpdateStep["REBOOT"]="reboot";ConsumerUpdateStep["CELLULAR"]="cellular"})(ConsumerUpdateStep||(ConsumerUpdateStep={}));class ConsumerUpdateScreen extends ConsumerUpdateScreenElementBase{static get is(){return"consumer-update-element"}static get template(){return getTemplate()}static get properties(){return{isSkipButtonHidden:{type:Boolean,value:true},showLowBatteryWarning:{type:Boolean,value:false},updateStatusMessagePercent:{type:String,value:""},updateStatusMessageTimeLeft:{type:String,value:""},betterUpdateProgressValue:{type:Number,value:0},autoTransition:{type:Boolean,value:true},thresholdIndex:{type:Number,value:0}}}static get observers(){return["playAnimation(uiStep)"]}constructor(){super();this.callbackRouter=new ConsumerUpdatePageCallbackRouter;this.handler=new ConsumerUpdatePageHandlerRemote;OobeScreensFactoryBrowserProxy.getInstance().screenFactory.establishConsumerUpdateScreenPipe(this.handler.$.bindNewPipeAndPassReceiver()).then((response=>{this.callbackRouter.$.bindHandle(response.pending.handle)}));this.callbackRouter.showSkipButton.addListener(this.showSkipButton.bind(this));this.callbackRouter.setLowBatteryWarningVisible.addListener(this.setLowBatteryWarningVisible.bind(this));this.callbackRouter.setScreenStep.addListener(this.setScreenStep.bind(this));this.callbackRouter.setUpdateStatusMessage.addListener(this.setUpdateStatusMessage.bind(this));this.callbackRouter.setAutoTransition.addListener(this.setAutoTransition.bind(this))}get UI_STEPS(){return ConsumerUpdateStep}defaultUIStep(){return ConsumerUpdateStep.CHECKING}ready(){super.ready();this.initializeLoginScreen("ConsumerUpdateScreen")}getOobeUIInitialState(){return OobeUiState.ONBOARDING}showSkipButton(){this.isSkipButtonHidden=false}onBeforeHide(){super.onBeforeHide();const animation=this.shadowRoot?.querySelector("#checkingAnimation");if(animation instanceof OobeCrLottie){animation.playing=false}}onDeclineCellularClicked(){this.handler.onDeclineCellularClicked()}onAcceptCellularClicked(){this.handler.onAcceptCellularClicked()}onSkip(){this.handler.onSkipClicked()}setLowBatteryWarningVisible(visible){this.showLowBatteryWarning=visible}setScreenStep(value){switch(value){case ConsumerUpdatePage_ConsumerUpdateStep.kCheckingForUpdate:this.setUIStep(ConsumerUpdateStep.CHECKING);break;case ConsumerUpdatePage_ConsumerUpdateStep.kUpdateInProgress:this.setUIStep(ConsumerUpdateStep.UPDATE);break;case ConsumerUpdatePage_ConsumerUpdateStep.kRestartInProgress:this.setUIStep(ConsumerUpdateStep.RESTART);break;case ConsumerUpdatePage_ConsumerUpdateStep.kManualReboot:this.setUIStep(ConsumerUpdateStep.REBOOT);break;case ConsumerUpdatePage_ConsumerUpdateStep.kCellularPermission:this.setUIStep(ConsumerUpdateStep.CELLULAR);break}}setUpdateStatusMessage(percent,messagePercent,messageTimeLeft){const betterUpdatePercent=this.shadowRoot?.querySelector("#betterUpdatePercent");const betterUpdateTimeleft=this.shadowRoot?.querySelector("#betterUpdateTimeleft");if(percent>=PERCENT_THRESHOLDS[this.thresholdIndex]){while(percent>=PERCENT_THRESHOLDS[this.thresholdIndex]){this.thresholdIndex=this.thresholdIndex+1}if(betterUpdatePercent instanceof HTMLElement&&betterUpdateTimeleft instanceof HTMLElement){betterUpdatePercent.setAttribute("aria-live","polite");betterUpdateTimeleft.setAttribute("aria-live","polite")}}else{if(betterUpdatePercent instanceof HTMLElement&&betterUpdateTimeleft instanceof HTMLElement){betterUpdatePercent.setAttribute("aria-live","off");betterUpdateTimeleft.setAttribute("aria-live","off")}}this.betterUpdateProgressValue=percent;this.updateStatusMessagePercent=messagePercent;this.updateStatusMessageTimeLeft=messageTimeLeft}setAutoTransition(enabled){this.autoTransition=enabled}getAutoTransition(step,autoTransition){return step===ConsumerUpdateStep.UPDATE&&autoTransition}onBackClicked(){this.handler.onBackClicked()}playAnimation(uiStep){const animation=this.shadowRoot?.querySelector("#checkingAnimation");if(animation instanceof OobeCrLottie){animation.playing=uiStep===ConsumerUpdateStep.CHECKING}}}customElements.define(ConsumerUpdateScreen.is,ConsumerUpdateScreen);