// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/ash/common/cr_elements/cros_color_overrides.css.js";import"//resources/polymer/v3_0/iron-icon/iron-icon.js";import"../../components/oobe_icons.html.js";import"../../components/oobe_i18n_dropdown.js";import"../../components/buttons/oobe_back_button.js";import"../../components/buttons/oobe_text_button.js";import"../../components/common_styles/oobe_common_styles.css.js";import"../../components/common_styles/oobe_dialog_host_styles.css.js";import"../../components/dialogs/oobe_adaptive_dialog.js";import{assert}from"//resources/js/assert.js";import{loadTimeData}from"//resources/js/load_time_data.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{LoginScreenMixin}from"../../components/mixins/login_screen_mixin.js";import{OobeDialogHostMixin}from"../../components/mixins/oobe_dialog_host_mixin.js";import{OobeI18nMixin}from"../../components/mixins/oobe_i18n_mixin.js";import{Oobe}from"../../cr_ui.js";import{getTemplate}from"./demo_preferences.html.js";const RETAILER_NAME_INPUT_MAX_LENGTH=256;const STORE_NUMBER_INPUT_MAX_LENGTH=256;const DemoPreferencesScreenBase=OobeDialogHostMixin(LoginScreenMixin(OobeI18nMixin(PolymerElement)));export class DemoPreferencesScreen extends DemoPreferencesScreenBase{static get is(){return"demo-preferences-element"}static get template(){return getTemplate()}static get properties(){return{languages:{type:Array},countries:{type:Array},isCountrySelected:{type:Boolean,value:false},userCanContinue:{type:Boolean,value:false,reflectToAttribute:true,computed:`userCanContinue_(retailerNameInput,\n                                    storeNumberInput,\n                                    isCountrySelected)`},retailerNameInput:{type:String,value:""},storeNumberInput:{type:String,value:""},storeNumberInputInvalid:{type:Boolean,value:false,reflectToAttribute:true,computed:"isStoreNumberInputInvalid_(storeNumberInput)"}}}constructor(){super();this.configurationApplied=false;this.countryNotSelectedId="N/A"}ready(){super.ready();this.initializeLoginScreen("DemoPreferencesScreen");this.updateLocalizedContent()}get defaultControl(){return this.shadowRoot.getElementById("demoPreferencesDialog")}onBeforeShow(){super.onBeforeShow();window.setTimeout(this.applyOobeConfiguration_.bind(this),0)}applyOobeConfiguration_(){if(this.configurationApplied){return}const configuration=Oobe.getInstance().getOobeConfiguration();if(!configuration){return}if(configuration.demoPreferencesNext){this.onNextClicked_()}this.configurationApplied=true}updateLocalizedContent(){assert(loadTimeData);const languageList=loadTimeData.getValue("languageList");this.setLanguageList_(languageList);const countryList=loadTimeData.getValue("demoModeCountryList");this.setCountryList_(countryList);this.i18nUpdateLocale()}setLanguageList_(languages){this.languages=languages}setCountryList_(countries){this.countries=countries;this.shadowRoot.getElementById("countryDropdownContainer").hidden=countries.length===0;for(let i=0;i<countries.length;++i){const country=countries[i];if(country.selected&&country.value!==this.countryNotSelectedId){this.isCountrySelected=true;return}}}userCanContinue_(retailerNameInput,storeNumberInput,isCountrySelected){return!!retailerNameInput&&!!isCountrySelected&&!!storeNumberInput&&isCountrySelected&&storeNumberInput.length<=STORE_NUMBER_INPUT_MAX_LENGTH&&retailerNameInput.length<=RETAILER_NAME_INPUT_MAX_LENGTH&&RegExp("^[0-9]+$").test(storeNumberInput)}isStoreNumberInputInvalid_(storeNumberInput){return!RegExp("^[0-9]*$").test(storeNumberInput)}onCountrySelected_(event){this.userActed(["set-demo-mode-country",event.detail.value]);this.isCountrySelected=event.detail.value!==this.countryNotSelectedId}onInputKeyDown_(e){if(e.key==="Enter"&&this.userCanContinue_(this.retailerNameInput,this.storeNumberInput,this.isCountrySelected)){this.onNextClicked_()}}onBackClicked_(){this.userActed("close-setup")}onNextClicked_(){this.userActed(["continue-setup",this.retailerNameInput,this.storeNumberInput])}}customElements.define(DemoPreferencesScreen.is,DemoPreferencesScreen);