import{html}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";export function getTemplate(){return html`<!--_html_template_start_--><!--
Copyright 2014 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->

<style include="oobe-dialog-host-styles cros-color-overrides">#password-note{color:var(--cros-color-secondary);font-size:var(--oobe-enable-debugging-font-size)}:host-context(.jelly-enabled) cr-input#password,cr-input#passwordRepeat{--cr-input-background-color:var(--cros-sys-input_field_on_shaded)}:host-context(.jelly-enabled) #password-note{color:var(--oobe-subheader-text-color)}</style>
<oobe-adaptive-dialog id="removeProtectionDialog" role="dialog"
    for-step="remove-protection"
    aria-label$="[[i18nDynamic(locale,
                  'enableDebuggingScreenAccessibleTitle')]]">
  <iron-icon slot="icon" icon="oobe-32:alert"></iron-icon>
  <h1 slot="title">
    [[i18nDynamic(locale, 'enableDebuggingScreenTitle')]]
  </h1>
  <div slot="subtitle">
    [[i18nDynamic(locale, 'enableDebuggingRemveRootfsMessage')]]
    <a id="help-link" class="oobe-local-link" is="action-link"
        on-click="onHelpLinkClicked_"
        aria-label="[[i18nDynamic(locale, 'enableDebuggingLearnMore')]]">
      [[i18nDynamic(locale, 'enableDebuggingLearnMore')]]
    </a>
  </div>
  <div slot="bottom-buttons">
    <oobe-text-button id="removeProtectionCancelButton"
        text-key="enableDebuggingCancelButton" on-click="cancel">
    </oobe-text-button>
    <oobe-text-button id="removeProtectionProceedButton" inverse
        text-key="enableDebuggingRemoveButton" class="focus-on-show"
        on-click="onRemoveButtonClicked_">
    </oobe-text-button>
  </div>
</oobe-adaptive-dialog>

<oobe-adaptive-dialog id="setupDialog" for-step="setup" role="dialog"
    aria-label$="[[i18nDynamic(locale,
                'enableDebuggingScreenAccessibleTitle')]]">
  <iron-icon slot="icon" icon="oobe-32:alert"></iron-icon>
  <h1 slot="title">
    [[i18nDynamic(locale, 'enableDebuggingScreenTitle')]]
  </h1>
  <div slot="subtitle">
    [[i18nDynamic(locale, 'enableDebuggingSetupMessage')]]
  </div>
  <div slot="content" class="landscape-vertical-centered">
    <cr-input id="password" type="password" value="{{password_}}"
              placeholder="[[i18nDynamic(locale,
                            'enableDebuggingPasswordLabel')]]"
              class="focus-on-show">
    </cr-input>
    <cr-input id="passwordRepeat" type="password"
        value="{{passwordRepeat_}}"
        placeholder="[[i18nDynamic(locale,
                    'enableDebuggingConfirmPasswordLabel')]]">
    </cr-input>
    <div id="password-note">
      [[i18nDynamic(locale, 'enableDebuggingPasswordLengthNote')]]
    </div>
  </div>
  <div slot="bottom-buttons">
    <oobe-text-button id="setupCancelButton"
        text-key="enableDebuggingCancelButton" on-click="cancel">
    </oobe-text-button>
    <oobe-text-button id="enableButton" inverse
        text-key="enableDebuggingEnableButton"
        on-click="onEnableButtonClicked_"
        for-step="setup" disabled="[[!passwordsMatch_]]">
    </oobe-text-button>
  </div>
</oobe-adaptive-dialog>

<oobe-loading-dialog id="waitDialog" for-step="wait"
    title-key="enableDebuggingScreenTitle"
    aria-label$="[[i18nDynamic(locale,
                'enableDebuggingScreenAccessibleTitle')]]">
  <iron-icon slot="icon" icon="oobe-32:alert"></iron-icon>
</oobe-loading-dialog>

<oobe-adaptive-dialog id="doneDialog" role="dialog" for-step="done"
    aria-label$="[[i18nDynamic(locale,
                'enableDebuggingScreenAccessibleTitle')]]">
  <iron-icon slot="icon" icon="oobe-32:alert"></iron-icon>
  <h1 slot="title">
    [[i18nDynamic(locale, 'enableDebuggingScreenTitle')]]
  </h1>
  <div slot="subtitle" id="done-details">
    [[i18nDynamic(locale, 'enableDebuggingDoneMessage')]]
  </div>
  <div slot="content" class="flex layout vertical center center-justified">
    <img class="success-icon" aria-hidden="true"
        src="chrome://theme/IDR_ENABLE_DEBUGGING_SUCCESS">
  </div>
  <div slot="bottom-buttons">
    <oobe-text-button id="okButton" inverse class="focus-on-show"
        text-key="enableDebuggingOKButton" on-click="onOkButtonClicked_">
    </oobe-text-button>
  </div>
</oobe-adaptive-dialog>

<oobe-adaptive-dialog id="errorDialog" role="dialog" for-step="error"
    aria-label$="[[i18nDynamic(locale,
                'enableDebuggingScreenAccessibleTitle')]]">
  <iron-icon slot="icon" icon="oobe-32:warning"></iron-icon>
  <h1 slot="title">
    [[i18nDynamic(locale, 'enableDebuggingErrorTitle')]]
  </h1>
  <div slot="subtitle" id="error-details">
    [[i18nDynamic(locale, 'enableDebuggingErrorMessage')]]
  </div>
  <div slot="content" class="flex layout vertical center center-justified">
    <iron-icon id="iconArea" icon="oobe-illos:error-illo"
        class="illustration-jelly">
    </iron-icon>
  </div>
  <div slot="bottom-buttons">
    <oobe-text-button id="errorOkButton" inverse class="focus-on-show"
        text-key="enableDebuggingOKButton" on-click="onOkButtonClicked_">
    </oobe-text-button>
  </div>
</oobe-adaptive-dialog>
<!--_html_template_end_-->`}