import{html}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";export function getTemplate(){return html`<!--_html_template_start_--><!--
Copyright 2015 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->

<style include="oobe-dialog-host-styles cros-color-overrides">host{padding:0}#step-signin{flex:auto}#learnMoreLink{display:inline}.step-message{display:inline-block;padding-top:20px;text-align:start;vertical-align:top}#enterpriseExplanation{margin-top:8px}#enterpriseIcon{flex-shrink:0;margin-inline-end:8px}#enterpriseIconText{line-height:24px;vertical-align:middle}:host-context(.jelly-enabled) cr-input#assetId,cr-input#location{--cr-input-background-color:var(--cros-sys-input_field_on_shaded)}</style>
<!-- OAUTH GAIA DIALOG -->
<gaia-dialog id="step-signin" class="flex" for-step="signin"
    gaia-dialog-buttons-type="[[gaiaDialogButtonsType]]"
    auth-flow="{{authFlow}}"
    is-saml-sso-visible="[[isSaml(authFlow)]]"
    webview-name="authView"
    on-authcompleted="onAuthCompleted"
    on-backcancel="cancel"
    on-closesaml="cancel"
    on-identifierentered="onIdentifierEnteredMessage"
    hide-back-button-if-cant-go-back
    on-ready="onReady"
    on-licensetypeselected="onLicenseTypeSelected">
</gaia-dialog>
<oobe-loading-dialog title-key="gaiaLoading"
    id="step-loading" for-step="loading">
  <iron-icon slot="icon" icon="oobe-32:enterprise"></iron-icon>
</oobe-loading-dialog>

<!-- ENROLLMENT IN PROGRESS (SPINNER) DIALOG -->
<oobe-loading-dialog title-key="[[getWorkingTitleKey(licenseType)]]"
    title-label-key="enrollmentInProgress" id="step-working"
    for-step="working">
  <iron-icon slot="icon" icon="[[getIcon(licenseType)]]"></iron-icon>
</oobe-loading-dialog>

<!-- ACCOUNT CHECK IN PROGRESS (SPINNER) DIALOG -->
<oobe-loading-dialog title-key="enrollmentAccountCheckTitle"
    id="step-checking" for-step="checking">
  <iron-icon slot="icon" icon="oobe-32:enterprise"></iron-icon>
</oobe-loading-dialog>

<oobe-loading-dialog id="step-tpm-checking" for-step="tpm-checking"
    title-key="TPMCheckTitle" subtitle-key="TPMCheckSubtitle"
    can-cancel on-cancel-loading="onTpmCheckCanceled">
  <iron-icon slot="icon" icon="oobe-32:enterprise"></iron-icon>
</oobe-loading-dialog>

<!--  ERROR DIALOG -->
<!-- There are two kinds of errors:
        - General
        - AttributePrompt

    They share the same structure but have different bottom buttons.
        General: [ Back, Skip/Manual Enrollment, Try Again ]
        AttributePrompt: [ 'Done' ]
-->
<oobe-adaptive-dialog id="step-error" role="alert"
    for-step="error, attribute-prompt-error">
  <iron-icon slot="icon" icon="oobe-32:warning"></iron-icon>
  <h1 slot="title">[[getErrorTitle(locale, licenseType)]]</h1>
  <div id="errorMsg" slot="subtitle">[[errorText]]</div>
  <div slot="content"
      class="flex layout vertical center center-justified">
    <iron-icon icon="oobe-illos:error-illo" class="illustration-jelly">
    </iron-icon>
  </div>
  <div slot="back-navigation">
    <!-- BACK - Shown when the generic cancel button is hidden -->
    <oobe-back-button id="errorCancelBackButton"
        hidden$="[[isGenericCancel(isAutoEnroll, isForced)]]"
        on-click="cancel"></oobe-back-button>
  </div>
  <div slot="bottom-buttons">
    <!-- BOTTOM BUTTONS: GENERIC ERROR -->
    <div id="genericErrorBottomButtons"
        class="flex layout horizontal end-justified" for-step="error">
      <!-- GENERAL CANCEL BUTTON (SKIP / ENROLL MANUALLY) -->
      <oobe-text-button id="errorGenericCancelButton"
          hidden$="[[!isGenericCancel(isAutoEnroll, isForced)]]"
          on-click="cancel" inverse$="[[!canRetryAfterError]]"
          text-key="[[getCancelButtonLabel(isAutoEnroll)]]">
      </oobe-text-button>

      <!-- TRY AGAIN BUTTON -  -->
      <oobe-text-button inverse id="errorRetryButton"
        hidden$="[[!canRetryAfterError]]"
        on-click="doRetry" class="focus-on-show"
        text-key="oauthEnrollRetry">
      </oobe-text-button>
    </div>

    <!-- BOTTOM BUTTONS: ATTRIBUTE ERROR -->
    <div for-step="attribute-prompt-error">
      <oobe-text-button inverse id="attributeErrorButton"
          on-click="onEnrollmentFinished" class="focus-on-show"
          text-key="oauthEnrollDone">
      </oobe-text-button>
    </div>

  </div>
</oobe-adaptive-dialog>

<!-- KIOSK CONFIRM DIALOG -->
<oobe-adaptive-dialog id="step-kiosk-enrollment" for-step="kiosk-enrollment"
    role="alert" footer-shrinkable>
  <iron-icon slot="icon" icon="oobe-32:kiosk"></iron-icon>
  <h1 slot="title">
    [[i18nDynamic(locale, 'oauthEnrollKioskEnrollmentConfirmTitle')]]
  </h1>
  <div slot="subtitle">
    [[i18nDynamic(locale, 'oauthEnrollKioskEnrollmentConfirmMessage')]]
    [[i18nDynamic(locale,
      'oauthEnrollKioskEnrollmentConfirmPowerwashMessage')]]
  </div>
  <div slot="content" class="flex layout vertical center center-justified">
    <iron-icon icon="oobe-illos:kiosk-enrollment-illo" class="illustration-jelly">
    </iron-icon>
  </div>
  <div slot="bottom-buttons">
    <oobe-text-button id="cancelKioskEnrollmentButton"
        text-key="oauthEnrollKioskCancelEnrollmentButton"
        on-click="onCancelKiosk"></oobe-text-button>
    <oobe-text-button inverse id="enrollKioskButton"
        text-key="oauthEnrollKioskEnrollmentConfirmButton"
        on-click="onEnrollKiosk" class="focus-on-show"></oobe-text-button>
  </div>
</oobe-adaptive-dialog>

<!-- SUCCESS DIALOG -->
<oobe-adaptive-dialog id="step-success" for-step="success" role="alert"
    footer-shrinkable>
  <iron-icon slot="icon" icon="[[getIcon(licenseType)]]"></iron-icon>
  <h1 slot="title">
    [[getSuccessTitle(locale, licenseType)]]
  </h1>
  <!-- Hide the subtitle if the domain could not be determined. -->
  <div slot="subtitle" class="self-start" hidden="[[isMeet]]">
    <div hidden="[[isEmpty(domainManager)]]">
      [[successText(locale, deviceName, domainManager)]]
    </div>
    <div id="enterpriseExplanation" class="flex layout horizontal">
      <iron-icon id="enterpriseIcon" icon="oobe-24:domain"></iron-icon>
      <div id="enterpriseIconText">
        [[i18nDynamic(locale,
                      'oauthEnrollSuccessEnterpriseIconExplanation')]]
      </div>
    </div>
  </div>
  <div slot="content" class="flex layout vertical center center-justified">
    <iron-icon icon="oobe-illos:enrollment-complete-illo"
        class="illustration-jelly" hidden="[[isMeet]]">
    </iron-icon>
    <img src="images/cfm/enrollment.svg" alt=""
        class="oobe-illustration" hidden="[[!isMeet]]">
  </div>
  <div slot="bottom-buttons">
    <oobe-text-button inverse id="successDoneButton"
        text-key="oauthEnrollDone" on-click="onEnrollmentFinished"
        class="focus-on-show"></oobe-text-button>
  </div>
</oobe-adaptive-dialog>

<!-- ATTRIBUTE PROMPT DIALOG -->
<oobe-adaptive-dialog id="step-attribute-prompt"
    for-step="attribute-prompt">
  <iron-icon slot="icon" icon="[[getIcon(licenseType)]]"></iron-icon>
  <h1 slot="title">
    [[i18nDynamic(locale, 'oauthEnrollDeviceInformation')]]
  </h1>
  <p slot="subtitle">
    <span id="subtitle">
      [[i18nDynamic(locale, 'oauthEnrollAttributeExplanation')]]
    </span>
    <a id="learnMoreLink" class="oobe-local-link" is="action-link"
        on-click="onLearnMore" aria-describedby="subtitle">
      [[i18nDynamic(locale, 'oauthEnrollExplainAttributeLink')]]
    </a>
  </p>
  <div slot="content" class="landscape-header-aligned">
    <cr-input id="assetId" type="text" value="{{assetId}}"
        class="focus-on-show"
        label="[[i18nDynamic(locale, 'enrollmentAssetIdLabel')]]">
    </cr-input>
    <cr-input id="location" type="text" value="{{deviceLocation}}"
        label="[[i18nDynamic(locale, 'enrollmentLocationLabel')]]">
    </cr-input>
  </div>
  <div slot="bottom-buttons">
    <oobe-text-button id="attributesSkip"
        text-key="oauthEnrollSkip" on-click="skipAttributes">
    </oobe-text-button>
    <oobe-next-button id="attributesSubmit"
        on-click="submitAttributes"></oobe-next-button>
  </div>
</oobe-adaptive-dialog>

<!-- Skip Enrollment confirmation dialog for LP device -->
<oobe-modal-dialog id="skipConfirmationDialog">
  <div slot="title">
    [[getSkipConfirmationTitle(locale, licenseType)]]</div>
  <div slot="content">
    [[getSkipConfirmationText(locale, licenseType)]]</div>
  <div slot="buttons">
    <oobe-text-button id="skipButton" class="focus-on-show" border
        on-click="onDialogSkip"
        text-key="skipConfirmationSkipButton"></oobe-text-button>
    <oobe-text-button inverse on-click="onDialogClosed"
        id="goBackButton"
        text-key="skipConfirmationGoBackButton"></oobe-text-button>
  </div>
</oobe-modal-dialog>
<!--_html_template_end_-->`}