// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/ash/common/cr_elements/cros_color_overrides.css.js";import"//resources/ash/common/cr_elements/cr_input/cr_input.js";import"//resources/js/action_link.js";import"//resources/polymer/v3_0/iron-icon/iron-icon.js";import"../../components/oobe_icons.html.js";import"../../components/common_styles/oobe_common_styles.css.js";import"../../components/common_styles/oobe_dialog_host_styles.css.js";import"../../components/dialogs/oobe_adaptive_dialog.js";import"../../components/dialogs/oobe_loading_dialog.js";import"../../components/buttons/oobe_back_button.js";import"../../components/buttons/oobe_next_button.js";import"../../components/buttons/oobe_text_button.js";import{AuthFlow,AuthMode}from"//oobe/gaia_auth_host/authenticator.js";import{assert}from"//resources/js/assert.js";import{sendWithPromise}from"//resources/js/cr.js";import{loadTimeData}from"//resources/js/load_time_data.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{OobeModalDialog}from"../../components/dialogs/oobe_modal_dialog.js";import{OobeUiState}from"../../components/display_manager_types.js";import{GaiaDialog}from"../../components/gaia_dialog.js";import{InjectedKeyboardUtils}from"../../components/keyboard_utils.js";import{globalOobeKeyboard,KEYBOARD_UTILS_FOR_INJECTION}from"../../components/keyboard_utils_oobe.js";import{LoginScreenMixin}from"../../components/mixins/login_screen_mixin.js";import{MultiStepMixin}from"../../components/mixins/multi_step_mixin.js";import{OobeI18nMixin}from"../../components/mixins/oobe_i18n_mixin.js";import{OobeTypes}from"../../components/oobe_types.js";import{Oobe}from"../../cr_ui.js";import*as OobeDebugger from"../../debug/debug.js";import{getTemplate}from"./enterprise_enrollment.html.js";const EnterpriseEnrollmentElementBase=LoginScreenMixin(MultiStepMixin(OobeI18nMixin(PolymerElement)));export class EnterpriseEnrollmentElement extends EnterpriseEnrollmentElementBase{static get is(){return"enterprise-enrollment-element"}static get template(){return getTemplate()}static get properties(){return{domainManager:{type:String,value:""},deviceName:{type:String,value:"Chromebook"},
/**
             * Type of license used for enrollment.
             * Only relevant for manual (gaia) flow.
             */
licenseType:{type:Number,value:OobeTypes.LicenseType.ENTERPRISE},gaiaDialogButtonsType:{type:String,value:OobeTypes.GaiaDialogButtonsType.DEFAULT},errorText:{type:String,value:""},canRetryAfterError:{type:Boolean,value:true},assetId:{type:String,value:""},deviceLocation:{type:String,value:""},hasAccountCheck:{type:Boolean,value:false},isAutoEnroll:{type:Boolean,value:false},isForced:{type:Boolean,value:false},authFlow:{type:Number},email:{type:String},isMeet:{type:Boolean,value(){return loadTimeData.valueExists("deviceFlowType")&&loadTimeData.getString("deviceFlowType")==="meet"},readOnly:true}}}constructor(){super();this.isCancelDisabled=false;this.isManualEnrollment=undefined}get EXTERNAL_API(){return["doReload","setEnterpriseDomainInfo","showAttributePromptStep","showError","showStep","showSkipConfirmationDialog"]}defaultUIStep(){return OobeTypes.EnrollmentStep.LOADING}get UI_STEPS(){return OobeTypes.EnrollmentStep}getGaiaDialog(){const gaiaDialog=this.shadowRoot?.querySelector("#step-signin");assert(gaiaDialog instanceof GaiaDialog);return gaiaDialog}getSkipConfirmationDialog(){const skipConfirmationDialog=this.shadowRoot?.querySelector("#skipConfirmationDialog");assert(skipConfirmationDialog instanceof OobeModalDialog);return skipConfirmationDialog}get authenticator(){return this.getGaiaDialog().getAuthenticator()}get authView(){return this.getGaiaDialog().getFrame()}ready(){super.ready();this.initializeLoginScreen("OAuthEnrollmentScreen");this.authView.addEventListener("loadstop",(e=>{const target=e.target;if(target instanceof HTMLIFrameElement&&!!target.contentWindow){target.contentWindow.postMessage(InjectedKeyboardUtils.INITIAL_MSG,this.authView.src)}}));assert(this.authenticator);this.authenticator.insecureContentBlockedCallback=url=>{this.showError(loadTimeData.getStringF("insecureURLEnrollmentError",url),false)};this.authenticator.missingGaiaInfoCallback=()=>{this.showError(loadTimeData.getString("fatalEnrollmentError"),false)};this.authenticator.addEventListener("getDeviceId",(()=>{sendWithPromise("getDeviceIdForEnrollment").then((deviceId=>{assert(this.authenticator);this.authenticator.getDeviceIdResponse(deviceId)}))}));this.authenticator.samlApiUsedCallback=this.samlApiUsed.bind(this)}onBeforeShow(data){if(data===undefined){super.onBeforeShow(data);return}if(Oobe.getInstance().forceKeyboardFlow){assert(KEYBOARD_UTILS_FOR_INJECTION.DATA);globalOobeKeyboard.enableHandlingOfInjectedKeyboardUtilsMessages();this.authView.addContentScripts([{name:"injectedTabHandler",matches:["http://*/*","https://*/*"],js:{code:KEYBOARD_UTILS_FOR_INJECTION.DATA},run_at:"document_start"}])}this.isManualEnrollment=data.enrollment_mode==="manual";this.isForced=data.is_enrollment_enforced;this.isAutoEnroll=data.attestationBased;this.hasAccountCheck=data.flow==="enterpriseLicense"||data.flow==="educationLicense";this.licenseType=data.license?this.convertLicenseType(data.license):OobeTypes.LicenseType.ENTERPRISE;if(!this.isAutoEnroll){const gaiaParams={};gaiaParams.gaiaUrl=data.gaiaUrl;gaiaParams.gaiaPath=data.gaiaPath;gaiaParams.clientId=data.clientId;gaiaParams.needPassword=false;gaiaParams.hl=data.hl;if(data.management_domain){gaiaParams.enterpriseEnrollmentDomain=data.management_domain;gaiaParams.emailDomain=data.management_domain}gaiaParams.flow=data.flow;gaiaParams.enableGaiaActionButtons=true;if(data.email){gaiaParams.readOnlyEmail=true;gaiaParams.email=data.email}if(data.clientVersion){gaiaParams.clientVersion=data.clientVersion}assert(this.authenticator);this.authenticator.setWebviewPartition(data.webviewPartitionName?data.webviewPartitionName:"");this.authenticator.load(AuthMode.DEFAULT,gaiaParams);if(data.gaia_buttons_type){this.gaiaDialogButtonsType=data.gaia_buttons_type}if(this.gaiaDialogButtonsType===OobeTypes.GaiaDialogButtonsType.KIOSK_PREFERRED){this.licenseType=OobeTypes.LicenseType.KIOSK}}if(!this.uiStep){this.showStep(this.isAutoEnroll?OobeTypes.EnrollmentStep.WORKING:OobeTypes.EnrollmentStep.LOADING)}super.onBeforeShow(data)}getOobeUIInitialState(){return OobeUiState.ENROLLMENT_CANCEL_DISABLED}showAttributePromptStep(annotatedAssetId,annotatedLocation){this.assetId=annotatedAssetId;this.deviceLocation=annotatedLocation;this.showStep(OobeTypes.EnrollmentStep.ATTRIBUTE_PROMPT)}setEnterpriseDomainInfo(manager,deviceType){this.domainManager=manager;this.deviceName=deviceType}onIdentifierEnteredMessage(e){if(this.hasAccountCheck){this.showStep(OobeTypes.EnrollmentStep.CHECKING);chrome.send("enterpriseIdentifierEntered",[e.detail.accountIdentifier])}}cancel(){if(this.isCancelDisabled){return}this.isCancelDisabled=true;this.closeEnrollment("cancel")}showStep(step){this.setUIStep(step);this.isCancelDisabled=step===OobeTypes.EnrollmentStep.SIGNIN&&!this.isManualEnrollment||step===OobeTypes.EnrollmentStep.WORKING||step===OobeTypes.EnrollmentStep.CHECKING||step===OobeTypes.EnrollmentStep.TPM_CHECKING||step===OobeTypes.EnrollmentStep.LOADING;if(this.isCancelDisabled||step===OobeTypes.EnrollmentStep.ATTRIBUTE_PROMPT){Oobe.getInstance().setOobeUiState(OobeUiState.ENROLLMENT_CANCEL_DISABLED)}else{Oobe.getInstance().setOobeUiState(step===OobeTypes.EnrollmentStep.SUCCESS?OobeUiState.ENROLLMENT_SUCCESS:OobeUiState.ENROLLMENT_CANCEL_ENABLED)}}doReload(){assert(this.authenticator);this.authenticator.reload()}clickPrimaryButtonForTesting(){this.getGaiaDialog().clickPrimaryButtonForTesting()}skipAttributes(){this.showStep(OobeTypes.EnrollmentStep.SUCCESS)}submitAttributes(){chrome.send("oauthEnrollAttributes",[this.assetId,this.deviceLocation])}onLearnMore(){chrome.send("oauthEnrollOnLearnMore")}closeEnrollment(result){chrome.send("oauthEnrollClose",[result])}onCancelKiosk(){this.doReload();this.showStep(OobeTypes.EnrollmentStep.SIGNIN)}onEnrollKiosk(){chrome.send("oauthEnrollCompleteLogin",[this.email,"","",false,OobeTypes.LicenseType.KIOSK])}onEnrollmentFinished(){this.closeEnrollment("done")}successText(locale,device,domain){return this.i18nAdvancedDynamic(locale,"oauthEnrollAbeSuccessDomain",{substitutions:[device,domain]})}isEmpty(str){return!str}onAuthCompleted(e){const detail=e.detail;if(!detail.email){this.showError(loadTimeData.getString("fatalEnrollmentError"),false);return}if(this.licenseType===OobeTypes.LicenseType.ENTERPRISE){chrome.send("oauthEnrollCompleteLogin",[detail.email,detail.gaiaId,detail.password,detail.usingSAML,OobeTypes.LicenseType.ENTERPRISE])}else if(this.licenseType===OobeTypes.LicenseType.EDUCATION){chrome.send("oauthEnrollCompleteLogin",[detail.email,detail.gaiaId,detail.password,detail.usingSAML,OobeTypes.LicenseType.EDUCATION])}else{this.email=detail.email;this.showStep(OobeTypes.EnrollmentStep.KIOSK_ENROLLMENT)}}onReady(){if(this.uiStep===OobeTypes.EnrollmentStep.LOADING){this.showStep(OobeTypes.EnrollmentStep.SIGNIN)}if(this.uiStep!==OobeTypes.EnrollmentStep.SIGNIN){return}this.isCancelDisabled=false;if(this.openedFromDebugOverlay()){return}chrome.send("frameLoadingCompleted")}openedFromDebugOverlay(){if(OobeDebugger.DebuggerUi&&OobeDebugger.DebuggerUi.getInstance().currentScreenId==="enterprise-enrollment"){console.warn("Enrollment screen was opened using debug overlay: "+"omit chrome.send() to prevent calls on C++ side.");return true}return false}onLicenseTypeSelected(e){this.licenseType=e.detail}showError(message,retry){this.errorText=message;this.canRetryAfterError=retry;if(this.uiStep===OobeTypes.EnrollmentStep.ATTRIBUTE_PROMPT){this.showStep(OobeTypes.EnrollmentStep.ATTRIBUTE_PROMPT_ERROR)}else{this.showStep(OobeTypes.EnrollmentStep.ERROR)}}convertLicenseType(license){switch(license){case"enterprise":return OobeTypes.LicenseType.ENTERPRISE;case"education":return OobeTypes.LicenseType.EDUCATION;case"terminal":return OobeTypes.LicenseType.KIOSK;default:return OobeTypes.LicenseType.NONE}}getCancelButtonLabel(isAutomatic){return isAutomatic?"oauthEnrollManualEnrollment":"oauthEnrollSkip"}getWorkingTitleKey(licenseType){if(licenseType===OobeTypes.LicenseType.ENTERPRISE){return"oauthEnrollScreenTitle"}if(licenseType===OobeTypes.LicenseType.EDUCATION){return"oauthEducationEnrollScreenTitle"}return"oauthEnrollKioskEnrollmentWorkingTitle"}getIcon(licenseType){if(licenseType===OobeTypes.LicenseType.ENTERPRISE){return"oobe-32:enterprise"}if(licenseType===OobeTypes.LicenseType.EDUCATION){return"oobe-32:enterprise"}return"oobe-32:kiosk"}getSuccessTitle(locale,licenseType){if(licenseType===OobeTypes.LicenseType.ENTERPRISE){return this.i18nDynamic(locale,"oauthEnrollSuccessTitle")}if(licenseType===OobeTypes.LicenseType.EDUCATION){return this.i18nDynamic(locale,"oauthEnrollEducationSuccessTitle")}return this.i18nDynamic(locale,"oauthEnrollKioskEnrollmentSuccessTitle")}getErrorTitle(locale,licenseType){if(licenseType===OobeTypes.LicenseType.EDUCATION){return this.i18nDynamic(locale,"oauthEducationEnrollErrorTitle")}return this.i18nDynamic(locale,"oauthEnrollErrorTitle")}isGenericCancel(automatic,enforced){return automatic||!automatic&&!enforced}doRetry(){chrome.send("oauthEnrollRetry")}isSaml(authFlow){return authFlow===AuthFlow.SAML}onTpmCheckCanceled(){this.userActed("cancel-tpm-check")}getSkipConfirmationTitle(locale,licenseType){if(licenseType===OobeTypes.LicenseType.EDUCATION){return this.i18nDynamic(locale,"skipConfirmationDialogEducationTitle")}return this.i18nDynamic(locale,"skipConfirmationDialogTitle")}getSkipConfirmationText(locale,licenseType){if(licenseType===OobeTypes.LicenseType.EDUCATION){return this.i18nDynamic(locale,"skipConfirmationDialogEducationText")}return this.i18nDynamic(locale,"skipConfirmationDialogText")}onDialogClosed(){this.getSkipConfirmationDialog().hideDialog()}onDialogSkip(){this.getSkipConfirmationDialog().hideDialog();this.userActed("skip-confirmation")}showSkipConfirmationDialog(){this.getSkipConfirmationDialog().showDialog()}samlApiUsed(_){this.userActed("using-saml-api")}}customElements.define(EnterpriseEnrollmentElement.is,EnterpriseEnrollmentElement);