import{html}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";export function getTemplate(){return html`<!--_html_template_start_-->
<style include="oobe-dialog-host-styles">:host{--paper-spinner-color:var(--cros-sys-primary)}.hid-selection-entry{border-bottom:1px solid var(--cros-sys-separator);color:var(--google-grey-900)}:host-context(.jelly-enabled) .hid-selection-entry{color:var(--oobe-text-color)}#touchscreen-icon,#keyboard-icon,#mouse-icon{--iron-icon-height:20px;--iron-icon-width:20px;padding-inline-end:16px}#hid-touchscreen-row,#hid-mouse-row,#hid-keyboard-row{min-height:48px}#touchscreen-tick,#keyboard-tick,#mouse-tick{margin-inline-start:-28px;position:relative;top:4px}#hid-keyboard-pincode{padding:30px 0 30px 0}.key-next{background:rgb(26,115,232);border-radius:5px;color:#fff}.pin-code-style{color:rgb(26,115,232);font-size:48px;line-height:48px}.content-padding{padding-top:12px}.icon-active{height:24px;padding-inline-end:16px;width:24px}</style>
<oobe-adaptive-dialog>
  <iron-icon slot="icon" icon="oobe-32:connect-devices">
  </iron-icon>
  <h1 slot="title" aria-live="polite">
    [[i18nDynamic(locale, 'hidDetectionInvitation')]]
  </h1>
  <div slot="subtitle" aria-live="polite">
    [[getPrerequisitesText(locale, touchscreenDetected_)]]
  </div>
  <div slot="content" class="landscape-header-aligned">
    <div id="hid-touchscreen-entry"
        class="layout vertical justified hid-selection-entry"
        hidden="[[!touchscreenDetected_]]">
      <div id="hid-touchscreen-row" class="flex layout horizontal center">
        <hd-iron-icon id="touchscreen-icon" alt=""
            icon1x="oobe-20:hid-touchscreen"
            icon2x="oobe-40:hid-touchscreen">
        </hd-iron-icon>
        <img id="touchscreen-tick" alt=""
            src="chrome://theme/IDR_BLUETOOTH_PAIRING_TICK">
        <div id="touchscreen-label" aria-live="polite">
            [[i18nDynamic(locale, 'hidDetectionTouchscreenDetected')]]
        </div>
      </div>
    </div>
    <div class="layout vertical hid-selection-entry">
      <div id="hid-mouse-row" class="flex layout horizontal center">
        <paper-spinner-lite class="icon-active"
            hidden="[[!spinnerIsVisible(mouseState)]]" active>
        </paper-spinner-lite>
        <hd-iron-icon id="mouse-icon" alt=""
            icon1x="oobe-20:hid-mouse" icon2x="oobe-40:hid-mouse"
            hidden="[[spinnerIsVisible(mouseState)]]">
        </hd-iron-icon>
        <img id="mouse-tick" alt=""
            hidden="[[!tickIsVisible(mouseState)]]"
            src="chrome://theme/IDR_BLUETOOTH_PAIRING_TICK">
        <div id="mouse-label" aria-live="polite" class="flex">
          [[getMouseLabel(locale, mouseState, pointingDeviceName)]]
        </div>
      </div>
    </div>
    <div class="layout vertical hid-selection-entry">
      <div id="hid-keyboard-row" class="flex layout horizontal center"
          on-click="openPinDialog">
        <paper-spinner-lite class="icon-active"
            hidden="[[!spinnerIsVisible(keyboardState)]]" active>
        </paper-spinner-lite>
        <hd-iron-icon id="keyboard-icon" alt=""
            icon1x="oobe-20:hid-keyboard" icon2x="oobe-40:hid-keyboard"
            hidden="[[spinnerIsVisible(keyboardState)]]">
        </hd-iron-icon>
        <img id="keyboard-tick" alt=""
            hidden="[[!tickIsVisible(keyboardState)]]"
            src="chrome://theme/IDR_BLUETOOTH_PAIRING_TICK">
        <div id="keyboard-label" aria-live="polite" class="flex">
          [[getKeyboardLabel(locale, keyboardState, keyboardDeviceName)]]
        </div>
      </div>
    </div>
  </div>
  <div slot="bottom-buttons">
    <oobe-text-button inverse on-click="onHidContinueClick"
        text-key="hidDetectionContinue"
        id="hid-continue-button"
        disabled="[[!continueButtonEnabled]]"></oobe-text-button>
  </div>
</oobe-adaptive-dialog>

<!-- Popup that displays the PIN for pairing with a bluetooth keyboard. -->
<oobe-modal-dialog id="hid-pin-popup" should-hide-close-button
    should-hide-title-row>
  <div slot="content" class="content-padding">
    <bluetooth-pairing-enter-code-page
        id="hid-pairing-enter-code"
        class="focus-on-show"
        code="[[pinCode]]"
        num-keys-entered="[[numKeysEnteredPinCode]]"
        device-name="[[keyboardDeviceName]]"
        on-cancel="onCancel">
    </bluetooth-pairing-enter-code-page>
  </div>
</oobe-modal-dialog>
<!--_html_template_end_-->`}