// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/polymer/v3_0/iron-icon/iron-icon.js";import"//resources/ash/common/network/network_list.js";import"../../components/buttons/oobe_back_button.js";import"../../components/buttons/oobe_next_button.js";import"../../components/common_styles/oobe_common_styles.css.js";import"../../components/common_styles/oobe_dialog_host_styles.css.js";import"../../components/dialogs/oobe_adaptive_dialog.js";import"../../components/dialogs/oobe_loading_dialog.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{assert}from"chrome://resources/js/assert.js";import{OobeAdaptiveDialog}from"../../components/dialogs/oobe_adaptive_dialog.js";import{LoginScreenMixin}from"../../components/mixins/login_screen_mixin.js";import{MultiStepMixin}from"../../components/mixins/multi_step_mixin.js";import{OobeDialogHostMixin}from"../../components/mixins/oobe_dialog_host_mixin.js";import{OobeI18nMixin}from"../../components/mixins/oobe_i18n_mixin.js";import{NetworkSelectLogin}from"../../components/network_select_login.js";import{getTemplate}from"./oobe_network.html.js";export var NetworkScreenStates;(function(NetworkScreenStates){NetworkScreenStates["DEFAULT"]="default";NetworkScreenStates["QUICK_START_CONNECTING"]="quick-start-connecting"})(NetworkScreenStates||(NetworkScreenStates={}));const NetworkScreenBase=OobeDialogHostMixin(LoginScreenMixin(MultiStepMixin(OobeI18nMixin(PolymerElement))));class NetworkScreen extends NetworkScreenBase{static get is(){return"oobe-network-element"}static get template(){return getTemplate()}static get properties(){return{errorMessage:{type:String,value:""},isNetworkConnected:{type:Boolean,value:false},enableWifiScans:{type:Boolean,value:true},isQuickStartVisible:{type:Boolean,value:false},ssid:{type:String,value:""},useQuickStartSubtitle:{type:Boolean,value:false},useQuickStartWiFiErrorStrings:{type:Boolean,value:false},quickStartCancelButtonVisible:{type:Boolean,value:true}}}static get observers(){return[]}get EXTERNAL_API(){return["setError","setQuickStartEntryPointVisibility"]}constructor(){super()}defaultUIStep(){return NetworkScreenStates.DEFAULT}get UI_STEPS(){return NetworkScreenStates}getNetworkSelectLogin(){const networkSelectLogin=this.shadowRoot?.querySelector("#networkSelectLogin");assert(networkSelectLogin instanceof NetworkSelectLogin);return networkSelectLogin}onBeforeShow(data){super.onBeforeShow(data);if(data&&"ssid"in data&&data["ssid"]){this.ssid=data["ssid"]}else{this.ssid=""}if(this.ssid){this.setUIStep(NetworkScreenStates.QUICK_START_CONNECTING);this.quickStartCancelButtonVisible=true;return}this.useQuickStartSubtitle=data?.useQuickStartSubtitle??false;this.useQuickStartWiFiErrorStrings=data?.useQuickStartWiFiErrorStrings??false;this.setUIStep(NetworkScreenStates.DEFAULT);this.enableWifiScans=true;this.errorMessage="";this.getNetworkSelectLogin().onBeforeShow();this.show()}onBeforeHide(){super.onBeforeHide();this.getNetworkSelectLogin().onBeforeHide();this.enableWifiScans=false;this.isQuickStartVisible=false}ready(){super.ready();this.initializeLoginScreen("NetworkScreen");this.updateLocalizedContent()}getNetworkDialog(){const networkDialog=this.shadowRoot?.querySelector("#networkDialog");assert(networkDialog instanceof OobeAdaptiveDialog);return networkDialog}show(){this.getNetworkDialog().show()}focus(){this.getNetworkDialog().focus()}updateLocalizedContent(){this.i18nUpdateLocale()}getSubtitleMessage(locale,errorMessage,useQuickStartSubtitle,useQuickStartWiFiErrorStrings){if(errorMessage){return errorMessage}if(useQuickStartSubtitle){return this.i18nDynamic(locale,"quickStartNetworkNeededSubtitle")}if(useQuickStartWiFiErrorStrings){return this.i18nDynamic(locale,"networkScreenQuickStartWiFiErrorSubtitle")}return this.i18nDynamic(locale,"networkSectionSubtitle")}setError(message){this.errorMessage=message;this.useQuickStartWiFiErrorStrings=false}setQuickStartEntryPointVisibility(visible){this.isQuickStartVisible=visible}getNetworkListItemByNameForTest(name){const item=this.getNetworkSelectLogin()?.shadowRoot?.querySelector("#networkSelect")?.getNetworkListItemByNameForTest(name);if(item!==undefined){return item}return null}onShown(){const networkSelectLogin=this.getNetworkSelectLogin();networkSelectLogin.refresh();setTimeout((()=>{if(this.isNetworkConnected){const nextButton=this.shadowRoot?.querySelector("#nextButton");assert(nextButton instanceof HTMLElement);nextButton.focus()}else{networkSelectLogin.focus()}}),300)}onQuickStartClicked(){this.userActed("activateQuickStart")}onBackClicked(){this.userActed("back")}onCancelClicked(){this.quickStartCancelButtonVisible=false;this.userActed("cancel")}onContinue(){this.userActed("continue")}}customElements.define(NetworkScreen.is,NetworkScreen);