// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/polymer/v3_0/iron-icon/iron-icon.js";import"//resources/polymer/v3_0/paper-progress/paper-progress.js";import"../../components/oobe_cr_lottie.js";import"../../components/oobe_icons.html.js";import"../../components/buttons/oobe_back_button.js";import"../../components/buttons/oobe_next_button.js";import"../../components/common_styles/oobe_dialog_host_styles.css.js";import"../../components/dialogs/oobe_adaptive_dialog.js";import"../../components/dialogs/oobe_loading_dialog.js";import"../../components/oobe_carousel.js";import"../../components/oobe_slide.js";import{loadTimeData}from"//resources/js/load_time_data.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{LoginScreenMixin}from"../../components/mixins/login_screen_mixin.js";import{MultiStepMixin}from"../../components/mixins/multi_step_mixin.js";import{OobeI18nMixin}from"../../components/mixins/oobe_i18n_mixin.js";import{OobeCrLottie}from"../../components/oobe_cr_lottie.js";import{getTemplate}from"./update.html.js";const USER_ACTION_ACCEPT_UPDATE_OVER_CELLUAR="update-accept-cellular";const USER_ACTION_REJECT_UPDATE_OVER_CELLUAR="update-reject-cellular";const USER_ACTION_CANCEL_UPDATE_SHORTCUT="cancel-update";const USER_ACTION_OPT_OUT_INFO_NEXT="opt-out-info-next";const UNREACHABLE_PERCENT=1e3;const PERCENT_THRESHOLDS=[0,10,20,30,40,50,60,70,80,90,95,98,99,100,UNREACHABLE_PERCENT];var UpdateUiState;(function(UpdateUiState){UpdateUiState["CHECKING"]="checking";UpdateUiState["CHECKING_SOFTWARE"]="checking-software";UpdateUiState["UPDATE"]="update";UpdateUiState["RESTART"]="restart";UpdateUiState["REBOOT"]="reboot";UpdateUiState["CELLULAR"]="cellular";UpdateUiState["OPT_OUT_INFO"]="opt-out-info"})(UpdateUiState||(UpdateUiState={}));const UpdateBase=LoginScreenMixin(MultiStepMixin(OobeI18nMixin(PolymerElement)));export class Update extends UpdateBase{static get is(){return"update-element"}static get template(){return getTemplate()}static get properties(){return{manualRebootNeeded:{type:Boolean,value:false},cancelAllowed:{type:Boolean,value:false},cancelHint:{type:String,value:"cancelUpdateHint"},showLowBatteryWarning:{type:Boolean,value:false},updateStatusMessagePercent:{type:String,value:""},updateStatusMessageTimeLeft:{type:String,value:""},betterUpdateProgressValue:{type:Number,value:0},autoTransition:{type:Boolean,value:true},thresholdIndex:{type:Number,value:0},isOptOutEnabled:{type:Boolean,value:false},isOobeSoftwareUpdateEnabled:{type:Boolean,value(){return loadTimeData.getBoolean("isOobeSoftwareUpdateEnabled")}}}}static get observers(){return["playAnimation(uiStep)"]}defaultUIStep(){if(this.isOobeSoftwareUpdateEnabled){return UpdateUiState.CHECKING_SOFTWARE}else{return UpdateUiState.CHECKING}}get UI_STEPS(){return UpdateUiState}get EXTERNAL_API(){return["setCancelUpdateShortcutEnabled","showLowBatteryWarningMessage","setUpdateState","setUpdateStatus","setAutoTransition"]}ready(){super.ready();this.initializeLoginScreen("UpdateScreen")}onBeforeShow(data){super.onBeforeShow(data);if(data&&"isOptOutEnabled"in data){this.isOptOutEnabled=data["isOptOutEnabled"]}}cancel(){this.userActed(USER_ACTION_CANCEL_UPDATE_SHORTCUT)}onBackClicked(){this.userActed(USER_ACTION_REJECT_UPDATE_OVER_CELLUAR)}onNextClicked(){this.userActed(USER_ACTION_ACCEPT_UPDATE_OVER_CELLUAR)}onOptOutInfoNext(){this.userActed(USER_ACTION_OPT_OUT_INFO_NEXT)}setCancelUpdateShortcutEnabled(enabled){this.cancelAllowed=enabled}showLowBatteryWarningMessage(visible){this.showLowBatteryWarning=visible}setUpdateState(value){if(value==="checking"&&this.isOobeSoftwareUpdateEnabled){this.setUIStep(UpdateUiState.CHECKING_SOFTWARE)}else{this.setUIStep(value)}}setUpdateStatus(percent,messagePercent,messageTimeLeft){const betterUpdatePercent=this.shadowRoot?.querySelector("#betterUpdatePercent");const betterUpdateTimeleft=this.shadowRoot?.querySelector("#betterUpdateTimeleft");if(percent>=PERCENT_THRESHOLDS[this.thresholdIndex]){while(percent>=PERCENT_THRESHOLDS[this.thresholdIndex]){this.thresholdIndex=this.thresholdIndex+1}if(betterUpdatePercent instanceof HTMLElement&&betterUpdateTimeleft instanceof HTMLElement){betterUpdatePercent.setAttribute("aria-live","polite");betterUpdateTimeleft.setAttribute("aria-live","polite")}}else{if(betterUpdatePercent instanceof HTMLElement&&betterUpdateTimeleft instanceof HTMLElement){betterUpdatePercent.setAttribute("aria-live","off");betterUpdateTimeleft.setAttribute("aria-live","off")}}this.betterUpdateProgressValue=percent;this.updateStatusMessagePercent=messagePercent;this.updateStatusMessageTimeLeft=messageTimeLeft}setAutoTransition(value){this.autoTransition=value}getAutoTransition(step,autoTransition){return step===UpdateUiState.UPDATE&&autoTransition}getUpdateSlideTitle(locale,isOptOutEnabled){return this.i18nDynamic(locale,isOptOutEnabled?"slideUpdateAdditionalSettingsTitle":"slideUpdateTitle")}getUpdateSlideText(locale,isOptOutEnabled){return this.i18nDynamic(locale,isOptOutEnabled?"slideUpdateAdditionalSettingsText":"slideUpdateText")}playAnimation(uiStep){const animation=this.shadowRoot?.querySelector("#checkingAnimation");if(animation instanceof OobeCrLottie){animation.playing=uiStep===UpdateUiState.CHECKING}}}customElements.define(Update.is,Update);