// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/ash/common/cr_elements/cros_color_overrides.css.js";import"//resources/ash/common/cr_elements/cr_shared_vars.css.js";import"//resources/polymer/v3_0/iron-icon/iron-icon.js";import"../../components/oobe_icons.html.js";import"../../components/oobe_i18n_dropdown.js";import"../../components/common_styles/oobe_common_styles.css.js";import"../../components/common_styles/oobe_dialog_host_styles.css.js";import"../../components/dialogs/oobe_adaptive_dialog.js";import{CrInputElement}from"//resources/ash/common/cr_elements/cr_input/cr_input.js";import{loadTimeData}from"//resources/ash/common/load_time_data.m.js";import{assert}from"//resources/js/assert.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{OobeModalDialog}from"../../components/dialogs/oobe_modal_dialog.js";import{LoginScreenMixin}from"../../components/mixins/login_screen_mixin.js";import{MultiStepMixin}from"../../components/mixins/multi_step_mixin.js";import{OobeI18nMixin}from"../../components/mixins/oobe_i18n_mixin.js";import{OobeA11yOption}from"../../components/oobe_a11y_option.js";import{getSelectedTitle}from"../../components/oobe_select.js";import{Oobe}from"../../cr_ui.js";import{traceWelcomeAnimationPlay}from"../../oobe_trace.js";import{getTemplate}from"./welcome.html.js";import{OobeWelcomeDialog}from"./welcome_dialog.js";const DEFAULT_CHROMEVOX_HINT_LOCALE="en-US";const DEFAULT_CHROMEVOX_HINT_VOICE_EXTENSION_ID="gjjabgpgjpampikjhjpfhneeoapjbjaf";const HELP_LANGUAGE_PACKS=11383012;var WelcomeScreenState;(function(WelcomeScreenState){WelcomeScreenState["GREETING"]="greeting";WelcomeScreenState["LANGUAGE"]="language";WelcomeScreenState["ACCESSIBILITY"]="accessibility";WelcomeScreenState["TIMEZONE"]="timezone";WelcomeScreenState["ADVANCED_OPTIONS"]="advanced-options"})(WelcomeScreenState||(WelcomeScreenState={}));const OobeWelcomeScreenBase=LoginScreenMixin(MultiStepMixin(OobeI18nMixin(PolymerElement)));export class OobeWelcomeScreen extends OobeWelcomeScreenBase{static get is(){return"oobe-welcome-element"}static get template(){return getTemplate()}static get properties(){return{currentLanguage:String,currentKeyboard:String,languages:{type:Array,observer:"onLanguagesChanged"},keyboards:{type:Array,observer:"onKeyboardsChanged"},a11yStatus:{type:Object},timezones:{type:Object},highlightStrength:{type:String},debuggingLinkVisible:{type:Boolean},voicesChangedListenerMaybeGiveChromeVoxHint:{type:Function},defaultChromeVoxHintTimeoutId:{type:Number},DEFAULT_CHROMEVOX_HINT_TIMEOUT_MS:{type:Number},chromeVoxHintGiven:{type:Boolean},isMeet:{type:Boolean,value:function(){return loadTimeData.valueExists("deviceFlowType")&&loadTimeData.getString("deviceFlowType")==="meet"},readOnly:true},isDeviceRequisitionConfigurable:{type:Boolean,value:function(){return loadTimeData.getBoolean("isDeviceRequisitionConfigurable")},readOnly:true}}}constructor(){super();this.currentLanguage="";this.currentKeyboard="";this.highlightStrength="";this.debuggingLinkVisible=false;this.voicesChangedListenerMaybeGiveChromeVoxHint=undefined;this.defaultChromeVoxHintTimeoutId=undefined;this.DEFAULT_CHROMEVOX_HINT_TIMEOUT_MS=40*1e3;this.chromeVoxHintGiven=false;this.configurationApplied=false}get EXTERNAL_API(){return["onInputMethodIdSetFromBackend","refreshA11yInfo","showDemoModeConfirmationDialog","showEditRequisitionDialog","showRemoraRequisitionDialog","maybeGiveChromeVoxHint","setQuickStartEnabled"]}defaultUIStep(){return WelcomeScreenState.GREETING}get UI_STEPS(){return WelcomeScreenState}ready(){super.ready();this.addEventListener("cros-lottie-playing",this.measureAnimationPlayDelay,{once:true});this.initializeLoginScreen("WelcomeScreen");this.updateLocalizedContent()}onBeforeShow(data){super.onBeforeShow(data);this.debuggingLinkVisible=data&&"isDeveloperMode"in data&&data["isDeveloperMode"];window.setTimeout((()=>void this.applyOobeConfiguration()),0)}getWelcomeScreenDialog(){const dialog=this.shadowRoot?.querySelector("#welcomeScreen");assert(dialog instanceof OobeWelcomeDialog);return dialog}measureAnimationPlayDelay(e){e.stopPropagation();traceWelcomeAnimationPlay()}onBeforeHide(){super.onBeforeHide();this.cleanupChromeVoxHint()}cancel(){if(this.uiStep===WelcomeScreenState.LANGUAGE){this.closeLanguageSection();return}if(this.uiStep===WelcomeScreenState.ACCESSIBILITY){this.closeAccessibilitySection();return}}updateLocalizedContent(){this.languages=loadTimeData.getValue("languageList");this.keyboards=loadTimeData.getValue("inputMethodsList");this.timezones=loadTimeData.getValue("timezoneList");this.highlightStrength=loadTimeData.getValue("highlightStrength");this.getWelcomeScreenDialog().i18nUpdateLocale();this.i18nUpdateLocale();const currentLanguage=loadTimeData.getString("language");const configuration=Oobe.getInstance().getOobeConfiguration();if(configuration&&configuration.language&&configuration.language===currentLanguage){window.setTimeout((()=>void this.applyOobeConfiguration()),0)}}updateOobeConfiguration(){if(!this.configurationApplied){window.setTimeout((()=>void this.applyOobeConfiguration()),0)}}applyOobeConfiguration(){if(this.configurationApplied){return}const configuration=Oobe.getInstance().getOobeConfiguration();if(!configuration){return}if(configuration.language){const currentLanguage=loadTimeData.getString("language");if(currentLanguage!==configuration.language){this.applySelectedLanguage(configuration.language);return}}if(configuration.inputMethod){this.applySelectedLkeyboard(configuration.inputMethod)}if(configuration.welcomeNext){this.onWelcomeNextButtonClicked()}if(configuration.enableDemoMode){this.userActed("setupDemoModeGesture")}this.configurationApplied=true}isTimezoneButtonVisible(highlightStrength){return highlightStrength==="strong"}onWelcomeNextButtonClicked(){this.userActed("continue")}onEnableDebuggingClicked(){this.userActed("enableDebugging")}onWelcomeLaunchAdvancedOptions(){this.cancelChromeVoxHint();this.setUIStep(WelcomeScreenState.ADVANCED_OPTIONS)}onWelcomeSelectLanguageButtonClicked(){this.cancelChromeVoxHint();this.setUIStep(WelcomeScreenState.LANGUAGE)}onWelcomeAccessibilityButtonClicked(){this.cancelChromeVoxHint();this.setUIStep(WelcomeScreenState.ACCESSIBILITY)}onWelcomeTimezoneButtonClicked(){this.cancelChromeVoxHint();this.setUIStep(WelcomeScreenState.TIMEZONE)}onLanguageSelected(event){const item=event.detail;const languageId=item.value;this.currentLanguage=item.title;this.applySelectedLanguage(languageId)}applySelectedLanguage(languageId){this.userActed(["setLocaleId",languageId])}onKeyboardSelected(event){const item=event.detail;const inputMethodId=item.value;this.currentKeyboard=item.title;this.applySelectedLkeyboard(inputMethodId)}applySelectedLkeyboard(inputMethodId){this.userActed(["setInputMethodId",inputMethodId])}onLanguagesChanged(){this.currentLanguage=getSelectedTitle(this.languages)}onInputMethodIdSetFromBackend(keyboardId){let found=false;for(let i=0;i<this.keyboards.length;++i){if(this.keyboards[i].value!==keyboardId){this.keyboards[i].selected=false;continue}this.keyboards[i].selected=true;found=true}if(!found){return}this.keyboards=this.keyboards.slice();this.onKeyboardsChanged()}refreshA11yInfo(data){this.a11yStatus=data;if(data.spokenFeedbackEnabled){this.closeChromeVoxHint()}}getDemoModeConfirmationDialog(){const dialog=this.shadowRoot?.querySelector("#demoModeConfirmationDialog");assert(dialog instanceof OobeModalDialog);return dialog}onDemoModeDialogCancel(){this.getDemoModeConfirmationDialog().hideDialog()}onDemoModeDialogConfirm(){this.userActed("setupDemoMode");this.getDemoModeConfirmationDialog().hideDialog()}showDemoModeConfirmationDialog(){this.closeChromeVoxHint();this.getDemoModeConfirmationDialog().showDialog()}onSetupDemoModeGesture(){this.userActed("setupDemoModeGesture")}getEditRequisitionDialog(){const dialog=this.shadowRoot?.querySelector("#editRequisitionDialog");assert(dialog instanceof OobeModalDialog);return dialog}getEditRequisitionInput(){const input=this.shadowRoot?.querySelector("#editRequisitioninput");assert(input instanceof CrInputElement);return input}showEditRequisitionDialog(){this.getEditRequisitionDialog().showDialog();this.getEditRequisitionInput().focus()}onEditRequisitionCancel(){this.userActed(["setDeviceRequisition","none"]);this.getEditRequisitionDialog().hideDialog()}onEditRequisitionConfirm(){const requisition=this.getEditRequisitionInput().value;this.userActed(["setDeviceRequisition",requisition]);this.getEditRequisitionDialog().hideDialog()}getRemoraRequisitionDialog(){const dialog=this.shadowRoot?.querySelector("#remoraRequisitionDialog");assert(dialog instanceof OobeModalDialog);return dialog}showRemoraRequisitionDialog(){this.getRemoraRequisitionDialog().showDialog()}onRemoraCancel(){this.userActed(["setDeviceRequisition","none"]);this.getRemoraRequisitionDialog().hideDialog()}onRemoraConfirm(){this.userActed(["setDeviceRequisition","remora"]);this.getRemoraRequisitionDialog().hideDialog()}onKeyboardsChanged(){this.currentKeyboard=getSelectedTitle(this.keyboards)}closeLanguageSection(){this.setUIStep(WelcomeScreenState.GREETING)}onLanguageLearnMoreLinkClicked(e){chrome.send("launchHelpApp",[HELP_LANGUAGE_PACKS]);const elem=this.shadowRoot?.querySelector("#languagesLearnMore");assert(elem instanceof HTMLAnchorElement);elem.focus();e.stopPropagation()}closeAccessibilitySection(){this.setUIStep(WelcomeScreenState.GREETING)}onA11yOptionChanged(event){assert(event.currentTarget instanceof OobeA11yOption);const a11ytarget=event.currentTarget;if(a11ytarget.checked){this.userActed(a11ytarget.id+"-enable")}else{this.userActed(a11ytarget.id+"-disable")}}closeTimezoneSection(){this.setUIStep(WelcomeScreenState.GREETING)}onTimezoneSelected(event){const item=event.detail;if(!item){return}this.userActed(["setTimezoneId",item.value])}closeAdvancedOptionsSection(){this.setUIStep(WelcomeScreenState.GREETING)}onCfmBootstrappingClicked(){this.userActed("activateRemoraRequisition")}onDeviceRequisitionClicked(){this.userActed("editDeviceRequisition")}onChromeVoxHintAccepted(){this.userActed("activateChromeVoxFromHint")}onChromeVoxHintDismissed(){this.userActed("dismissChromeVoxHint");chrome.tts.isSpeaking((speaking=>{if(speaking){chrome.tts.stop()}}))}showChromeVoxHint(){this.getWelcomeScreenDialog().showChromeVoxHint()}closeChromeVoxHint(){this.getWelcomeScreenDialog().closeChromeVoxHint()}cancelChromeVoxHint(){this.userActed("cancelChromeVoxHint");this.cleanupChromeVoxHint()}maybeGiveChromeVoxHint(){chrome.tts.getVoices((voices=>{const locale=loadTimeData.getString("language");const voiceName=this.findVoiceForLocale(voices,locale);if(!voiceName){this.onVoiceNotLoaded();return}const ttsOptions={lang:locale,voiceName:voiceName};this.giveChromeVoxHint(locale,ttsOptions,false)}))}findVoiceForLocale(voices,locale){const language=locale.toLowerCase().split("-")[0];const voice=voices.find((voice=>!!(voice.lang&&voice.lang.toLowerCase().split("-")[0]===language)));return voice?voice.voiceName:undefined}onVoiceNotLoaded(){if(this.voicesChangedListenerMaybeGiveChromeVoxHint===undefined){this.voicesChangedListenerMaybeGiveChromeVoxHint=()=>this.maybeGiveChromeVoxHint();window.speechSynthesis.addEventListener("voiceschanged",this.voicesChangedListenerMaybeGiveChromeVoxHint,false)}if(!this.defaultChromeVoxHintTimeoutId){const ttsOptions={lang:DEFAULT_CHROMEVOX_HINT_LOCALE,extensionId:DEFAULT_CHROMEVOX_HINT_VOICE_EXTENSION_ID};this.defaultChromeVoxHintTimeoutId=window.setTimeout((()=>this.giveChromeVoxHint(DEFAULT_CHROMEVOX_HINT_LOCALE,ttsOptions,true)),this.DEFAULT_CHROMEVOX_HINT_TIMEOUT_MS)}}giveChromeVoxHint(_locale,options,isDefaultHint){if(this.chromeVoxHintGiven){return}this.chromeVoxHintGiven=true;if(isDefaultHint){console.warn("No voice available for "+loadTimeData.getString("language")+", giving default hint in English.")}this.cleanupChromeVoxHint();const msgId=document.documentElement.hasAttribute("tablet")?"chromeVoxHintAnnouncementTextTabletExpanded":"chromeVoxHintAnnouncementTextLaptopExpanded";const message=this.i18n(msgId);chrome.tts.speak(message,options,(()=>{this.showChromeVoxHint();chrome.send("WelcomeScreen.recordChromeVoxHintSpokenSuccess")}))}cleanupChromeVoxHint(){if(this.defaultChromeVoxHintTimeoutId){window.clearTimeout(this.defaultChromeVoxHintTimeoutId)}if(this.voicesChangedListenerMaybeGiveChromeVoxHint!==undefined){window.speechSynthesis.removeEventListener("voiceschanged",this.voicesChangedListenerMaybeGiveChromeVoxHint,false);this.voicesChangedListenerMaybeGiveChromeVoxHint=undefined}}hideCfmSetupButton(isDeviceRequisitionConfigurable,isMeet){return!isDeviceRequisitionConfigurable&&!isMeet}setQuickStartEnabled(){this.getWelcomeScreenDialog().isQuickStartEnabled=true}onActivateQuickStart(){this.userActed("quickStartClicked")}}customElements.define(OobeWelcomeScreen.is,OobeWelcomeScreen);