// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/js/action_link.js";import"//resources/ash/common/cr_elements/cr_shared_style.css.js";import"../../components/oobe_icons.html.js";import"../../components/oobe_illo_icons.html.js";import"../../components/common_styles/oobe_dialog_host_styles.css.js";import"../../components/oobe_vars/oobe_shared_vars.css.js";import"../../components/buttons/oobe_icon_button.js";import"../../components/hd_iron_icon.js";import"../../components/quick_start_entry_point.js";import{loadTimeData}from"//resources/ash/common/load_time_data.m.js";import{assert}from"//resources/js/assert.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{OobeIconButton}from"../../components/buttons/oobe_icon_button.js";import{OobeTextButton}from"../../components/buttons/oobe_text_button.js";import{OobeModalDialog}from"../../components/dialogs/oobe_modal_dialog.js";import{LongTouchDetector}from"../../components/long_touch_detector.js";import{OobeDialogHostMixin}from"../../components/mixins/oobe_dialog_host_mixin.js";import{OobeI18nMixin}from"../../components/mixins/oobe_i18n_mixin.js";import{OobeCrLottie}from"../../components/oobe_cr_lottie.js";import{getTemplate}from"./welcome_dialog.html.js";const OobeWelcomeDialogBase=OobeDialogHostMixin(OobeI18nMixin(PolymerElement));export class OobeWelcomeDialog extends OobeWelcomeDialogBase{static get is(){return"oobe-welcome-dialog"}static get template(){return getTemplate()}static get properties(){return{currentLanguage:{type:String},timezoneButtonVisible:{type:Boolean},debuggingLinkVisible:{type:Boolean},hidden:{type:Boolean,observer:"updateHidden",reflectToAttribute:true},isMeet:{type:Boolean,value:function(){return loadTimeData.valueExists("deviceFlowType")&&loadTimeData.getString("deviceFlowType")==="meet"},readOnly:true},isFjord:{type:Boolean,value:function(){return loadTimeData.valueExists("deviceFlowType")&&loadTimeData.getString("deviceFlowType")==="fjord"},readOnly:true},isBootAnimation:{type:Boolean,value:function(){return loadTimeData.valueExists("isBootAnimationEnabled")&&loadTimeData.getBoolean("isBootAnimationEnabled")},readOnly:true},isDeviceRequisitionConfigurable:{type:Boolean,value:function(){return loadTimeData.getBoolean("isDeviceRequisitionConfigurable")},readOnly:true},isOobeLoaded:{type:Boolean,value:false},isQuickStartEnabled:{type:Boolean}}}constructor(){super();this.currentLanguage="";this.timezoneButtonVisible=false;this.titleLongTouchDetector=null;this.focusedElement=null;this.isQuickStartEnabled=false}getGetStartedButton(){const button=this.shadowRoot?.querySelector("#getStarted");assert(button instanceof OobeTextButton);return button}getEnableDebuggingButton(){const button=this.shadowRoot?.querySelector("#enableDebuggingButton");assert(button instanceof OobeIconButton);return button}ready(){super.ready();if(loadTimeData.getBoolean("isOobeLazyLoadingEnabled")){this.getGetStartedButton().disabled=true;this.getEnableDebuggingButton().disabled=true;document.addEventListener("oobe-screens-loaded",this.enableButtonsWhenLoaded.bind(this))}}onBeforeShow(){super.onBeforeShow();this.setVideoPlay(true)}enableButtonsWhenLoaded(){document.removeEventListener("oobe-screens-loaded",this.enableButtonsWhenLoaded.bind(this));this.getGetStartedButton().disabled=false;this.getEnableDebuggingButton().disabled=false;this.isOobeLoaded=true}onLanguageClicked(){this.focusedElement="languageSelectionButton";this.dispatchEvent(new CustomEvent("language-button-clicked",{bubbles:true,composed:true}))}onAccessibilityClicked(){this.focusedElement="accessibilitySettingsButton";this.dispatchEvent(new CustomEvent("accessibility-button-clicked",{bubbles:true,composed:true}))}onTimezoneClicked(){this.focusedElement="timezoneSettingsButton";this.dispatchEvent(new CustomEvent("timezone-button-clicked",{bubbles:true,composed:true}))}onNextClicked(){this.focusedElement="getStarted";this.dispatchEvent(new CustomEvent("next-button-clicked",{bubbles:true,composed:true}))}onDebuggingLinkClicked(){this.dispatchEvent(new CustomEvent("enable-debugging-clicked",{bubbles:true,composed:true}))}onTitleLongTouch(){this.dispatchEvent(new CustomEvent("launch-advanced-options",{bubbles:true,composed:true}))}connectedCallback(){super.connectedCallback();if(this.isMeet||this.isDeviceRequisitionConfigurable){const title=this.shadowRoot?.querySelector("#title");assert(title instanceof HTMLElement);this.titleLongTouchDetector=new LongTouchDetector(title,(()=>void this.onTitleLongTouch()))}this.getChromeVoxHintDialog().addEventListener("keydown",(event=>{if(this.getChromeVoxHintDialog().open&&event.key===" "){this.activateChromeVox();event.preventDefault();event.stopPropagation()}}));this.focus()}focus(){if(!this.focusedElement){this.focusedElement="getStarted"}const elem=this.shadowRoot?.querySelector("#"+this.focusedElement);assert(elem instanceof HTMLElement);elem.focus()}updateHidden(newValue,_oldValue){const visible=!newValue;if(visible){this.focus()}this.setVideoPlay(visible)}setVideoPlay(play){if(!this.isOobeLoaded){document.addEventListener("oobe-screens-loaded",(()=>{this.isOobeLoaded=true;this.setVideoPlay(play)}),{once:true});return}const welcomeAnimation=this.shadowRoot?.querySelector("#welcomeAnimation");if(welcomeAnimation instanceof OobeCrLottie){welcomeAnimation.playing=play}}formatMessage(label,parameter){return loadTimeData.getStringF(label,parameter)}getChromeVoxHintDialog(){const dialog=this.shadowRoot?.querySelector("#chromeVoxHint");assert(dialog instanceof OobeModalDialog);return dialog}showChromeVoxHint(){this.getChromeVoxHintDialog().showDialog();this.setVideoPlay(false)}closeChromeVoxHint(){this.setVideoPlay(true);this.getChromeVoxHintDialog().hideDialog()}dismissChromeVoxHint(){this.dispatchEvent(new CustomEvent("chromevox-hint-dismissed",{bubbles:true,composed:true}));this.closeChromeVoxHint()}activateChromeVox(){this.closeChromeVoxHint();this.dispatchEvent(new CustomEvent("chromevox-hint-accepted",{bubbles:true,composed:true}))}showAnimationSlot(){return!this.isBootAnimation}}customElements.define(OobeWelcomeDialog.is,OobeWelcomeDialog);