// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/js/action_link.js";import"//resources/polymer/v3_0/iron-icon/iron-icon.js";import"../../components/oobe_icons.html.js";import"../../components/common_styles/oobe_common_styles.css.js";import"../../components/common_styles/oobe_dialog_host_styles.css.js";import"../../components/buttons/oobe_text_button.js";import{assert}from"//resources/js/assert.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{OobeAdaptiveDialog}from"../../components/dialogs/oobe_adaptive_dialog.js";import{OobeUiState}from"../../components/display_manager_types.js";import{LoginScreenMixin}from"../../components/mixins/login_screen_mixin.js";import{OobeDialogHostMixin}from"../../components/mixins/oobe_dialog_host_mixin.js";import{OobeI18nMixin}from"../../components/mixins/oobe_i18n_mixin.js";import{getTemplate}from"./factor_setup_success.html.js";const FactorSetupSuccessBase=OobeDialogHostMixin(LoginScreenMixin(OobeI18nMixin(PolymerElement)));var ModifiedFactors;(function(ModifiedFactors){ModifiedFactors["ONLINE_PASSWORD"]="online";ModifiedFactors["LOCAL_PASSWORD"]="local";ModifiedFactors["ONLINE_PASSWORD_AND_PIN"]="online+pin";ModifiedFactors["LOCAL_PASSWORD_AND_PIN"]="local+pin";ModifiedFactors["PIN"]="pin"})(ModifiedFactors||(ModifiedFactors={}));var ChangeMode;(function(ChangeMode){ChangeMode["INITIAL_SETUP"]="set";ChangeMode["RECOVERY_FLOW"]="update"})(ChangeMode||(ChangeMode={}));const ACTION_PROCEED="proceed";export class FactorSetupSuccessScreen extends FactorSetupSuccessBase{static get is(){return"factor-setup-success-element"}static get template(){return getTemplate()}static get properties(){return{hasNextStep:{type:Boolean,value:true},buttonsEnabled:{type:Boolean,value:false},factors:{type:String,value:ModifiedFactors.ONLINE_PASSWORD},changeMode:{type:String,value:ChangeMode.INITIAL_SETUP}}}ready(){super.ready();this.initializeLoginScreen("FactorSetupSuccessScreen")}getOobeUIInitialState(){return OobeUiState.BLOCKING}get defaultControl(){const dialog=this.shadowRoot?.querySelector("#factorSetupSuccessDialog");assert(dialog instanceof OobeAdaptiveDialog);return dialog}onBeforeShow(data){super.onBeforeShow(data);this.factors=data["modifiedFactors"];this.changeMode=data["changeMode"];this.hasNextStep=this.changeMode===ChangeMode.INITIAL_SETUP;this.buttonsEnabled=true}getTitle(locale,factors,changeMode){if(changeMode===ChangeMode.INITIAL_SETUP){if(factors===ModifiedFactors.LOCAL_PASSWORD){return this.i18nDynamic(locale,"factorSuccessTitleLocalPasswordSet")}return this.i18nDynamic(locale,"factorSuccessTitleLocalPasswordSet")}else{if(factors===ModifiedFactors.LOCAL_PASSWORD){return this.i18nDynamic(locale,"factorSuccessTitleLocalPasswordUpdated")}return this.i18nDynamic(locale,"factorSuccessTitleLocalPasswordUpdated")}}getSubtitle(locale,factors){if(factors===ModifiedFactors.LOCAL_PASSWORD){return this.i18nDynamic(locale,"factorSuccessSubtitleLocalPassword")}return undefined}onProceed(){if(!this.buttonsEnabled){return}this.buttonsEnabled=false;this.userActed(ACTION_PROCEED)}}customElements.define(FactorSetupSuccessScreen.is,FactorSetupSuccessScreen);