// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/polymer/v3_0/iron-icon/iron-icon.js";import"../../components/oobe_icons.html.js";import"../../components/common_styles/oobe_common_styles.css.js";import"../../components/common_styles/oobe_dialog_host_styles.css.js";import{FingerprintProgressElement}from"//resources/ash/common/quick_unlock/fingerprint_progress.js";import{loadTimeData}from"//resources/js/load_time_data.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{OobeUiState}from"../../components/display_manager_types.js";import{LoginScreenMixin}from"../../components/mixins/login_screen_mixin.js";import{MultiStepMixin}from"../../components/mixins/multi_step_mixin.js";import{OobeI18nMixin}from"../../components/mixins/oobe_i18n_mixin.js";import{OobeCrLottie}from"../../components/oobe_cr_lottie.js";import{getTemplate}from"./fingerprint_setup.html.js";var FingerprintResultType;(function(FingerprintResultType){FingerprintResultType[FingerprintResultType["SUCCESS"]=0]="SUCCESS";FingerprintResultType[FingerprintResultType["PARTIAL"]=1]="PARTIAL";FingerprintResultType[FingerprintResultType["INSUFFICIENT"]=2]="INSUFFICIENT";FingerprintResultType[FingerprintResultType["SENSOR_DIRTY"]=3]="SENSOR_DIRTY";FingerprintResultType[FingerprintResultType["TOO_SLOW"]=4]="TOO_SLOW";FingerprintResultType[FingerprintResultType["TOO_FAST"]=5]="TOO_FAST";FingerprintResultType[FingerprintResultType["IMMOBILE"]=6]="IMMOBILE"})(FingerprintResultType||(FingerprintResultType={}));var FingerprintUiState;(function(FingerprintUiState){FingerprintUiState["START"]="start";FingerprintUiState["PROGRESS"]="progress"})(FingerprintUiState||(FingerprintUiState={}));const FingerprintSetupBase=LoginScreenMixin(MultiStepMixin(OobeI18nMixin(PolymerElement)));export class FingerprintSetup extends FingerprintSetupBase{static get is(){return"fingerprint-setup-element"}static get template(){return getTemplate()}static get properties(){return{percentComplete:{type:Number,value:0,observer:"onProgressChanged"},complete:{type:Boolean,value:false,computed:"enrollIsComplete(percentComplete)"},canAddFinger:{type:Boolean,value:true},scanResult:{type:Number,value:FingerprintResultType.SUCCESS},isChildAccount:{type:Boolean,value:false},isDynamicColor:{type:Boolean,value:loadTimeData.getBoolean("isOobeJellyEnabled")}}}constructor(){super()}get EXTERNAL_API(){return["onEnrollScanDone","enableAddAnotherFinger"]}get UI_STEPS(){return FingerprintUiState}ready(){super.ready();this.initializeLoginScreen("FingerprintSetupScreen")}getOobeUIInitialState(){return OobeUiState.ONBOARDING}defaultUIStep(){return FingerprintUiState.START}onBeforeShow(data){super.onBeforeShow(data);this.isChildAccount=data["isChildAccount"];this.setAnimationState(true)}onBeforeHide(){super.onBeforeHide();this.setAnimationState(false)}onEnrollScanDone(scanResult,_isComplete,percentComplete){this.setUIStep(FingerprintUiState.PROGRESS);const progress=this.shadowRoot?.querySelector("#arc");if(progress instanceof FingerprintProgressElement){progress.reset()}this.percentComplete=percentComplete;this.scanResult=scanResult}enableAddAnotherFinger(enable){this.canAddFinger=enable}isAnotherButtonVisible(percentComplete,canAddFinger){return percentComplete>=100&&canAddFinger}onSkipOnStart(){this.userActed("setup-skipped-on-start")}onSkipInProgress(){this.userActed("setup-skipped-in-flow")}setAnimationState(playing){const animation=this.shadowRoot?.querySelector("#scannerLocationLottie");if(animation instanceof OobeCrLottie){animation.playing=playing}const progress=this.shadowRoot?.querySelector("#arc");if(progress instanceof FingerprintProgressElement){progress.setPlay(playing)}}onDone(){this.userActed("setup-done")}onAddAnother(){this.percentComplete=0;this.userActed("add-another-finger")}enrollIsComplete(percent){return percent>=100}isProblemImmobile(scanResult){return scanResult===FingerprintResultType.IMMOBILE}isProblemOther(scanResult){return scanResult!==FingerprintResultType.SUCCESS&&scanResult!==FingerprintResultType.IMMOBILE}onProgressChanged(newValue,oldValue){if(newValue===0){const progress=this.shadowRoot?.querySelector("#arc");if(progress instanceof FingerprintProgressElement){progress.reset()}this.scanResult=FingerprintResultType.SUCCESS;return}const progress=this.shadowRoot?.querySelector("#arc");if(progress instanceof FingerprintProgressElement){progress.setProgress(oldValue,newValue,newValue===100)}}}customElements.define(FingerprintSetup.is,FingerprintSetup);