// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/ash/common/cr_elements/cros_color_overrides.css.js";import"//resources/ash/common/cr_elements/cr_input/cr_input.js";import"//resources/polymer/v3_0/iron-icon/iron-icon.js";import"../../components/oobe_icons.html.js";import"../../components/buttons/oobe_next_button.js";import"../../components/common_styles/oobe_common_styles.css.js";import"../../components/common_styles/oobe_dialog_host_styles.css.js";import"../../components/dialogs/oobe_adaptive_dialog.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{OobeUiState}from"../../components/display_manager_types.js";import{LoginScreenMixin}from"../../components/mixins/login_screen_mixin.js";import{OobeDialogHostMixin}from"../../components/mixins/oobe_dialog_host_mixin.js";import{OobeI18nMixin}from"../../components/mixins/oobe_i18n_mixin.js";import{LocalDataLossWarningPageHandlerRemote}from"../../mojom-webui/screens_osauth.mojom-webui.js";import{OobeScreensFactoryBrowserProxy}from"../../oobe_screens_factory_proxy.js";import{getTemplate}from"./local_data_loss_warning.html.js";const LocalDataLossWarningBase=OobeDialogHostMixin(LoginScreenMixin(OobeI18nMixin(PolymerElement)));export class LocalDataLossWarning extends LocalDataLossWarningBase{static get is(){return"local-data-loss-warning-element"}static get template(){return getTemplate()}static get properties(){return{email:{type:String,value:""},disabled:{type:Boolean},isOwner:{type:Boolean},canGoBack:{type:Boolean}}}constructor(){super();this.disabled=false;this.handler=new LocalDataLossWarningPageHandlerRemote;OobeScreensFactoryBrowserProxy.getInstance().screenFactory.establishLocalDataLossWarningScreenPipe(this.handler.$.bindNewPipeAndPassReceiver())}ready(){super.ready();this.initializeLoginScreen("LocalDataLossWarningScreen");this.disabled=false}getOobeUIInitialState(){return OobeUiState.PASSWORD_CHANGED}onBeforeShow(data){super.onBeforeShow(data);this.isOwner=data["isOwner"];this.email=data["email"];this.canGoBack=data["canGoBack"];this.disabled=false}getDataLossWarningSubtitleMessage(locale,email){return this.i18nAdvancedDynamic(locale,"dataLossWarningSubtitle",{substitutions:[email]})}onProceedClicked(){if(this.disabled){return}this.disabled=true;this.handler.onRecreateUser()}onResetClicked(){if(this.disabled){return}this.disabled=true;this.handler.onPowerwash()}onBackButtonClicked(){if(this.disabled){return}this.disabled=true;this.handler.onBack()}onCancelClicked(){if(this.disabled){return}this.disabled=true;this.handler.onCancel()}}customElements.define(LocalDataLossWarning.is,LocalDataLossWarning);