import{html}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";export function getTemplate(){return html`<!--_html_template_start_--><!--
Copyright 2023 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->

<!--
  Local password setup UI
  Contains:
    1. Title
    2. Password input form.
-->
<style include="oobe-dialog-host-styles cros-color-overrides"></style>
<oobe-adaptive-dialog role="dialog" for-step="password">
  <iron-icon slot="icon" icon="oobe-32:lock"></iron-icon>
  <h1 slot="title">
    [[titleText(locale, isRecoveryFlow)]]
  </h1>
  <p slot="subtitle" hidden="[[isRecoveryFlow]]" aria-live="polite">
    [[i18nDynamic(locale,'localPasswordSetupSubtitle')]]
  </p>
  <div slot="content" class="landscape-vertical-centered">
    <set-local-password-input id="passwordInput" class="focus-on-show"
        first-input-aria-label="[[titleText(locale, isRecoveryFow)]]"
        value="{{passwordValue}}"
        on-submit="onSubmit">
    </set-local-password-input>
  </div>
  <div slot="back-navigation">
    <oobe-back-button id="backButton" on-click="onBackClicked"
        hidden="[[!backButtonVisible]]">
    </oobe-back-button>
  </div>
  <div slot="bottom-buttons">
    <oobe-next-button id="nextButton" on-click="onSubmit"
        disabled="[[!isValid(passwordValue)]]" inverse>
    </oobe-next-button>
  </div>
</oobe-adaptive-dialog>
<oobe-loading-dialog id="progress" role="dialog" for-step="progress"
    title-key="gaiaLoading">
  <iron-icon slot="icon" icon="oobe-32:googleg"></iron-icon>
</oobe-loading-dialog>
<!--_html_template_end_-->`}