// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/ash/common/auth_setup/set_local_password_input.js";import"//resources/ash/common/cr_elements/cros_color_overrides.css.js";import"//resources/ash/common/cr_elements/cr_shared_style.css.js";import"//resources/ash/common/cr_elements/cr_button/cr_button.js";import"//resources/polymer/v3_0/iron-icon/iron-icon.js";import"../../components/oobe_icons.html.js";import"../../components/common_styles/oobe_common_styles.css.js";import"../../components/common_styles/oobe_dialog_host_styles.css.js";import"../../components/dialogs/oobe_adaptive_dialog.js";import"../../components/dialogs/oobe_loading_dialog.js";import"../../components/buttons/oobe_next_button.js";import"../../components/buttons/oobe_back_button.js";import{SetLocalPasswordInputElement}from"//resources/ash/common/auth_setup/set_local_password_input.js";import{assert}from"//resources/js/assert.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{OobeUiState}from"../../components/display_manager_types.js";import{LoginScreenMixin}from"../../components/mixins/login_screen_mixin.js";import{MultiStepMixin}from"../../components/mixins/multi_step_mixin.js";import{OobeDialogHostMixin}from"../../components/mixins/oobe_dialog_host_mixin.js";import{OobeI18nMixin}from"../../components/mixins/oobe_i18n_mixin.js";import{getTemplate}from"./local_password_setup.html.js";var LocalPasswordSetupState;(function(LocalPasswordSetupState){LocalPasswordSetupState["PASSWORD"]="password";LocalPasswordSetupState["PROGRESS"]="progress"})(LocalPasswordSetupState||(LocalPasswordSetupState={}));const LocalPasswordSetupBase=OobeDialogHostMixin(LoginScreenMixin(MultiStepMixin(OobeI18nMixin(PolymerElement))));export class LocalPasswordSetup extends LocalPasswordSetupBase{static get is(){return"local-password-setup-element"}static get template(){return getTemplate()}static get properties(){return{backButtonVisible:{type:Boolean},isRecoveryFlow:{type:Boolean},passwordValue:{type:String,value:null}}}constructor(){super();this.backButtonVisible=true}get EXTERNAL_API(){return["showLocalPasswordSetupFailure"]}defaultUIStep(){return LocalPasswordSetupState.PASSWORD}get UI_STEPS(){return LocalPasswordSetupState}ready(){super.ready();this.initializeLoginScreen("LocalPasswordSetupScreen")}getOobeUIInitialState(){return OobeUiState.ONBOARDING}onBeforeShow(data){super.onBeforeShow(data);this.reset();this.backButtonVisible=data["showBackButton"];this.isRecoveryFlow=data["isRecoveryFlow"]}showLocalPasswordSetupFailure(){}reset(){const passwordInput=this.shadowRoot?.querySelector("#passwordInput");if(passwordInput instanceof SetLocalPasswordInputElement){passwordInput.reset()}}getPasswordInput(){const passwordInput=this.shadowRoot?.querySelector("#passwordInput");assert(passwordInput instanceof SetLocalPasswordInputElement);return passwordInput}onBackClicked(){if(!this.backButtonVisible){return}this.userActed(["back",this.getPasswordInput().value])}async onSubmit(){const passwordInput=this.getPasswordInput();await passwordInput.validate();if(passwordInput.value===null){return}this.setUIStep(LocalPasswordSetupState.PROGRESS);this.userActed(["inputPassword",passwordInput.value])}onDoneClicked(){this.userActed(["done"])}titleText(_locale,isRecoveryFlow){const key=isRecoveryFlow?"localPasswordResetTitle":"localPasswordSetupTitle";return this.i18n(key)}isValid(password){return!!password}}customElements.define(LocalPasswordSetup.is,LocalPasswordSetup);